/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.LookaheadParser;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.LookaheadStream;
import java.util.Optional;
import java.util.regex.Matcher;

public class ScalacParser
extends LookaheadParser {
    private static final long serialVersionUID = -4034552404001800574L;
    private static final String SCALAC_WARNING_PATTERN = "^(\\[WARNING\\]|\\[ERROR\\])\\s*(.*):(\\d+):\\s*([a-z]*):\\s*(.*)$";

    public ScalacParser() {
        super(SCALAC_WARNING_PATTERN);
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, LookaheadStream lookahead, IssueBuilder builder) {
        return builder.setFileName(matcher.group(2)).setLineStart(matcher.group(3)).setCategory(matcher.group(4)).setMessage(matcher.group(5)).setSeverity(this.mapPriority(matcher)).buildOptional();
    }

    private Severity mapPriority(Matcher matcher) {
        return "[ERROR]".equals(matcher.group(1)) ? Severity.WARNING_HIGH : Severity.WARNING_NORMAL;
    }
}

