/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.FormatMethod;
import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.Ensure;
import edu.hm.hafner.util.FilteredLog;
import edu.hm.hafner.util.Generated;
import edu.hm.hafner.util.LineRange;
import edu.hm.hafner.util.LineRangeList;
import edu.hm.hafner.util.PathUtil;
import edu.hm.hafner.util.TreeString;
import edu.hm.hafner.util.TreeStringBuilder;
import edu.hm.hafner.util.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class Report
implements Iterable<Issue>,
Serializable {
    private static final long serialVersionUID = 5L;
    @VisibleForTesting
    static final String DEFAULT_ID = "-";
    private String id;
    private String name;
    private String originReportFile;
    private String icon = "";
    private String parserId = "-";
    private IssueType elementType;
    private List<Report> subReports = new ArrayList<Report>();
    private Set<Issue> elements = new LinkedHashSet<Issue>();
    private List<String> infoMessages = new ArrayList<String>();
    private List<String> errorMessages = new ArrayList<String>();
    private Map<String, Integer> countersByKey = new HashMap<String, Integer>();
    private int duplicatesSize;

    public Report() {
        this(DEFAULT_ID, DEFAULT_ID, DEFAULT_ID);
    }

    public Report(String id, String name) {
        this(id, name, DEFAULT_ID);
    }

    public Report(String id, String name, String originReportFile) {
        this(id, name, originReportFile, IssueType.WARNING);
    }

    public Report(String id, String name, String originReportFile, IssueType elementType) {
        this.id = id;
        this.name = name;
        this.originReportFile = originReportFile;
        this.elementType = elementType;
    }

    public Report(Report ... reports) {
        this();
        Ensure.that((Object[])reports).isNotEmpty("No reports given.", new Object[0]);
        this.subReports.addAll(Arrays.asList(reports));
    }

    public Report(Collection<? extends Report> reports) {
        this();
        Ensure.that(reports).isNotEmpty("No reports given.", new Object[0]);
        this.subReports.addAll(reports);
    }

    public String getId() {
        return this.id;
    }

    private boolean hasId() {
        return this.isDefaultId(this.id);
    }

    public String getParserId() {
        return this.aggregateChildProperty(Report::getParserId, this.parserId);
    }

    public boolean hasParserId() {
        return this.isDefaultId(this.getParserId());
    }

    private boolean isDefaultId(String value) {
        return !DEFAULT_ID.equals(value) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{value});
    }

    public String getEffectiveId() {
        return this.aggregateChildProperty(Report::getEffectiveId, this.getId());
    }

    private String aggregateChildProperty(Function<Report, String> idProperty, String defaultId) {
        Set ids = this.subReports.stream().map(idProperty).collect(Collectors.toSet());
        ids.add(defaultId);
        ids.remove(DEFAULT_ID);
        if (ids.size() == 1) {
            return (String)ids.iterator().next();
        }
        return defaultId;
    }

    public String getName() {
        return this.name;
    }

    public void setOrigin(String originId, String originName) {
        String normalizedId = (String)StringUtils.defaultIfBlank((CharSequence)originId, (CharSequence)DEFAULT_ID);
        String normalizedName = (String)StringUtils.defaultIfBlank((CharSequence)originName, (CharSequence)DEFAULT_ID);
        this.id = normalizedId;
        this.name = normalizedName;
        this.subReports.forEach(report -> report.setOrigin(normalizedId, normalizedName));
        this.elements.forEach(issue -> issue.setOrigin(normalizedId, normalizedName));
    }

    private void setOrigin(String originId, String originName, IssueType originElementType) {
        this.setOrigin(originId, originName);
        this.elementType = originElementType;
        this.parserId = originId;
        this.subReports.forEach(report -> report.setOrigin(this.id, this.name, originElementType));
        this.elements.forEach(issue -> issue.setOrigin(this.id, this.name));
    }

    public void setOrigin(String originId, String originName, IssueType elementType, String reportFile) {
        this.setOrigin(originId, originName, elementType);
        this.setOriginReportFile(reportFile);
    }

    public String getEffectiveName() {
        return this.aggregateChildProperty(Report::getEffectiveName, this.getName());
    }

    public String getOriginReportFile() {
        return this.originReportFile;
    }

    public void setOriginReportFile(String originReportFile) {
        this.originReportFile = new PathUtil().getAbsolutePath(originReportFile);
    }

    public Set<String> getOriginReportFiles() {
        Set<String> files = this.subReports.stream().map(Report::getOriginReportFiles).flatMap(Collection::stream).collect(Collectors.toSet());
        files.add(this.getOriginReportFile());
        files.remove(DEFAULT_ID);
        return files;
    }

    public IssueType getElementType() {
        if (this.elements.isEmpty()) {
            Set types = this.subReports.stream().map(Report::getElementType).collect(Collectors.toSet());
            if (types.size() > 1) {
                return IssueType.WARNING;
            }
            if (types.isEmpty()) {
                return this.elementType;
            }
            return (IssueType)((Object)types.iterator().next());
        }
        return this.elementType;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        if (StringUtils.isNotBlank((CharSequence)icon)) {
            this.icon = icon;
        }
    }

    @CanIgnoreReturnValue
    public Report add(Issue issue) {
        if (this.hasId() && !issue.hasOrigin()) {
            issue.setOrigin(this.id, this.name);
        }
        if (this.contains(issue)) {
            ++this.duplicatesSize;
        } else {
            this.elements.add(issue);
        }
        return this;
    }

    @CanIgnoreReturnValue
    public Report addAll(Issue issue, Issue ... additionalIssues) {
        this.add(issue);
        for (Issue additional : additionalIssues) {
            this.add(additional);
        }
        return this;
    }

    @CanIgnoreReturnValue
    public Report addAll(Collection<? extends Issue> issues) {
        for (Issue issue : issues) {
            this.add(issue);
        }
        return this;
    }

    @CanIgnoreReturnValue
    public Report addAll(Report ... reports) {
        Ensure.that((Object[])reports).isNotEmpty("No reports given.", new Object[0]);
        ArrayList<Report> reportsToAdd = new ArrayList<Report>();
        for (Report report : reports) {
            if (!report.elements.isEmpty() && !report.subReports.isEmpty()) {
                throw new IllegalArgumentException("Reports should either contain issues as top-level elements or as leaf elements but not both.");
            }
            if (report.subReports.isEmpty()) {
                reportsToAdd.add(report);
                continue;
            }
            reportsToAdd.addAll(report.subReports);
            this.infoMessages.addAll(report.infoMessages);
            this.errorMessages.addAll(report.errorMessages);
        }
        for (Report report : reportsToAdd) {
            Report copyWithoutDuplicates = report.copyEmptyInstance();
            for (Issue issue : report) {
                if (this.contains(issue)) {
                    ++this.duplicatesSize;
                    continue;
                }
                copyWithoutDuplicates.add(issue);
            }
            this.subReports.add(copyWithoutDuplicates);
        }
        return this;
    }

    private boolean contains(Issue issue) {
        return this.elements.contains(issue) || this.subReportsContains(issue) != false;
    }

    private Boolean subReportsContains(Issue issue) {
        return this.subReports.stream().map(r -> r.contains(issue)).reduce(Boolean::logicalOr).orElse(false);
    }

    @VisibleForTesting
    List<Report> getSubReports() {
        return this.subReports;
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="Deserialization of instances that do not have all fields yet")
    protected Object readResolve() {
        if (this.countersByKey == null) {
            this.countersByKey = new HashMap<String, Integer>();
        }
        if (this.subReports == null) {
            this.subReports = new ArrayList<Report>();
            this.id = DEFAULT_ID;
            this.name = DEFAULT_ID;
            this.originReportFile = DEFAULT_ID;
        }
        if (this.parserId == null) {
            this.parserId = DEFAULT_ID;
            this.icon = DEFAULT_ID;
            this.elementType = IssueType.WARNING;
        }
        return this;
    }

    Issue remove(UUID issueId) {
        Optional<Issue> issue = this.removeIfContained(issueId);
        if (issue.isPresent()) {
            return issue.get();
        }
        throw new NoSuchElementException("No removed found with id %s.".formatted(issueId));
    }

    private Optional<Issue> removeIfContained(UUID issueId) {
        Optional<Issue> issue = this.find(issueId);
        if (issue.isPresent()) {
            this.elements.remove(issue.get());
            return issue;
        }
        for (Report subReport : this.subReports) {
            issue = subReport.removeIfContained(issueId);
            if (!issue.isPresent()) continue;
            return issue;
        }
        return Optional.empty();
    }

    private Optional<Issue> find(UUID issueId) {
        return this.elements.stream().filter((? super T issue) -> issue.getId().equals(issueId)).findAny();
    }

    public Issue findById(UUID issueId) {
        return this.stream().filter((? super T issue) -> issue.getId().equals(issueId)).findAny().orElseThrow(() -> new NoSuchElementException("No issue found with id %s.".formatted(issueId)));
    }

    public Set<Issue> findByProperty(Predicate<? super Issue> criterion) {
        return this.filterElements(criterion).collect(Collectors.toSet());
    }

    public Report filter(Predicate<? super Issue> criterion) {
        Report filtered = this.copyEmptyInstance();
        filtered.addAll(this.elements.stream().filter(criterion).collect(Collectors.toList()));
        for (Report subReport : this.subReports) {
            filtered.addAll(subReport.filter(criterion));
        }
        return filtered;
    }

    private Stream<Issue> filterElements(Predicate<? super Issue> criterion) {
        return this.stream().filter(criterion);
    }

    @Override
    @NonNull
    public Iterator<Issue> iterator() {
        return this.stream().iterator();
    }

    public Stream<Issue> stream() {
        return Stream.concat(this.elements.stream(), this.subReports.stream().flatMap(Report::stream));
    }

    public Collection<Issue> get() {
        return this.stream().collect(Collectors.toList());
    }

    public Issue get(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("No such index " + index + " in " + String.valueOf(this));
        }
        Iterator<Issue> all = this.iterator();
        for (int i = 0; i < index; ++i) {
            all.next();
        }
        return all.next();
    }

    public Collection<Issue> getInModifiedCode() {
        return this.stream().filter(Issue::isPartOfModifiedCode).collect(Collectors.toList());
    }

    public int size() {
        return this.elements.size() + this.subReports.stream().mapToInt(Report::size).sum();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public int getSize() {
        return this.size();
    }

    public int getDuplicatesSize() {
        return this.duplicatesSize + this.subReports.stream().mapToInt(Report::getDuplicatesSize).sum();
    }

    public int getSizeOf(String severity) {
        return this.getSizeOf(Severity.valueOf(severity));
    }

    public int getSizeOf(Severity severity) {
        return this.stream().filter((? super T issue) -> issue.getSeverity().equals(severity)).mapToInt(e -> 1).sum();
    }

    public String toString() {
        String summary = String.format(Locale.ENGLISH, "%s%s%s", this.getNamePrefix(), this.getSummary(), this.getDuplicates());
        return summary + this.getSeverityDistribution();
    }

    public String getSeverityDistribution() {
        String severityDistribution = Severity.getPredefinedValues().stream().map(this::reportSeverity).flatMap(Optional::stream).collect(Collectors.joining(", "));
        if (StringUtils.isEmpty((CharSequence)severityDistribution)) {
            return severityDistribution;
        }
        return " (" + severityDistribution + ")";
    }

    public String getSummary() {
        return this.getItemName(this.size());
    }

    private String getNamePrefix() {
        if (this.isEmptyOrDefault(this.getName()) && this.isEmptyOrDefault(this.getId())) {
            return "";
        }
        return String.format(Locale.ENGLISH, "%s (%s): ", this.getName(), this.getId());
    }

    private boolean isEmptyOrDefault(String value) {
        return StringUtils.isEmpty((CharSequence)value) || DEFAULT_ID.equals(value);
    }

    private Optional<String> reportSeverity(Severity severity) {
        int size = this.getSizeOf(severity);
        if (size > 0) {
            return Optional.of(String.format(Locale.ENGLISH, "%s: %d", StringUtils.lowerCase((String)severity.getName()), size));
        }
        return Optional.empty();
    }

    private String getItemName(int size) {
        String items = this.getItemCount(size);
        if (size == 0) {
            return String.format("No %s", items);
        }
        return String.format(Locale.ENGLISH, "%d %s", size, items);
    }

    private String getItemCount(int count) {
        if (count == 1) {
            return switch (this.getElementType().ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> "warning";
                case 1 -> "bug";
                case 3 -> "duplication";
                case 2 -> "vulnerability";
            };
        }
        return switch (this.getElementType().ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> "warnings";
            case 1 -> "bugs";
            case 3 -> "duplications";
            case 2 -> "vulnerabilities";
        };
    }

    private String getDuplicates() {
        if (this.duplicatesSize > 0) {
            return String.format(Locale.ENGLISH, " (%d duplicates)", this.duplicatesSize);
        }
        return "";
    }

    public Set<String> getModules() {
        return this.getProperties(Issue::getModuleName);
    }

    public boolean hasModules() {
        return this.hasProperty(this.getModules());
    }

    private boolean hasProperty(Set<String> propertyValues) {
        return propertyValues.size() > 1 || this.hasMeaningfulValues(propertyValues);
    }

    private boolean hasMeaningfulValues(Set<String> propertyValue) {
        return propertyValue.size() == 1 && !propertyValue.contains(DEFAULT_ID) && !propertyValue.contains("");
    }

    public Set<String> getPackages() {
        return this.getProperties(Issue::getPackageName);
    }

    public boolean hasPackages() {
        return this.hasProperty(this.getPackages());
    }

    public Set<String> getFolders() {
        return this.getProperties(Issue::getFolder);
    }

    public boolean hasFolders() {
        Set<String> packages = this.getPackages();
        packages.remove(DEFAULT_ID);
        return this.hasProperty(this.getFolders()) && packages.isEmpty();
    }

    public Set<String> getAbsolutePaths() {
        return this.getProperties(Issue::getAbsolutePath);
    }

    public Set<String> getFiles() {
        return this.getProperties(Issue::getFileName);
    }

    public boolean hasFiles() {
        return this.hasProperty(this.getFiles());
    }

    public Set<String> getCategories() {
        return this.getProperties(Issue::getCategory);
    }

    public boolean hasCategories() {
        return this.hasProperty(this.getCategories());
    }

    public Set<String> getTypes() {
        return this.getProperties(Issue::getType);
    }

    public boolean hasTypes() {
        return this.hasProperty(this.getTypes());
    }

    public Set<String> getTools() {
        return this.getProperties(Issue::getOrigin);
    }

    public boolean hasTools() {
        return this.hasProperty(this.getTools());
    }

    public Set<Severity> getSeverities() {
        return this.getProperties(Issue::getSeverity);
    }

    public boolean hasSeverities() {
        return this.getSeverities().size() > 1;
    }

    public <T> Set<T> getProperties(Function<? super Issue, T> propertyMapper) {
        return this.stream().map(propertyMapper).collect(Collectors.toSet());
    }

    public <T> Map<T, Integer> getPropertyCount(Function<? super Issue, T> propertyMapper) {
        return this.stream().collect(Collectors.groupingBy(propertyMapper, Collectors.reducing(0, issue -> 1, Integer::sum)));
    }

    public Map<String, Report> groupByProperty(String propertyName) {
        Map<String, List<Issue>> issues = this.stream().collect(Collectors.groupingBy(Issue.getPropertyValueGetter(propertyName)));
        return issues.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new Report().addAll((Collection)e.getValue())));
    }

    public Report copy() {
        Report copied = new Report();
        this.copyIssuesAndProperties(this, copied);
        return copied;
    }

    private void copyIssuesAndProperties(Report source, Report destination) {
        this.copyProperties(source, destination);
        destination.addAll(source.elements);
        for (Report subReport : this.subReports) {
            destination.addAll(subReport.copy());
        }
    }

    private void copyProperties(Report source, Report destination) {
        destination.id = source.getId();
        destination.name = source.getName();
        destination.icon = source.getIcon();
        destination.elementType = source.getElementType();
        destination.parserId = source.getParserId();
        destination.originReportFile = source.getOriginReportFile();
        destination.duplicatesSize += source.duplicatesSize;
        destination.infoMessages.addAll(source.infoMessages);
        destination.errorMessages.addAll(source.errorMessages);
        destination.countersByKey = Stream.concat(destination.countersByKey.entrySet().stream(), source.countersByKey.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Integer::sum));
    }

    public Report copyEmptyInstance() {
        Report empty = new Report();
        this.copyProperties(this, empty);
        return empty;
    }

    public void mergeLogMessages(FilteredLog log) {
        this.infoMessages.addAll(log.getInfoMessages());
        this.errorMessages.addAll(log.getErrorMessages());
    }

    @FormatMethod
    public void logInfo(String format, Object ... args) {
        this.infoMessages.add(format.formatted(args));
    }

    @FormatMethod
    public void logError(String format, Object ... args) {
        this.errorMessages.add(format.formatted(args));
    }

    @FormatMethod
    public void logException(Exception exception, String format, Object ... args) {
        this.logError(format, args);
        Collections.addAll(this.errorMessages, ExceptionUtils.getRootCauseStackTrace((Throwable)exception));
    }

    public List<String> getInfoMessages() {
        return this.mergeMessages(this.infoMessages, Report::getInfoMessages);
    }

    public List<String> getErrorMessages() {
        return this.mergeMessages(this.errorMessages, Report::getErrorMessages);
    }

    private List<String> mergeMessages(List<String> thisMessages, Function<Report, List<String>> sumMessages) {
        return Stream.concat(this.subReports.stream().map(sumMessages).flatMap(Collection::stream), thisMessages.stream()).collect(Collectors.toList());
    }

    public boolean hasErrors() {
        return !this.getErrorMessages().isEmpty();
    }

    @Generated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Report issues = (Report)o;
        return this.duplicatesSize == issues.duplicatesSize && Objects.equals(this.id, issues.id) && Objects.equals(this.name, issues.name) && Objects.equals(this.icon, issues.icon) && Objects.equals((Object)this.elementType, (Object)issues.elementType) && Objects.equals(this.parserId, issues.parserId) && Objects.equals(this.originReportFile, issues.originReportFile) && Objects.equals(this.subReports, issues.subReports) && Objects.equals(this.elements, issues.elements) && Objects.equals(this.infoMessages, issues.infoMessages) && Objects.equals(this.errorMessages, issues.errorMessages) && Objects.equals(this.countersByKey, issues.countersByKey);
    }

    @Generated
    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.icon, this.elementType, this.parserId, this.originReportFile, this.subReports, this.elements, this.infoMessages, this.errorMessages, this.countersByKey, this.duplicatesSize});
    }

    private void writeObject(ObjectOutputStream output) throws IOException {
        output.writeInt(this.elements.size());
        this.writeIssues(output);
        output.writeObject(this.infoMessages);
        output.writeObject(this.errorMessages);
        output.writeObject(this.countersByKey);
        output.writeInt(this.duplicatesSize);
        output.writeUTF(this.id);
        output.writeUTF(this.name);
        output.writeUTF(this.icon);
        output.writeUTF(this.parserId);
        output.writeObject((Object)this.elementType);
        output.writeUTF(this.originReportFile);
        output.writeInt(this.subReports.size());
        for (Report subReport : this.subReports) {
            output.writeObject(subReport);
        }
    }

    private void writeIssues(ObjectOutputStream output) throws IOException {
        for (Issue issue : this.elements) {
            output.writeUTF(issue.getPath());
            output.writeUTF(issue.getFileName());
            output.writeInt(issue.getLineStart());
            output.writeInt(issue.getLineEnd());
            output.writeInt(issue.getColumnStart());
            output.writeInt(issue.getColumnEnd());
            output.writeObject(issue.getLineRanges());
            output.writeUTF(issue.getCategory());
            output.writeUTF(issue.getType());
            output.writeUTF(issue.getPackageName());
            output.writeUTF(issue.getModuleName());
            output.writeUTF(issue.getSeverity().getName());
            this.writeLongString(output, issue.getMessage());
            this.writeLongString(output, issue.getDescription());
            output.writeUTF(issue.getOrigin());
            output.writeUTF(issue.getOriginName());
            output.writeUTF(issue.getReference());
            output.writeUTF(issue.getFingerprint());
            output.writeObject(issue.getAdditionalProperties());
            output.writeObject(issue.getId());
        }
    }

    private void writeLongString(ObjectOutputStream output, String value) throws IOException {
        output.writeInt(value.length());
        output.writeChars(value);
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        this.elements = new LinkedHashSet<Issue>();
        this.readIssues(input, input.readInt());
        this.infoMessages = (List)input.readObject();
        this.errorMessages = (List)input.readObject();
        this.countersByKey = (Map)input.readObject();
        this.duplicatesSize = input.readInt();
        this.id = input.readUTF();
        this.name = input.readUTF();
        this.icon = input.readUTF();
        this.parserId = input.readUTF();
        this.elementType = (IssueType)((Object)input.readObject());
        this.originReportFile = input.readUTF();
        this.subReports = new ArrayList<Report>();
        int subReportCount = input.readInt();
        for (int i = 0; i < subReportCount; ++i) {
            Report subReport = (Report)input.readObject();
            this.subReports.add(subReport);
        }
    }

    @SuppressFBWarnings(value={"OBJECT_DESERIALIZATION"})
    private void readIssues(ObjectInputStream input, int size) throws IOException, ClassNotFoundException {
        TreeStringBuilder builder = new TreeStringBuilder();
        for (int i = 0; i < size; ++i) {
            String path = input.readUTF();
            TreeString fileName = builder.intern(input.readUTF());
            int lineStart = input.readInt();
            int lineEnd = input.readInt();
            int columnStart = input.readInt();
            int columnEnd = input.readInt();
            LineRangeList lineRanges = (LineRangeList)input.readObject();
            String category = input.readUTF();
            String type = input.readUTF();
            TreeString packageName = builder.intern(input.readUTF());
            String moduleName = input.readUTF();
            Severity severity = Severity.valueOf(input.readUTF());
            TreeString message = builder.intern(this.readLongString(input));
            String description = this.readLongString(input);
            String origin = input.readUTF();
            String originName = input.readUTF();
            String reference = input.readUTF();
            String fingerprint = input.readUTF();
            Serializable additionalProperties = (Serializable)input.readObject();
            UUID uuid = (UUID)input.readObject();
            Issue issue = new Issue(path, fileName, lineStart, lineEnd, columnStart, columnEnd, (Iterable<? extends LineRange>)lineRanges, category, type, packageName, moduleName, severity, message, description, origin, originName, reference, fingerprint, additionalProperties, uuid);
            this.elements.add(issue);
        }
        builder.dedup();
    }

    private String readLongString(ObjectInputStream input) throws IOException {
        int messageLength = input.readInt();
        if (messageLength < 0) {
            throw new IllegalStateException("Can't read requested number of characters " + messageLength);
        }
        char[] chars = new char[messageLength];
        for (int j = 0; j < chars.length; ++j) {
            chars[j] = input.readChar();
        }
        return String.valueOf(chars);
    }

    public String getNameOfOrigin(String origin) {
        if (this.getId().equals(origin)) {
            return this.getName();
        }
        for (Report subReport : this.subReports) {
            String nameOfSubReport = subReport.getNameOfOrigin(origin);
            if (DEFAULT_ID.equals(nameOfSubReport)) continue;
            return nameOfSubReport;
        }
        return DEFAULT_ID;
    }

    public void setCounter(String key, int value) {
        this.countersByKey.put(Objects.requireNonNull(key), value);
    }

    public void setReference(String reference) {
        this.stream().forEach(issue -> issue.setReference(reference));
    }

    public int getCounter(String key) {
        return this.countersByKey.getOrDefault(key, 0) + this.subReports.stream().mapToInt(r -> r.getCounter(key)).sum();
    }

    public boolean hasCounter(String key) {
        return this.countersByKey.containsKey(key);
    }

    public static enum IssueType {
        WARNING,
        BUG,
        VULNERABILITY,
        DUPLICATION;

    }

    public static class IssueFilterBuilder {
        private final Collection<Predicate<Issue>> includeFilters = new ArrayList<Predicate<Issue>>();
        private final Collection<Predicate<Issue>> excludeFilters = new ArrayList<Predicate<Issue>>();

        private void addNewFilter(Collection<String> patterns, Function<Issue, String> propertyToFilter, FilterType type) {
            ArrayList<Predicate<Issue>> filters = new ArrayList<Predicate<Issue>>();
            for (String pattern : patterns) {
                filters.add(issueToFilter -> Pattern.compile(pattern, 32).matcher((CharSequence)propertyToFilter.apply((Issue)issueToFilter)).find() == this.isIncludeFilter(type));
            }
            if (this.isIncludeFilter(type)) {
                this.includeFilters.addAll(filters);
            } else {
                this.excludeFilters.addAll(filters);
            }
        }

        private boolean isIncludeFilter(FilterType type) {
            return type == FilterType.INCLUDE;
        }

        public Predicate<Issue> build() {
            return this.includeFilters.stream().reduce(Predicate::or).orElse(issue -> true).and(this.excludeFilters.stream().reduce(Predicate::and).orElse(issue -> true));
        }

        @CanIgnoreReturnValue
        public IssueFilterBuilder setIncludeFileNameFilter(Collection<String> patterns) {
            this.addNewFilter(patterns, Issue::getFileName, FilterType.INCLUDE);
            return this;
        }

        @CanIgnoreReturnValue
        public IssueFilterBuilder setIncludeFileNameFilter(String ... patterns) {
            return this.setIncludeFileNameFilter(Arrays.asList(patterns));
        }

        @CanIgnoreReturnValue
        public IssueFilterBuilder setExcludeFileNameFilter(Collection<String> patterns) {
            this.addNewFilter(patterns, Issue::getFileName, FilterType.EXCLUDE);
            return this;
        }

        @CanIgnoreReturnValue
        public IssueFilterBuilder setExcludeFileNameFilter(String ... patterns) {
            return this.setExcludeFileNameFilter(Arrays.asList(patterns));
        }

        @CanIgnoreReturnValue
        public IssueFilterBuilder setIncludePackageNameFilter(Collection<String> patterns) {
            this.addNewFilter(patterns, Issue::getPackageName, FilterType.INCLUDE);
            return this;
        }

        @CanIgnoreReturnValue
        public IssueFilterBuilder setIncludePackageNameFilter(String ... patterns) {
            return this.setIncludePackageNameFilter(Arrays.asList(patterns));
        }

        @CanIgnoreReturnValue
        public IssueFilterBuilder setExcludePackageNameFilter(Collection<String> patterns) {
            this.addNewFilter(patterns, Issue::getPackageName, FilterType.EXCLUDE);
            return this;
        }

        @CanIgnoreReturnValue
        public IssueFilterBuilder setExcludePackageNameFilter(String ... patterns) {
            return this.setExcludePackageNameFilter(Arrays.asList(patterns));
        }

        @CanIgnoreReturnValue
        public IssueFilterBuilder setIncludeModuleNameFilter(Collection<String> patterns) {
            this.addNewFilter(patterns, Issue::getModuleName, FilterType.INCLUDE);
            return this;
        }

        @CanIgnoreReturnValue
        public IssueFilterBuilder setIncludeModuleNameFilter(String ... patterns) {
            return this.setIncludeModuleNameFilter(Arrays.asList(patterns));
        }

        @CanIgnoreReturnValue
        public IssueFilterBuilder setExcludeModuleNameFilter(Collection<String> patterns) {
            this.addNewFilter(patterns, Issue::getModuleName, FilterType.EXCLUDE);
            return this;
        }

        @CanIgnoreReturnValue
        public IssueFilterBuilder setExcludeModuleNameFilter(String ... patterns) {
            return this.setExcludeModuleNameFilter(Arrays.asList(patterns));
        }

        @CanIgnoreReturnValue
        public IssueFilterBuilder setIncludeCategoryFilter(Collection<String> patterns) {
            this.addNewFilter(patterns, Issue::getCategory, FilterType.INCLUDE);
            return this;
        }

        @CanIgnoreReturnValue
        public IssueFilterBuilder setIncludeCategoryFilter(String ... patterns) {
            return this.setIncludeCategoryFilter(Arrays.asList(patterns));
        }

        @CanIgnoreReturnValue
        public IssueFilterBuilder setExcludeCategoryFilter(Collection<String> patterns) {
            this.addNewFilter(patterns, Issue::getCategory, FilterType.EXCLUDE);
            return this;
        }

        @CanIgnoreReturnValue
        public IssueFilterBuilder setExcludeCategoryFilter(String ... patterns) {
            return this.setExcludeCategoryFilter(Arrays.asList(patterns));
        }

        @CanIgnoreReturnValue
        public IssueFilterBuilder setIncludeTypeFilter(Collection<String> patterns) {
            this.addNewFilter(patterns, Issue::getType, FilterType.INCLUDE);
            return this;
        }

        @CanIgnoreReturnValue
        public IssueFilterBuilder setIncludeTypeFilter(String ... patterns) {
            return this.setIncludeTypeFilter(Arrays.asList(patterns));
        }

        @CanIgnoreReturnValue
        public IssueFilterBuilder setExcludeTypeFilter(Collection<String> patterns) {
            this.addNewFilter(patterns, Issue::getType, FilterType.EXCLUDE);
            return this;
        }

        @CanIgnoreReturnValue
        public IssueFilterBuilder setExcludeTypeFilter(String ... patterns) {
            return this.setExcludeTypeFilter(Arrays.asList(patterns));
        }

        @CanIgnoreReturnValue
        public IssueFilterBuilder setIncludeMessageFilter(Collection<String> patterns) {
            this.addMessageFilter(patterns, FilterType.INCLUDE);
            return this;
        }

        @CanIgnoreReturnValue
        public IssueFilterBuilder setIncludeMessageFilter(String ... patterns) {
            return this.setIncludeMessageFilter(Arrays.asList(patterns));
        }

        @CanIgnoreReturnValue
        public IssueFilterBuilder setExcludeMessageFilter(Collection<String> patterns) {
            this.addMessageFilter(patterns, FilterType.EXCLUDE);
            return this;
        }

        @CanIgnoreReturnValue
        public IssueFilterBuilder setExcludeMessageFilter(String ... patterns) {
            return this.setExcludeMessageFilter(Arrays.asList(patterns));
        }

        private void addMessageFilter(Collection<String> patterns, FilterType filterType) {
            this.addNewFilter(patterns, issue -> "%s%n%s".formatted(issue.getMessage(), issue.getDescription()), filterType);
        }

        static enum FilterType {
            INCLUDE,
            EXCLUDE;

        }
    }
}

