/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.util.PathUtil;
import java.util.Map;
import java.util.Set;

public class IssuesInModifiedCodeMarker {
    private static final PathUtil PATH_UTIL = new PathUtil();

    public void markIssuesInModifiedCode(Report report, Map<String, Set<Integer>> modifiedLinesInFilesMapping) {
        for (Map.Entry<String, Set<Integer>> include : modifiedLinesInFilesMapping.entrySet()) {
            report.filter(issue -> this.affectsChangedLineInFile((Issue)issue, (String)include.getKey(), (Set)include.getValue())).stream().forEach(Issue::markAsPartOfModifiedCode);
        }
    }

    public void markIssuesInModifiedFiles(Report report, Set<String> modifiedFiles) {
        for (String fileName : modifiedFiles) {
            report.filter(issue -> this.affectsModifiedFile((Issue)issue, fileName)).stream().forEach(Issue::markAsPartOfModifiedCode);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean affectsChangedLineInFile(Issue issue, String fileName, Set<Integer> lines) {
        if (!this.affectsModifiedFile(issue, fileName)) return false;
        if (!lines.stream().anyMatch(issue::affectsLine)) return false;
        return true;
    }

    private boolean affectsModifiedFile(Issue issue, String fileName) {
        String normalizedPath = PATH_UTIL.getRelativePath(fileName);
        return issue.getFileName().endsWith(normalizedPath);
    }
}

