/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.table.coreimpl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.sourceforge.pmd.util.AssertionUtil;
import org.apache.commons.lang3.Validate;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class MostlySingularMultimap<K, V> {
    private static final MostlySingularMultimap EMPTY = new MostlySingularMultimap(Collections.emptyMap());
    private final Map<K, Object> map;

    private MostlySingularMultimap(Map<K, Object> map) {
        this.map = map;
    }

    public @NonNull List<V> get(K k) {
        Object vs = this.map.get(k);
        return MostlySingularMultimap.interpretValue(vs);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public boolean containsKey(Object v) {
        return this.map.containsKey(v);
    }

    public String toString() {
        return this.map.toString();
    }

    public void processValuesOneByOne(BiConsumer<K, V> consumer) {
        for (Map.Entry<K, Object> entry : this.map.entrySet()) {
            K k = entry.getKey();
            Object vs = entry.getValue();
            if (vs instanceof VList) {
                for (Object v : (VList)vs) {
                    consumer.accept(k, v);
                }
                continue;
            }
            consumer.accept(k, vs);
        }
    }

    private static <V> @NonNull List<V> interpretValue(Object vs) {
        if (vs == null) {
            return Collections.emptyList();
        }
        if (vs instanceof VList) {
            return (VList)vs;
        }
        return Collections.singletonList(vs);
    }

    public static <K, V> MostlySingularMultimap<K, V> empty() {
        return EMPTY;
    }

    public static <K, V> Builder<K, V> newBuilder(MapMaker<K> mapMaker) {
        return new Builder(mapMaker);
    }

    private static class VList<V>
    extends ArrayList<V> {
        VList(int size) {
            super(size);
        }
    }

    public static final class Builder<K, V> {
        private final MapMaker<K> mapMaker;
        private @Nullable Map<K, Object> map;
        private boolean consumed;
        private boolean isSingular = true;

        private Builder(MapMaker<K> mapMaker) {
            this.mapMaker = mapMaker;
        }

        private Map<K, Object> getMapInternal() {
            if (this.map == null) {
                this.map = this.mapMaker.copy(Collections.emptyMap());
                Validate.isTrue((boolean)this.map.isEmpty(), (String)"Map should be empty", (Object[])new Object[0]);
            }
            return this.map;
        }

        public void replaceValue(K key, V v) {
            this.checkKeyValue(key, v);
            this.getMapInternal().put(key, v);
        }

        public void addUnlessKeyExists(K key, V v) {
            this.checkKeyValue(key, v);
            this.getMapInternal().putIfAbsent(key, v);
        }

        public void appendValue(K key, V v) {
            this.appendValue(key, v, false);
        }

        public void appendValue(K key, V v, boolean noDuplicate) {
            this.checkKeyValue(key, v);
            this.getMapInternal().compute(key, (k, oldV) -> this.appendSingle(oldV, v, noDuplicate));
        }

        private void checkKeyValue(K key, V v) {
            this.ensureOpen();
            AssertionUtil.requireParamNotNull((String)"value", v);
            AssertionUtil.requireParamNotNull((String)"key", key);
        }

        public Builder<K, V> groupBy(Iterable<? extends V> values, Function<? super V, ? extends K> keyExtractor) {
            this.ensureOpen();
            return this.groupBy(values, keyExtractor, Function.identity());
        }

        public <I> Builder<K, V> groupBy(Iterable<? extends I> values, Function<? super I, ? extends K> keyExtractor, Function<? super I, ? extends V> valueExtractor) {
            this.ensureOpen();
            for (I i : values) {
                this.appendValue(keyExtractor.apply(i), valueExtractor.apply(i));
            }
            return this;
        }

        public Builder<K, V> absorb(Builder<K, V> other) {
            this.ensureOpen();
            super.ensureOpen();
            if (this.map == null) {
                this.map = other.map;
                this.isSingular = other.isSingular;
            } else {
                this.isSingular &= other.isSingular;
                for (Map.Entry<K, Object> otherEntry : super.getMapInternal().entrySet()) {
                    K key = otherEntry.getKey();
                    Object otherV = otherEntry.getValue();
                    this.map.compute(key, (k, myV) -> {
                        if (myV == null) {
                            return otherV;
                        }
                        if (otherV instanceof VList) {
                            Object newV = myV;
                            for (Object v : (VList)otherV) {
                                newV = this.appendSingle(newV, v, true);
                            }
                            return newV;
                        }
                        return this.appendSingle(myV, otherV, true);
                    });
                }
            }
            super.consume();
            return this;
        }

        private Object appendSingle(@Nullable Object vs, V v, boolean noDuplicate) {
            if (vs == null) {
                return v;
            }
            if (vs instanceof VList) {
                if (noDuplicate && ((VList)vs).contains(v)) {
                    return vs;
                }
                ((VList)vs).add(v);
                return vs;
            }
            if (noDuplicate && vs.equals(v)) {
                return vs;
            }
            VList vs2 = new VList(2);
            this.isSingular = false;
            vs2.add(vs);
            vs2.add(v);
            return vs2;
        }

        public MostlySingularMultimap<K, V> build() {
            this.consume();
            return this.isEmpty() ? MostlySingularMultimap.empty() : new MostlySingularMultimap(this.getMapInternal());
        }

        public @Nullable Map<K, V> buildAsSingular() {
            this.consume();
            if (!this.isSingular) {
                return null;
            }
            return this.map;
        }

        private void consume() {
            this.ensureOpen();
            this.consumed = true;
        }

        private void ensureOpen() {
            Validate.isTrue((!this.consumed ? 1 : 0) != 0, (String)"Builder was already consumed", (Object[])new Object[0]);
        }

        public boolean isSingular() {
            return this.isSingular;
        }

        public Map<K, List<V>> getMutableMap() {
            Map<K, List> mutable = this.mapMaker.copy(Collections.emptyMap());
            for (Map.Entry<K, Object> entry : this.getMapInternal().entrySet()) {
                mutable.put(entry.getKey(), MostlySingularMultimap.interpretValue(entry.getValue()));
            }
            return mutable;
        }

        public boolean isEmpty() {
            return this.map == null || this.map.isEmpty();
        }
    }

    @FunctionalInterface
    public static interface MapMaker<K> {
        public <V> Map<K, V> copy(Map<K, V> var1);
    }
}

