/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTClassLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorCall;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaExpression;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaParameter;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaParameterList;
import net.sourceforge.pmd.lang.java.ast.ASTList;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTMethodCall;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.java.ast.ASTStatement;
import net.sourceforge.pmd.lang.java.ast.ASTSuperExpression;
import net.sourceforge.pmd.lang.java.ast.ASTThisExpression;
import net.sourceforge.pmd.lang.java.ast.ASTTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTTypeExpression;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.ast.internal.PrettyPrintingUtil;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.JTypeDeclSymbol;
import net.sourceforge.pmd.lang.java.symbols.JVariableSymbol;
import net.sourceforge.pmd.lang.java.types.JClassType;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.OverloadSelectionResult;
import net.sourceforge.pmd.lang.java.types.TypeOps;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.reporting.RuleContext;

public class LambdaCanBeMethodReferenceRule
extends AbstractJavaRulechainRule {
    private static final PropertyDescriptor<Boolean> IGNORE_IF_MAY_NPE = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"ignoreIfMayNPE").desc("Ignore lambdas that may throw a null pointer exception (NPE) when converted to a method reference. Those expressions will NPE at mref creation time, while the equivalent lambda would NPE only when invoked (which may be never).")).defaultValue((Object)false)).build();
    private static final PropertyDescriptor<Boolean> IGNORE_IF_RECEIVER_IS_METHOD = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"ignoreIfReceiverIsMethod").desc("Ignore if the receiver of the method reference is a method call. These may cause side effects that often should prevent the conversion to a method reference.")).defaultValue((Object)true)).build();

    public LambdaCanBeMethodReferenceRule() {
        super(ASTLambdaExpression.class, new Class[0]);
        this.definePropertyDescriptor(IGNORE_IF_MAY_NPE);
        this.definePropertyDescriptor(IGNORE_IF_RECEIVER_IS_METHOD);
    }

    public Object visit(ASTLambdaExpression node, Object data) {
        if (node.isExpressionBody()) {
            ASTExpression expression = node.getExpressionBody();
            this.processLambdaWithBody(node, this.asCtx(data), expression);
        } else {
            ASTStatement onlyStmt = ASTList.singleOrNull(node.getBlockBody());
            if (onlyStmt instanceof ASTReturnStatement) {
                this.processLambdaWithBody(node, this.asCtx(data), ((ASTReturnStatement)onlyStmt).getExpr());
            }
        }
        return null;
    }

    private void processLambdaWithBody(ASTLambdaExpression lambda, RuleContext data, ASTExpression expression) {
        ASTMethodCall call;
        if (lambda.getParameters().toStream().any(it -> it.getDeclaredAnnotations().nonEmpty())) {
            return;
        }
        if (expression instanceof ASTMethodCall && this.canBeTransformed(lambda, call = (ASTMethodCall)expression) && this.argumentsListMatches(call, lambda.getParameters())) {
            data.addViolation((Node)lambda, new Object[]{this.buildMethodRefString(lambda, call)});
        }
    }

    private String buildMethodRefString(ASTLambdaExpression lambda, ASTMethodCall call) {
        StringBuilder sb = new StringBuilder();
        ASTExpression qualifier = call.getQualifier();
        OverloadSelectionResult info = call.getOverloadSelectionInfo();
        assert (!info.isFailed()) : "should not be failed: " + call;
        JTypeMirror methodSource = info.getMethodType().getDeclaringType();
        JTypeDeclSymbol classSym = methodSource.getSymbol();
        assert (classSym != null) : "null symbol for " + methodSource + ", method " + info.getMethodType();
        if (qualifier == null && info.getMethodType().isStatic() || lambda.getParameters().size() != call.getArguments().size()) {
            sb.append(classSym.getSimpleName());
        } else if (qualifier == null) {
            ASTTypeDeclaration enclosing = call.getEnclosingType();
            JClassType receiver = TypeOps.getReceiverType(enclosing.getTypeMirror(), (JClassSymbol)classSym);
            if (receiver != null && !receiver.getSymbol().equals(enclosing.getSymbol())) {
                sb.append(receiver.getSymbol().getSimpleName()).append(".this");
            } else {
                sb.append("this");
            }
        } else {
            boolean needsParentheses;
            boolean bl = needsParentheses = !(qualifier instanceof ASTPrimaryExpression);
            if (needsParentheses) {
                sb.append('(');
            }
            sb.append(PrettyPrintingUtil.prettyPrint(qualifier));
            if (needsParentheses) {
                sb.append(')');
            }
        }
        sb.append("::").append(call.getMethodName());
        return sb.toString();
    }

    private boolean argumentsListMatches(ASTMethodCall call, ASTLambdaParameterList params) {
        int start;
        ASTArgumentList args = call.getArguments();
        if (params.size() == args.size() + 1) {
            start = 1;
            JVariableSymbol firstParam = (JVariableSymbol)((ASTLambdaParameter)params.get(0)).getVarId().getSymbol();
            if (!JavaAstUtils.isReferenceToVar(call.getQualifier(), firstParam)) {
                return false;
            }
        } else if (args.size() == params.size()) {
            start = 0;
        } else {
            return false;
        }
        for (int i = 0; i < args.size(); ++i) {
            ASTLambdaParameter parm;
            ASTExpression arg = (ASTExpression)args.get(i);
            if (JavaAstUtils.isReferenceToVar(arg, (JVariableSymbol)(parm = (ASTLambdaParameter)params.get(i + start)).getVarId().getSymbol())) continue;
            return false;
        }
        return true;
    }

    private boolean canBeTransformed(ASTLambdaExpression lambda, ASTMethodCall call) {
        ASTExpression qualifier = JavaAstUtils.peelCasts(call.getQualifier());
        if (call.getOverloadSelectionInfo().isFailed()) {
            return false;
        }
        if (qualifier instanceof ASTConstructorCall) {
            return false;
        }
        if (qualifier instanceof ASTTypeExpression || qualifier instanceof ASTSuperExpression || qualifier instanceof ASTThisExpression || qualifier instanceof ASTClassLiteral || qualifier instanceof ASTLiteral || qualifier == null) {
            return true;
        }
        boolean isIgnoredBecauseOfMethodCall = qualifier instanceof ASTMethodCall && (Boolean)this.getProperty(IGNORE_IF_RECEIVER_IS_METHOD) != false;
        boolean mayNPE = lambda.getParameters().size() == call.getArguments().size();
        boolean isIgnoredBecauseOfNPE = mayNPE && (Boolean)this.getProperty(IGNORE_IF_MAY_NPE) != false;
        return !isIgnoredBecauseOfNPE && !isIgnoredBecauseOfMethodCall;
    }
}

