/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.internal;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTAssignableExpr;
import net.sourceforge.pmd.lang.java.ast.ASTClassDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassType;
import net.sourceforge.pmd.lang.java.ast.ASTExecutableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMemberValue;
import net.sourceforge.pmd.lang.java.ast.ASTModifierList;
import net.sourceforge.pmd.lang.java.ast.ASTTypeParameter;
import net.sourceforge.pmd.lang.java.ast.ASTTypeParameters;
import net.sourceforge.pmd.lang.java.ast.ASTVariableId;
import net.sourceforge.pmd.lang.java.ast.Annotatable;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaVisitorBase;
import net.sourceforge.pmd.lang.java.ast.ModifierOwner;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.errorprone.ImplicitSwitchFallThroughRule;
import net.sourceforge.pmd.lang.java.symbols.JExecutableSymbol;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.JTypeVar;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.reporting.AbstractAnnotationSuppressor;
import net.sourceforge.pmd.reporting.ViolationSuppressor;
import net.sourceforge.pmd.util.CollectionUtil;
import net.sourceforge.pmd.util.OptionalBool;

final class JavaAnnotationSuppressor
extends AbstractAnnotationSuppressor<ASTAnnotation> {
    private static final Set<String> UNUSED_RULES = new HashSet<String>(Arrays.asList("UnusedPrivateField", "UnusedLocalVariable", "UnusedPrivateMethod", "UnusedFormalParameter", "UnusedAssignment", "SingularField"));
    private static final Set<String> SERIAL_RULES = new HashSet<String>(Arrays.asList("BeanMembersShouldSerialize", "NonSerializableClass", "MissingSerialVersionUID"));
    static final List<ViolationSuppressor> ALL_JAVA_SUPPRESSORS = CollectionUtil.listOf((Object)((Object)new JavaAnnotationSuppressor()), (Object[])new ViolationSuppressor[0]);

    private JavaAnnotationSuppressor() {
        super(ASTAnnotation.class);
    }

    protected NodeStream<ASTAnnotation> getAnnotations(Node n) {
        if (n instanceof Annotatable) {
            return ((Annotatable)n).getDeclaredAnnotations();
        }
        return NodeStream.empty();
    }

    protected boolean annotationParamSuppresses(String stringVal, Rule rule) {
        return super.annotationParamSuppresses(stringVal, rule) || "serial".equals(stringVal) && SERIAL_RULES.contains(rule.getName()) || "unused".equals(stringVal) && UNUSED_RULES.contains(rule.getName()) || "fallthrough".equals(stringVal) && rule instanceof ImplicitSwitchFallThroughRule;
    }

    protected boolean walkAnnotation(ASTAnnotation annotation, AbstractAnnotationSuppressor.AnnotationWalkCallbacks callbacks) {
        if (TypeTestUtil.isA(SuppressWarnings.class, (TypeNode)annotation)) {
            for (ASTMemberValue value : annotation.getFlatValue("value")) {
                Object constVal = value.getConstValue();
                if (!(constVal instanceof String) || !callbacks.processNode((Node)value, (String)constVal)) continue;
                return true;
            }
        }
        return false;
    }

    JavaNode getAnnotationScope(ASTAnnotation a) {
        if (a.getParent() instanceof ASTModifierList) {
            return (JavaNode)((JavaNode)a.getParent()).getParent();
        }
        return null;
    }

    public static void foo1(int i) {
        i = 2;
        JavaAnnotationSuppressor.foo2(i);
    }

    private static void foo2(int i) {
        System.out.println("i = " + i);
    }

    private static OptionalBool hasUnusedWarning(JavaNode node) {
        boolean used;
        ASTClassDeclaration classDecl;
        if (node == null) {
            return OptionalBool.UNKNOWN;
        }
        if (JavaAnnotationSuppressor.hasUnusedVariables(node)) {
            return OptionalBool.YES;
        }
        if (JavaAnnotationSuppressor.hasUnusedTypeParam(node)) {
            return OptionalBool.YES;
        }
        if (JavaAnnotationSuppressor.hasUnusedMethod(node)) {
            return OptionalBool.YES;
        }
        if (node instanceof ASTFieldDeclaration) {
            return OptionalBool.NO;
        }
        if (node instanceof ASTClassDeclaration && (classDecl = (ASTClassDeclaration)node).getEffectiveVisibility() == ModifierOwner.Visibility.V_PRIVATE && (used = node.getRoot().descendants(ASTClassType.class).toStream().map(rec$ -> ((ASTClassType)rec$).getTypeMirror()).map(JTypeMirror::getSymbol).filter(Objects::nonNull).anyMatch(s -> s.equals(classDecl.getSymbol())))) {
            return OptionalBool.NO;
        }
        return OptionalBool.UNKNOWN;
    }

    private static boolean hasUnusedVariables(JavaNode node) {
        return node.descendants(ASTVariableId.class).crossFindBoundaries().any(it -> it.getLocalUsages().isEmpty() || it.getLocalUsages().stream().map(ASTAssignableExpr::getAccessType).noneMatch(a -> a == ASTAssignableExpr.AccessType.READ));
    }

    private static boolean hasUnusedTypeParam(JavaNode node) {
        final HashSet unusedTypeParams = new HashSet();
        node.acceptVisitor(new JavaVisitorBase<Void, Void>(){

            @Override
            public Void visit(ASTTypeParameters node, Void p) {
                for (ASTTypeParameter parm : node) {
                    unusedTypeParams.add(parm.getTypeMirror());
                }
                return (Void)super.visit(node, (Object)p);
            }

            @Override
            public Void visit(ASTClassType node, Void data) {
                JTypeMirror ty = node.getTypeMirror();
                if (ty instanceof JTypeVar) {
                    unusedTypeParams.remove(ty);
                }
                return (Void)super.visit(node, data);
            }

            @Override
            public Void visit(ASTModifierList node, Void data) {
                return data;
            }
        }, null);
        return !unusedTypeParams.isEmpty();
    }

    private static boolean hasUnusedMethod(JavaNode node) {
        HashSet<JExecutableSymbol> privateMethods = new HashSet<JExecutableSymbol>();
        for (ASTExecutableDeclaration decl : node.descendantsOrSelf().crossFindBoundaries().filterIs(ASTExecutableDeclaration.class)) {
            ModifierOwner.Visibility visibility = decl.getEffectiveVisibility();
            if (visibility.isAtMost(ModifierOwner.Visibility.V_PRIVATE)) {
                privateMethods.add(decl.getSymbol());
                continue;
            }
            return false;
        }
        return false;
    }

    protected OptionalBool isSuppressingNonPmdWarnings(String stringVal, ASTAnnotation annotation) {
        JavaNode scope;
        if ("unused".equals(stringVal) && JavaAnnotationSuppressor.hasUnusedWarning(scope = this.getAnnotationScope(annotation)) == OptionalBool.NO) {
            return OptionalBool.NO;
        }
        return super.isSuppressingNonPmdWarnings(stringVal, (Node)annotation);
    }
}

