/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util;

import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.pmd.util.IteratorUtil;
import org.apache.commons.lang3.Validate;

final class ConsList<T>
extends AbstractList<T> {
    private final List<? extends T> head;
    private final List<? extends T> tail;
    private final int size;

    ConsList(List<? extends T> head, List<? extends T> tail) {
        this.head = head;
        this.tail = tail;
        this.size = head.size() + tail.size();
    }

    @Override
    public T get(int index) {
        Validate.validIndex((Collection)this, (int)index);
        if (index < this.head.size()) {
            return this.head.get(index);
        }
        return this.tail.get(index - this.head.size());
    }

    @Override
    public Iterator<T> iterator() {
        return IteratorUtil.concat(this.head.iterator(), this.tail.iterator());
    }

    @Override
    public int size() {
        return this.size;
    }
}

