/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sourceforge.pmd.renderers.AbstractAccumulatingRenderer;
import net.sourceforge.pmd.renderers.HTMLRenderer;
import net.sourceforge.pmd.reporting.Report;
import net.sourceforge.pmd.reporting.RuleViolation;
import org.apache.commons.lang3.mutable.MutableInt;

public class SummaryHTMLRenderer
extends AbstractAccumulatingRenderer {
    public static final String NAME = "summaryhtml";

    public SummaryHTMLRenderer() {
        super(NAME, "Summary HTML format.");
        this.definePropertyDescriptor(HTMLRenderer.LINK_PREFIX);
        this.definePropertyDescriptor(HTMLRenderer.LINE_PREFIX);
        this.definePropertyDescriptor(HTMLRenderer.HTML_EXTENSION);
    }

    @Override
    public String defaultFileExtension() {
        return "html";
    }

    @Override
    public void outputReport(Report report) throws IOException {
        this.writer.println("<html><head><title>PMD</title></head><body>");
        this.renderSummary(report);
        this.writer.write("<center><h2>Detail</h2></center>");
        this.writer.println("<table align=\"center\" cellspacing=\"0\" cellpadding=\"3\"><tr>");
        HTMLRenderer htmlRenderer = new HTMLRenderer();
        htmlRenderer.setProperty(HTMLRenderer.LINK_PREFIX, this.getProperty(HTMLRenderer.LINK_PREFIX));
        htmlRenderer.setProperty(HTMLRenderer.LINE_PREFIX, this.getProperty(HTMLRenderer.LINE_PREFIX));
        htmlRenderer.setProperty(HTMLRenderer.HTML_EXTENSION, this.getProperty(HTMLRenderer.HTML_EXTENSION));
        htmlRenderer.setShowSuppressedViolations(this.showSuppressedViolations);
        htmlRenderer.renderBody(this.writer, report);
        this.writer.println("</tr></table></body></html>");
    }

    private void renderSummary(Report report) throws IOException {
        this.writer.println("<center><h2>Summary</h2></center>");
        this.writer.println("<table align=\"center\" cellspacing=\"0\" cellpadding=\"3\">");
        this.writer.println("<tr><th>Rule name</th><th>Number of violations</th></tr>");
        Map<String, MutableInt> summary = SummaryHTMLRenderer.getSummary(report);
        for (Map.Entry<String, MutableInt> entry : summary.entrySet()) {
            String ruleName = entry.getKey();
            this.writer.write("<tr><td>");
            this.writer.write(ruleName);
            this.writer.write("</td><td align=center>");
            this.writer.write(String.valueOf(entry.getValue().intValue()));
            this.writer.println("</td></tr>");
        }
        this.writer.println("</table>");
    }

    private static Map<String, MutableInt> getSummary(Report report) {
        LinkedHashMap<String, MutableInt> summary = new LinkedHashMap<String, MutableInt>();
        for (RuleViolation rv : report.getViolations()) {
            String name = rv.getRule().getName();
            MutableInt count = (MutableInt)summary.get(name);
            if (count == null) {
                count = new MutableInt(0);
                summary.put(name, count);
            }
            count.increment();
        }
        return summary;
    }
}

