/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sourceforge.pmd.PMDVersion;
import net.sourceforge.pmd.renderers.AbstractIncrementingRenderer;
import net.sourceforge.pmd.reporting.Report;
import net.sourceforge.pmd.reporting.RuleViolation;
import net.sourceforge.pmd.reporting.ViolationSuppressor;
import org.apache.commons.lang3.StringUtils;

public class JsonRenderer
extends AbstractIncrementingRenderer {
    public static final String NAME = "json";
    private static final int FORMAT_VERSION = 0;
    private static final Map<String, String> SUPPRESSION_TYPE_FORMAT_0 = new HashMap<String, String>();
    private JsonWriter jsonWriter;

    public JsonRenderer() {
        super(NAME, "JSON format.");
    }

    @Override
    public String defaultFileExtension() {
        return NAME;
    }

    @Override
    public void start() throws IOException {
        this.jsonWriter = new JsonWriter((Writer)this.writer);
        this.jsonWriter.setHtmlSafe(true);
        this.jsonWriter.setIndent("  ");
        this.jsonWriter.beginObject();
        this.jsonWriter.name("formatVersion").value(0L);
        this.jsonWriter.name("pmdVersion").value(PMDVersion.VERSION);
        this.jsonWriter.name("timestamp").value(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX").format(new Date()));
        this.jsonWriter.name("files").beginArray();
    }

    @Override
    public void renderFileViolations(Iterator<RuleViolation> violations) throws IOException {
        String filename = null;
        while (violations.hasNext()) {
            RuleViolation rv = violations.next();
            String nextFilename = this.determineFileName(rv.getFileId());
            if (!nextFilename.equals(filename)) {
                if (filename != null) {
                    this.jsonWriter.endArray();
                    this.jsonWriter.endObject();
                }
                filename = nextFilename;
                this.jsonWriter.beginObject();
                this.jsonWriter.name("filename").value(filename);
                this.jsonWriter.name("violations").beginArray();
            }
            this.renderSingleViolation(rv);
        }
        this.jsonWriter.endArray();
        this.jsonWriter.endObject();
    }

    private void renderSingleViolation(RuleViolation rv) throws IOException {
        this.renderSingleViolation(rv, null, null);
    }

    private void renderSingleViolation(RuleViolation rv, String suppressionType, String userMsg) throws IOException {
        this.jsonWriter.beginObject();
        this.jsonWriter.name("beginline").value((long)rv.getBeginLine());
        this.jsonWriter.name("begincolumn").value((long)rv.getBeginColumn());
        this.jsonWriter.name("endline").value((long)rv.getEndLine());
        this.jsonWriter.name("endcolumn").value((long)rv.getEndColumn());
        this.jsonWriter.name("description").value(rv.getDescription());
        this.jsonWriter.name("rule").value(rv.getRule().getName());
        this.jsonWriter.name("ruleset").value(rv.getRule().getRuleSetName());
        this.jsonWriter.name("priority").value((long)rv.getRule().getPriority().getPriority());
        if (StringUtils.isNotBlank((CharSequence)rv.getRule().getExternalInfoUrl())) {
            this.jsonWriter.name("externalInfoUrl").value(rv.getRule().getExternalInfoUrl());
        }
        if (StringUtils.isNotBlank((CharSequence)suppressionType)) {
            this.jsonWriter.name("suppressiontype").value(suppressionType);
        }
        if (StringUtils.isNotBlank((CharSequence)userMsg)) {
            this.jsonWriter.name("usermsg").value(userMsg);
        }
        this.jsonWriter.endObject();
    }

    private String getSuppressionType(ViolationSuppressor suppressor) {
        return SUPPRESSION_TYPE_FORMAT_0.getOrDefault(suppressor.getId(), suppressor.getId());
    }

    @Override
    public void end() throws IOException {
        this.jsonWriter.endArray();
        this.jsonWriter.name("suppressedViolations").beginArray();
        String filename = null;
        if (!this.suppressed.isEmpty()) {
            for (Report.SuppressedViolation s : this.suppressed) {
                RuleViolation rv = s.getRuleViolation();
                String nextFilename = this.determineFileName(rv.getFileId());
                if (!nextFilename.equals(filename)) {
                    if (filename != null) {
                        this.jsonWriter.endArray();
                        this.jsonWriter.endObject();
                    }
                    filename = nextFilename;
                    this.jsonWriter.beginObject();
                    this.jsonWriter.name("filename").value(filename);
                    this.jsonWriter.name("violations").beginArray();
                }
                this.renderSingleViolation(rv, this.getSuppressionType(s.getSuppressor()), s.getUserMessage());
            }
            this.jsonWriter.endArray();
            this.jsonWriter.endObject();
        }
        this.jsonWriter.endArray();
        this.jsonWriter.name("processingErrors").beginArray();
        for (Object error : this.errors) {
            this.jsonWriter.beginObject();
            this.jsonWriter.name("filename").value(this.determineFileName(((Report.ProcessingError)error).getFileId()));
            this.jsonWriter.name("message").value(((Report.ProcessingError)error).getMsg());
            this.jsonWriter.name("detail").value(((Report.ProcessingError)error).getDetail());
            this.jsonWriter.endObject();
        }
        this.jsonWriter.endArray();
        this.jsonWriter.name("configurationErrors").beginArray();
        for (Object error : this.configErrors) {
            this.jsonWriter.beginObject();
            this.jsonWriter.name("rule").value(((Report.ConfigurationError)error).rule().getName());
            this.jsonWriter.name("ruleset").value(((Report.ConfigurationError)error).rule().getRuleSetName());
            this.jsonWriter.name("message").value(((Report.ConfigurationError)error).issue());
            this.jsonWriter.endObject();
        }
        this.jsonWriter.endArray();
        this.jsonWriter.endObject();
        this.jsonWriter.flush();
    }

    static {
        SUPPRESSION_TYPE_FORMAT_0.put(ViolationSuppressor.NOPMD_COMMENT_SUPPRESSOR.getId(), "nopmd");
        SUPPRESSION_TYPE_FORMAT_0.put("@SuppressWarnings", "annotation");
    }
}

