/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.metrics;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.metrics.Metric;
import net.sourceforge.pmd.lang.metrics.MetricOptions;
import net.sourceforge.pmd.util.DataMap;

final class ParameterizedMetricKey<N extends Node, R extends Number>
implements DataMap.DataKey<ParameterizedMetricKey<N, R>, R> {
    private static final ConcurrentMap<ParameterizedMetricKey<?, ?>, ParameterizedMetricKey<?, ?>> POOL = new ConcurrentHashMap();
    public final Metric<N, R> metric;
    public final MetricOptions options;

    private ParameterizedMetricKey(Metric<N, R> metric, MetricOptions options) {
        this.metric = metric;
        this.options = options;
    }

    public String toString() {
        return "ParameterizedMetricKey{key=" + this.metric.displayName() + ", options=" + this.options + '}';
    }

    public boolean equals(Object o) {
        return o instanceof ParameterizedMetricKey && ((ParameterizedMetricKey)o).metric.equals(this.metric) && ((ParameterizedMetricKey)o).options.equals(this.options);
    }

    public int hashCode() {
        return 31 * this.metric.hashCode() + this.options.hashCode();
    }

    public static <N extends Node, R extends Number> ParameterizedMetricKey<N, R> getInstance(Metric<N, R> key, MetricOptions options) {
        ParameterizedMetricKey<N, R> tmp = new ParameterizedMetricKey<N, R>(key, options);
        POOL.putIfAbsent(tmp, tmp);
        ParameterizedMetricKey result = (ParameterizedMetricKey)POOL.get(tmp);
        return result;
    }
}

