/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.metrics;

import java.util.DoubleSummaryStatistics;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.metrics.Metric;
import net.sourceforge.pmd.lang.metrics.MetricOptions;
import net.sourceforge.pmd.lang.metrics.ParameterizedMetricKey;

public final class MetricsUtil {
    static final String NULL_KEY_MESSAGE = "The metric key must not be null";
    static final String NULL_OPTIONS_MESSAGE = "The metric options must not be null";
    static final String NULL_NODE_MESSAGE = "The node must not be null";

    private MetricsUtil() {
    }

    public static boolean supportsAll(Node node, Metric<?, ?> ... metrics) {
        for (Metric<?, ?> metric : metrics) {
            if (metric.supports(node)) continue;
            return false;
        }
        return true;
    }

    public static <O extends Node> DoubleSummaryStatistics computeStatistics(Metric<? super O, ?> key, Iterable<? extends O> ops) {
        return MetricsUtil.computeStatistics(key, ops, MetricOptions.emptyOptions());
    }

    public static <O extends Node> DoubleSummaryStatistics computeStatistics(Metric<? super O, ?> key, Iterable<? extends O> ops, MetricOptions options) {
        Objects.requireNonNull(key, NULL_KEY_MESSAGE);
        Objects.requireNonNull(options, NULL_OPTIONS_MESSAGE);
        Objects.requireNonNull(ops, NULL_NODE_MESSAGE);
        return StreamSupport.stream(ops.spliterator(), false).filter(key::supports).collect(Collectors.summarizingDouble(op -> ((Number)MetricsUtil.computeMetric(key, op, options)).doubleValue()));
    }

    public static <N extends Node, R extends Number> R computeMetric(Metric<? super N, R> key, N node) {
        return MetricsUtil.computeMetric(key, node, MetricOptions.emptyOptions());
    }

    public static <N extends Node, R extends Number> R computeMetric(Metric<? super N, R> key, N node, MetricOptions options) {
        return MetricsUtil.computeMetric(key, node, options, false);
    }

    public static <N extends Node, R extends Number> R computeMetric(Metric<? super N, R> key, N node, MetricOptions options, boolean forceRecompute) {
        Objects.requireNonNull(key, NULL_KEY_MESSAGE);
        Objects.requireNonNull(options, NULL_OPTIONS_MESSAGE);
        Objects.requireNonNull(node, NULL_NODE_MESSAGE);
        if (!key.supports(node)) {
            throw new IllegalArgumentException(key + " cannot be computed on " + node);
        }
        ParameterizedMetricKey<? super N, R> paramKey = ParameterizedMetricKey.getInstance(key, options);
        Number prev = (Number)node.getUserMap().get(paramKey);
        if (!forceRecompute && prev != null) {
            return (R)prev;
        }
        R val = key.computeFor(node, options);
        node.getUserMap().set(paramKey, val);
        return val;
    }
}

