/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.visitclass;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.util.ClassName;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.Annotations;
import org.apache.bcel.classfile.ArrayElementValue;
import org.apache.bcel.classfile.ElementValue;
import org.apache.bcel.classfile.ElementValuePair;
import org.apache.bcel.classfile.EnumElementValue;
import org.apache.bcel.classfile.ParameterAnnotationEntry;
import org.apache.bcel.classfile.ParameterAnnotations;
import org.apache.bcel.classfile.SimpleElementValue;

public class AnnotationVisitor
extends PreorderVisitor {
    static final boolean DEBUG = SystemProperties.getBoolean("annotation.visitor");

    public void visitAnnotation(@DottedClassName String annotationClass, Map<String, ElementValue> map, boolean runtimeVisible) {
        if (DEBUG) {
            System.out.println("Annotation: " + annotationClass);
            for (Map.Entry<String, ElementValue> e : map.entrySet()) {
                System.out.println("    " + e.getKey());
                System.out.println(" -> " + String.valueOf(e.getValue()));
            }
        }
    }

    protected static String getAnnotationParameterAsString(Map<String, ElementValue> map, String parameter) {
        try {
            ElementValue ev = map.get(parameter);
            if (ev instanceof SimpleElementValue) {
                return ((SimpleElementValue)ev).getValueString();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @CheckForNull
    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"})
    protected static String[] getAnnotationParameterAsStringArray(Map<String, ElementValue> map, String parameter) {
        try {
            ElementValue e = map.get(parameter);
            ArrayElementValue a = (ArrayElementValue)e;
            int size = a.getElementValuesArraySize();
            String[] result = new String[size];
            ElementValue[] elementValuesArray = a.getElementValuesArray();
            for (int i = 0; i < size; ++i) {
                result[i] = ((SimpleElementValue)elementValuesArray[i]).getValueString();
            }
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    @CheckForNull
    protected static <E extends Enum<E>> E getAnnotationParameterAsEnum(Map<String, ElementValue> map, String parameter, Class<E> type) {
        ElementValue ev = map.get(parameter);
        if (ev instanceof EnumElementValue) {
            String enumValueString = ((EnumElementValue)ev).getEnumValueString();
            return Enum.valueOf(type, enumValueString);
        }
        return null;
    }

    public void visitParameterAnnotation(int p, @DottedClassName String annotationClass, Map<String, ElementValue> map, boolean runtimeVisible) {
    }

    public void visitSyntheticParameterAnnotation(int p, boolean runtimeVisible) {
    }

    @Override
    public void visitParameterAnnotation(ParameterAnnotations arg0) {
        ParameterAnnotationEntry[] parameterAnnotationEntries = arg0.getParameterAnnotationEntries();
        int numParametersToMethod = this.getNumberMethodArguments();
        int offset = 0;
        if (numParametersToMethod > parameterAnnotationEntries.length) {
            offset = 1;
        }
        for (int i = 0; i < parameterAnnotationEntries.length; ++i) {
            ParameterAnnotationEntry e = parameterAnnotationEntries[i];
            for (AnnotationEntry ae : e.getAnnotationEntries()) {
                boolean runtimeVisible = ae.isRuntimeVisible();
                String name = ClassName.fromFieldSignatureToDottedClassName(ae.getAnnotationType());
                if (name == null) continue;
                HashMap<String, ElementValue> map = new HashMap<String, ElementValue>();
                for (ElementValuePair ev : ae.getElementValuePairs()) {
                    map.put(ev.getNameString(), ev.getValue());
                }
                this.visitParameterAnnotation(offset + i, name, map, runtimeVisible);
            }
        }
    }

    @Override
    public void visitAnnotation(Annotations arg0) {
        for (AnnotationEntry ae : arg0.getAnnotationEntries()) {
            boolean runtimeVisible = ae.isRuntimeVisible();
            String name = ClassName.fromFieldSignatureToDottedClassName(ae.getAnnotationType());
            if (name == null) continue;
            HashMap<String, ElementValue> map = new HashMap<String, ElementValue>();
            for (ElementValuePair ev : ae.getElementValuePairs()) {
                map.put(ev.getNameString(), ev.getValue());
            }
            this.visitAnnotation(name, map, runtimeVisible);
        }
    }
}

