/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.sarif;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import edu.umd.cs.findbugs.Plugin;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.net.URI;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

class Extension {
    @NonNull
    final String version;
    @NonNull
    final String name;
    @Nullable
    final String shortDescription;
    @Nullable
    final String fullDescription;
    @Nullable
    final URI informationUri;
    @Nullable
    final String organization;

    Extension(@NonNull String version, @NonNull String name, @Nullable String shortDescription, @Nullable String fullDescription, @Nullable URI informationUri, @Nullable String organization) {
        this.version = Objects.requireNonNull(version);
        this.name = Objects.requireNonNull(name);
        this.shortDescription = shortDescription;
        this.fullDescription = fullDescription;
        this.informationUri = informationUri;
        this.organization = organization;
    }

    JsonObject toJsonObject() {
        JsonObject desc = null;
        if (this.shortDescription != null) {
            desc = new JsonObject();
            desc.addProperty("text", this.shortDescription);
        }
        JsonObject extensionJson = new JsonObject();
        extensionJson.addProperty("version", this.version);
        extensionJson.addProperty("name", this.name);
        if (desc != null) {
            extensionJson.add("shortDescription", (JsonElement)desc);
        }
        if (this.informationUri != null) {
            extensionJson.addProperty("informationUri", this.informationUri.toString());
        }
        if (!StringUtils.isEmpty((CharSequence)this.organization)) {
            extensionJson.addProperty("organization", this.organization);
        }
        return extensionJson;
    }

    static Extension fromPlugin(@NonNull Plugin plugin) {
        Objects.requireNonNull(plugin);
        return new Extension(plugin.getVersion(), plugin.getPluginId(), plugin.getShortDescription(), plugin.getDetailedDescription(), plugin.getWebsiteURI(), plugin.getProvider());
    }
}

