/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.ResourceValue;
import edu.umd.cs.findbugs.ba.ResourceValueFrame;
import edu.umd.cs.findbugs.ba.ResourceValueFrameModelingVisitor;
import edu.umd.cs.findbugs.detect.FindOpenStream;
import edu.umd.cs.findbugs.detect.Stream;
import edu.umd.cs.findbugs.detect.StreamResourceTracker;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;

public class StreamFrameModelingVisitor
extends ResourceValueFrameModelingVisitor {
    private final StreamResourceTracker resourceTracker;
    private final Stream stream;
    private Location location;

    public StreamFrameModelingVisitor(ConstantPoolGen cpg, StreamResourceTracker resourceTracker, Stream stream) {
        super(cpg);
        this.resourceTracker = resourceTracker;
        this.stream = stream;
    }

    @Override
    public void transferInstruction(InstructionHandle handle, BasicBlock basicBlock) throws DataflowAnalysisException {
        this.location = new Location(handle, basicBlock);
        Instruction ins = handle.getInstruction();
        ResourceValueFrame frame = (ResourceValueFrame)this.getFrame();
        ResourceValueFrame.State status = ResourceValueFrame.State.NONEXISTENT;
        boolean updated = false;
        boolean created = false;
        Location creationPoint = this.stream.getLocation();
        if (handle == creationPoint.getHandle() && basicBlock == creationPoint.getBasicBlock()) {
            if (this.stream.isOpenOnCreation()) {
                status = ResourceValueFrame.State.OPEN;
                this.stream.setOpenLocation(this.location);
                this.resourceTracker.addStreamOpenLocation(this.location, this.stream);
            } else {
                status = ResourceValueFrame.State.CREATED;
            }
            updated = true;
            created = true;
        } else if (this.resourceTracker.isResourceOpen(basicBlock, handle, this.cpg, this.stream, frame)) {
            status = ResourceValueFrame.State.OPEN;
            updated = true;
            this.stream.setOpenLocation(this.location);
            this.resourceTracker.addStreamOpenLocation(this.location, this.stream);
        } else if (this.resourceTracker.isResourceClose(basicBlock, handle, this.cpg, this.stream, frame)) {
            status = ResourceValueFrame.State.CLOSED;
            updated = true;
        }
        this.analyzeInstruction(ins);
        if (updated) {
            frame.setStatus(status);
            if (created) {
                frame.setValue(frame.getNumSlots() - 1, ResourceValue.instance());
            }
        }
    }

    @Override
    protected boolean instanceEscapes(InvokeInstruction inv, int instanceArgNum) {
        ConstantPoolGen cpg = this.getCPG();
        String className = inv.getClassName(cpg);
        boolean escapes = inv.getOpcode() == 184 || instanceArgNum != 0;
        String methodName = inv.getMethodName(cpg);
        String methodSig = inv.getSignature(cpg);
        if (inv.getOpcode() == 182 && ("load".equals(methodName) || "loadFromXml".equals(methodName) || "store".equals(methodName) || "save".equals(methodName)) && "java.util.Properties".equals(className)) {
            escapes = false;
        }
        if (inv.getOpcode() == 182 && ("load".equals(methodName) || "store".equals(methodName)) && "java.security.KeyStore".equals(className)) {
            escapes = false;
        }
        if (inv.getOpcode() == 182 && "getChannel".equals(methodName) && "()Ljava/nio/channels/FileChannel;".equals(methodSig)) {
            escapes = true;
        }
        if (FindOpenStream.DEBUG && escapes) {
            System.out.println("ESCAPE at " + String.valueOf(this.location) + " at call to " + className + "." + methodName + ":" + methodSig);
        }
        if (this.stream.getOpenLocation() != null) {
            this.resourceTracker.addStreamEscape(this.stream, this.location);
        }
        return escapes;
    }
}

