/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.ClassWarningSuppressor;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.FieldWarningSuppressor;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.MethodWarningSuppressor;
import edu.umd.cs.findbugs.NonReportingDetector;
import edu.umd.cs.findbugs.PackageWarningSuppressor;
import edu.umd.cs.findbugs.ParameterWarningSuppressor;
import edu.umd.cs.findbugs.SuppressionMatcher;
import edu.umd.cs.findbugs.WarningSuppressor;
import edu.umd.cs.findbugs.annotations.SuppressMatchType;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.bcel.BCELUtil;
import edu.umd.cs.findbugs.bytecode.MemberUtils;
import edu.umd.cs.findbugs.util.ClassName;
import edu.umd.cs.findbugs.visitclass.AnnotationVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.ElementValue;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Visitor;

public class NoteSuppressedWarnings
extends AnnotationVisitor
implements Detector,
NonReportingDetector {
    private final Set<String> packages = new HashSet<String>();
    private boolean isRecord;
    private boolean visitingCanonicalRecordConstructor;
    private final List<RecordComponentSuppressors> recordComponents = new ArrayList<RecordComponentSuppressors>();
    private final Map<String, RecordComponentSuppressors> recordComponentsByName = new HashMap<String, RecordComponentSuppressors>();
    private final SuppressionMatcher suppressionMatcher = AnalysisContext.currentAnalysisContext().getSuppressionMatcher();

    public NoteSuppressedWarnings(BugReporter bugReporter) {
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        this.isRecord = Subtypes2.isRecord(classContext.getJavaClass());
        JavaClass javaClass = classContext.getJavaClass();
        if (!BCELUtil.preTiger(javaClass)) {
            String packageName;
            String name = javaClass.getClassName();
            int i = name.lastIndexOf(46);
            String string = packageName = i < 0 ? "" : name.substring(0, i);
            if (name.endsWith(".package-info")) {
                if (!this.packages.add(packageName)) {
                    return;
                }
            } else if (this.packages.add(packageName)) {
                try {
                    JavaClass packageInfoClass = Repository.lookupClass((String)(packageName + ".package-info"));
                    packageInfoClass.accept((Visitor)this);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            javaClass.accept((Visitor)this);
        }
    }

    @Override
    public void visitField(Field field) {
        if (this.isRecord) {
            RecordComponentSuppressors suppressors = new RecordComponentSuppressors(field);
            this.recordComponents.add(suppressors);
            this.recordComponentsByName.put(field.getName(), suppressors);
        }
    }

    @Override
    public void visitMethod(Method method) {
        this.visitingCanonicalRecordConstructor = this.isRecord && NoteSuppressedWarnings.isConstructor(method) && Arrays.equals(method.getArgumentTypes(), this.recordComponents.stream().map(c -> c.field.getType()).toArray());
    }

    private static boolean isConstructor(Method method) {
        return "<init>".equals(method.getName());
    }

    @Override
    public void visitAfter(JavaClass obj) {
        for (RecordComponentSuppressors suppressors : this.recordComponents) {
            Collection<WarningSuppressor> componentSuppressors = suppressors.getSuppressors();
            if (componentSuppressors.size() <= 1) continue;
            for (WarningSuppressor suppressor : componentSuppressors) {
                suppressor.addAlternateSuppressors(componentSuppressors);
            }
        }
        this.recordComponents.clear();
    }

    @Override
    public void visitAnnotation(String annotationClass, Map<String, ElementValue> map, boolean runtimeVisible) {
        if (!NoteSuppressedWarnings.isSuppressWarnings(annotationClass)) {
            return;
        }
        String[] suppressed = NoteSuppressedWarnings.getAnnotationParameterAsStringArray(map, "value");
        SuppressMatchType matchType = NoteSuppressedWarnings.getAnnotationParameterAsEnum(map, "matchType", SuppressMatchType.class);
        if (suppressed == null || suppressed.length == 0) {
            this.suppressWarning(null, matchType);
        } else {
            for (String s : suppressed) {
                this.suppressWarning(s, matchType);
            }
        }
    }

    public static boolean isSuppressWarnings(String annotationClass) {
        return annotationClass.endsWith("SuppressWarnings") || annotationClass.endsWith("SuppressFBWarnings");
    }

    @Override
    public void visitParameterAnnotation(int p, String annotationClass, Map<String, ElementValue> map, boolean runtimeVisible) {
        if (!NoteSuppressedWarnings.isSuppressWarnings(annotationClass)) {
            return;
        }
        Method method = this.getMethod();
        if (!method.isStatic() && !NoteSuppressedWarnings.isConstructor(method)) {
            ++p;
        }
        String[] suppressed = NoteSuppressedWarnings.getAnnotationParameterAsStringArray(map, "value");
        SuppressMatchType matchType = NoteSuppressedWarnings.getAnnotationParameterAsEnum(map, "matchType", SuppressMatchType.class);
        if (suppressed == null || suppressed.length == 0) {
            this.suppressParameterWarning(p, null, matchType);
        } else {
            for (String s : suppressed) {
                this.suppressParameterWarning(p, s, matchType);
            }
        }
    }

    private void suppressParameterWarning(int parameter, String pattern, SuppressMatchType matchType) {
        String className = this.getDottedClassName();
        ClassAnnotation clazz = new ClassAnnotation(className);
        ParameterWarningSuppressor suppressor = new ParameterWarningSuppressor(pattern, matchType, clazz, MethodAnnotation.fromVisitedMethod(this), parameter, MemberUtils.isUserGenerated(this.getXClass()));
        this.suppressionMatcher.addSuppressor(suppressor);
        if (this.visitingCanonicalRecordConstructor) {
            this.recordComponents.get((int)parameter).canonicalConstructorSuppressor = suppressor;
        }
    }

    private void suppressWarning(String pattern, SuppressMatchType matchType) {
        String className = this.getDottedClassName();
        ClassAnnotation clazz = new ClassAnnotation(className);
        if (className.endsWith(".package-info")) {
            PackageWarningSuppressor suppressor = new PackageWarningSuppressor(pattern, matchType, ClassName.toDottedClassName(this.getPackageName()), MemberUtils.isUserGenerated(this.getXClass()));
            this.suppressionMatcher.addPackageSuppressor(suppressor);
        } else if (this.visitingMethod()) {
            RecordComponentSuppressors suppressors;
            MethodWarningSuppressor suppressor = new MethodWarningSuppressor(pattern, matchType, clazz, MethodAnnotation.fromVisitedMethod(this), MemberUtils.isUserGenerated(this.getXClass()), MemberUtils.isUserGenerated((FieldOrMethod)this.getMethod()) && MemberUtils.isUserGenerated(this.getXClass()));
            this.suppressionMatcher.addSuppressor(suppressor);
            if (this.isRecord && (suppressors = this.recordComponentsByName.get(this.getMethodName())) != null) {
                suppressors.accessorMethodSuppressor = suppressor;
            }
        } else if (this.visitingField()) {
            FieldWarningSuppressor suppressor = new FieldWarningSuppressor(pattern, matchType, clazz, FieldAnnotation.fromVisitedField(this), MemberUtils.isUserGenerated(this.getXClass()), MemberUtils.isUserGenerated((FieldOrMethod)this.getField()) && MemberUtils.isUserGenerated(this.getXClass()));
            this.suppressionMatcher.addSuppressor(suppressor);
            if (this.isRecord) {
                RecordComponentSuppressors suppressors = this.recordComponentsByName.get(this.getFieldName());
                suppressors.fieldSuppressor = suppressor;
            }
        } else {
            ClassWarningSuppressor suppressor = new ClassWarningSuppressor(pattern, matchType, clazz, MemberUtils.isUserGenerated(this.getXClass()));
            this.suppressionMatcher.addSuppressor(suppressor);
        }
    }

    @Override
    public void report() {
    }

    private static class RecordComponentSuppressors {
        private final Field field;
        private WarningSuppressor canonicalConstructorSuppressor;
        private WarningSuppressor accessorMethodSuppressor;
        private WarningSuppressor fieldSuppressor;

        public RecordComponentSuppressors(Field field) {
            this.field = field;
        }

        private Collection<WarningSuppressor> getSuppressors() {
            return Stream.of(this.canonicalConstructorSuppressor, this.accessorMethodSuppressor, this.fieldSuppressor).filter(Objects::nonNull).collect(Collectors.toList());
        }
    }
}

