/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.AbstractBugReporter;
import edu.umd.cs.findbugs.AnalysisError;
import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugCategory;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.BugRanker;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ConfigurableBugReporter;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.PackageMemberAnnotation;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.charsets.UTF8;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Iterator;

public abstract class TextUIBugReporter
extends AbstractBugReporter
implements ConfigurableBugReporter {
    private boolean reportStackTrace = true;
    private boolean useLongBugCodes = false;
    private boolean showRank = false;
    private boolean reportHistory = false;
    private boolean applySuppressions = false;
    private String outputTarget;
    static final String OTHER_CATEGORY_ABBREV = "X";
    protected PrintWriter outputStream = UTF8.printWriter(System.out, true);
    private boolean analysisErrors;
    private boolean missingClasses;

    protected TextUIBugReporter() {
    }

    @Override
    public void setOutputStream(PrintStream outputStream) {
        this.outputStream = UTF8.printWriter(outputStream, true);
    }

    public void setWriter(PrintWriter writer) {
        this.outputStream = writer;
    }

    public void setReportStackTrace(boolean reportStackTrace) {
        this.reportStackTrace = reportStackTrace;
    }

    protected void printBug(BugInstance bugInstance) {
        if (this.showRank) {
            int rank = BugRanker.findRank(bugInstance);
            this.outputStream.printf("%2d ", rank);
        }
        switch (bugInstance.getPriority()) {
            case 4: {
                this.outputStream.print("E ");
                break;
            }
            case 3: {
                this.outputStream.print("L ");
                break;
            }
            case 2: {
                this.outputStream.print("M ");
                break;
            }
            case 1: {
                this.outputStream.print("H ");
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        BugPattern pattern = bugInstance.getBugPattern();
        if (pattern != null) {
            String categoryAbbrev = null;
            BugCategory bcat = DetectorFactoryCollection.instance().getBugCategory(pattern.getCategory());
            if (bcat != null) {
                categoryAbbrev = bcat.getAbbrev();
            }
            if (categoryAbbrev == null) {
                categoryAbbrev = OTHER_CATEGORY_ABBREV;
            }
            this.outputStream.print(categoryAbbrev);
            this.outputStream.print(" ");
        }
        if (this.useLongBugCodes) {
            this.outputStream.print(bugInstance.getType());
            this.outputStream.print(" ");
        }
        if (this.reportHistory) {
            long first = bugInstance.getFirstVersion();
            long last = bugInstance.getLastVersion();
            this.outputStream.print(first);
            this.outputStream.print(" ");
            this.outputStream.print(last);
            this.outputStream.print(" ");
        }
        SourceLineAnnotation line = bugInstance.getPrimarySourceLineAnnotation();
        this.outputStream.println(bugInstance.getMessage().replace('\n', ' ') + "  " + line.toString());
    }

    @Override
    public void reportQueuedErrors() {
        boolean errors = this.analysisErrors || this.missingClasses || !this.getQueuedErrors().isEmpty();
        this.missingClasses = false;
        this.analysisErrors = false;
        super.reportQueuedErrors();
        if (errors) {
            this.emitLine("");
        }
    }

    @Override
    public void reportAnalysisError(AnalysisError error) {
        if (!this.analysisErrors) {
            this.emitLine("The following errors occurred during analysis:");
            this.analysisErrors = true;
        }
        this.emitLine("\t" + error.getMessage());
        if (error.getExceptionMessage() != null) {
            String[] stackTrace;
            this.emitLine("\t\t" + error.getExceptionMessage());
            if (this.reportStackTrace && (stackTrace = error.getStackTrace()) != null) {
                for (String aStackTrace : stackTrace) {
                    this.emitLine("\t\t\tAt " + aStackTrace);
                }
            }
        }
    }

    @Override
    public void reportMissingClass(String message) {
        if (!this.missingClasses) {
            this.emitLine("The following classes needed for analysis were missing:");
            this.missingClasses = true;
        }
        this.emitLine("\t" + message);
    }

    protected void emitLine(String line) {
        line = line.replace("\t", "  ");
        System.err.println(line);
    }

    public boolean getUseLongBugCodes() {
        return this.useLongBugCodes;
    }

    public void setReportHistory(boolean reportHistory) {
        this.reportHistory = reportHistory;
    }

    @Override
    public void setUseLongBugCodes(boolean useLongBugCodes) {
        this.useLongBugCodes = useLongBugCodes;
    }

    public void setShowRank(boolean showRank) {
        this.showRank = showRank;
    }

    public void setApplySuppressions(boolean applySuppressions) {
        this.applySuppressions = applySuppressions;
    }

    public BugReporter getRealBugReporter() {
        return this;
    }

    protected void checkBugInstance(BugInstance bugInstance) {
        Iterator<BugAnnotation> i = bugInstance.annotationIterator();
        while (i.hasNext()) {
            PackageMemberAnnotation pkgMember;
            BugAnnotation bugAnnotation = i.next();
            if (!(bugAnnotation instanceof PackageMemberAnnotation) || (pkgMember = (PackageMemberAnnotation)bugAnnotation).getSourceLines() != null) continue;
            throw new IllegalStateException("Package member " + String.valueOf(pkgMember) + " reported without source lines!");
        }
    }

    public String getOutputTarget() {
        return this.outputTarget;
    }

    public void setOutputTarget(String key) {
        this.outputTarget = key;
    }

    public boolean isDuplicateOf(TextUIBugReporter other) {
        return this.outputTarget != null && this.outputTarget.equals(other.outputTarget);
    }

    public boolean isApplySuppressions() {
        return this.applySuppressions;
    }
}

