/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
class CurrentThreadExecutorService
extends AbstractExecutorService {
    private static final Logger LOG = LoggerFactory.getLogger(CurrentThreadExecutorService.class);
    private boolean isShutdown = false;

    CurrentThreadExecutorService() {
    }

    @Override
    public void shutdown() {
        if (this.isShutdown) {
            throw new IllegalStateException("CurrentThreadExecutorService is closed again");
        }
        this.isShutdown = true;
        LOG.debug("CurrentThreadExecutorService is closed, do nothing");
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown();
        return Collections.emptyList();
    }

    @Override
    public boolean isShutdown() {
        return this.isShutdown;
    }

    @Override
    public boolean isTerminated() {
        return this.isShutdown;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) {
        if (!this.isShutdown) {
            throw new IllegalStateException("awaitTermination() should be called after the shutdown");
        }
        return true;
    }

    @Override
    public void execute(Runnable command) {
        command.run();
    }
}

