/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.ClassWarningSuppressor;
import edu.umd.cs.findbugs.PackageWarningSuppressor;
import edu.umd.cs.findbugs.WarningSuppressor;
import edu.umd.cs.findbugs.detect.UselessSuppressionDetector;
import edu.umd.cs.findbugs.filter.Matcher;
import edu.umd.cs.findbugs.xml.XMLOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public class SuppressionMatcher
implements Matcher {
    private final Map<ClassAnnotation, Collection<WarningSuppressor>> suppressedWarnings = new HashMap<ClassAnnotation, Collection<WarningSuppressor>>();
    private final Map<String, Collection<WarningSuppressor>> suppressedPackageWarnings = new HashMap<String, Collection<WarningSuppressor>>();
    private final Set<WarningSuppressor> matched = new HashSet<WarningSuppressor>();
    int count = 0;

    public void addPackageSuppressor(PackageWarningSuppressor suppressor) {
        String packageName = suppressor.getPackageName();
        Collection c = this.suppressedPackageWarnings.computeIfAbsent(packageName, k -> new LinkedList());
        c.add(suppressor);
    }

    public void addSuppressor(ClassWarningSuppressor suppressor) {
        ClassAnnotation clazz = suppressor.getClassAnnotation().getTopLevelClass();
        Collection c = this.suppressedWarnings.computeIfAbsent(clazz, k -> new LinkedList());
        c.add(suppressor);
    }

    public int count() {
        return this.count;
    }

    @Override
    public boolean match(BugInstance b) {
        ClassAnnotation clazz;
        Collection<WarningSuppressor> c;
        ClassAnnotation primaryClazz = b.getPrimaryClass();
        if (primaryClazz != null && (c = this.suppressedWarnings.get(clazz = b.getPrimaryClass().getTopLevelClass())) != null) {
            for (WarningSuppressor w : c) {
                if (!w.match(b)) continue;
                ++this.count;
                this.matched.add(w);
                this.matched.addAll(w.getAlternateSuppressors());
                return true;
            }
        }
        for (Collection<WarningSuppressor> c2 : this.suppressedPackageWarnings.values()) {
            for (WarningSuppressor w : c2) {
                if (!w.match(b)) continue;
                ++this.count;
                this.matched.add(w);
                return true;
            }
        }
        return false;
    }

    public void validateSuppressionUsage(BugReporter bugReporter, UselessSuppressionDetector detector) {
        Stream.concat(this.suppressedWarnings.values().stream(), this.suppressedPackageWarnings.values().stream()).flatMap(Collection::stream).filter(w -> w.isUselessSuppressionReportable() && !this.matched.contains(w)).map(w -> w.buildUselessSuppressionBugInstance(detector)).forEach(bugReporter::reportBug);
    }

    @Override
    public void writeXML(XMLOutput xmlOutput, boolean disabled) throws IOException {
    }
}

