/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.properties.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import net.sourceforge.pmd.properties.ConstraintViolatedException;
import net.sourceforge.pmd.properties.PropertyConstraint;
import net.sourceforge.pmd.properties.PropertySerializer;
import net.sourceforge.pmd.properties.internal.ValueSyntax;
import net.sourceforge.pmd.util.IteratorUtil;
import net.sourceforge.pmd.util.internal.xml.XmlUtil;

public final class PropertyParsingUtil {
    public static final ValueSyntax<String> STRING = ValueSyntax.withDefaultToString(String::trim);
    public static final ValueSyntax<Character> CHARACTER = ValueSyntax.partialFunction(c -> Character.toString(c.charValue()), s -> Character.valueOf(s.charAt(0)), PropertyConstraint.fromPredicate(s -> s.length() == 1, "Should be exactly one character in length"));
    public static final ValueSyntax<Pattern> REGEX = ValueSyntax.withDefaultToString(Pattern::compile);
    public static final ValueSyntax<Integer> INTEGER = ValueSyntax.withDefaultToString(PropertyParsingUtil.preTrim(Integer::valueOf));
    public static final ValueSyntax<Long> LONG = ValueSyntax.withDefaultToString(PropertyParsingUtil.preTrim(Long::valueOf));
    public static final ValueSyntax<Boolean> BOOLEAN = ValueSyntax.withDefaultToString(PropertyParsingUtil.preTrim(Boolean::valueOf));
    public static final ValueSyntax<Double> DOUBLE = ValueSyntax.withDefaultToString(PropertyParsingUtil.preTrim(Double::valueOf));
    public static final PropertySerializer<List<Integer>> INTEGER_LIST = PropertyParsingUtil.numberList(INTEGER);
    public static final PropertySerializer<List<Double>> DOUBLE_LIST = PropertyParsingUtil.numberList(DOUBLE);
    public static final PropertySerializer<List<Long>> LONG_LIST = PropertyParsingUtil.numberList(LONG);
    public static final PropertySerializer<List<Character>> CHAR_LIST = PropertyParsingUtil.otherList(CHARACTER);
    public static final PropertySerializer<List<String>> STRING_LIST = PropertyParsingUtil.otherList(STRING);
    private static final char ESCAPE_CHAR = '\\';

    private PropertyParsingUtil() {
    }

    private static <T extends Number> PropertySerializer<List<T>> numberList(ValueSyntax<T> valueSyntax) {
        return PropertyParsingUtil.delimitedString(valueSyntax, Collectors.toList());
    }

    private static <T> PropertySerializer<List<T>> otherList(ValueSyntax<T> valueSyntax) {
        return PropertyParsingUtil.delimitedString(valueSyntax, Collectors.toList());
    }

    private static <T> Function<String, ? extends T> preTrim(Function<? super String, ? extends T> parser) {
        return parser.compose(String::trim);
    }

    public static <T> PropertySerializer<Optional<T>> toOptional(PropertySerializer<T> itemSyntax, String missingValue) {
        return ValueSyntax.create(opt -> opt.map(itemSyntax::toString).orElse(missingValue), str -> {
            if (str.equals(missingValue)) {
                return Optional.empty();
            }
            return Optional.of(itemSyntax.fromString((String)str));
        });
    }

    public static <T> void checkConstraintsThrow(T t, List<? extends PropertyConstraint<? super T>> constraints) {
        ConstraintViolatedException exception = null;
        for (PropertyConstraint<T> constraint : constraints) {
            try {
                constraint.validate(t);
            }
            catch (ConstraintViolatedException e) {
                if (exception == null) {
                    exception = e;
                    continue;
                }
                exception.addSuppressed(e);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public static <T> PropertySerializer<T> withAllConstraints(PropertySerializer<T> mapper, List<PropertyConstraint<? super T>> constraints) {
        PropertySerializer<T> result = mapper;
        for (PropertyConstraint<T> propertyConstraint : constraints) {
            result = result.withConstraint(propertyConstraint);
        }
        return result;
    }

    public static <T, C extends Iterable<T>> PropertySerializer<C> delimitedString(PropertySerializer<T> itemSyntax, Collector<? super T, ?, ? extends C> collector) {
        String delim = ",";
        return ValueSyntax.create(coll -> IteratorUtil.toStream(coll.iterator()).map(itemSyntax::toString).collect(Collectors.joining(delim)), string -> (Iterable)PropertyParsingUtil.parseListWithEscapes(string, ',', itemSyntax::fromString).stream().collect(collector));
    }

    public static <U> List<U> parseListWithEscapes(String str, char delimiter, Function<? super String, ? extends U> extractor) {
        if (str.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<U> result = new ArrayList<U>();
        StringBuilder currentToken = new StringBuilder();
        boolean inEscapeMode = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (inEscapeMode) {
                inEscapeMode = false;
                currentToken.append(c);
                continue;
            }
            if (c == delimiter) {
                result.add(extractor.apply(currentToken.toString()));
                currentToken = new StringBuilder();
                continue;
            }
            if (c == '\\' && i < str.length() - 1) {
                inEscapeMode = true;
                continue;
            }
            currentToken.append(c);
        }
        if (currentToken.length() > 0) {
            result.add(extractor.apply(currentToken.toString()));
        }
        return result;
    }

    public static <T> ValueSyntax<T> enumerationParser(Map<String, T> mappings, Function<? super T, String> reverseFun) {
        if (mappings.containsValue(null)) {
            throw new IllegalArgumentException("Map may not contain entries with null values");
        }
        return ValueSyntax.partialFunction(reverseFun, mappings::get, PropertyConstraint.fromPredicate(mappings::containsKey, "Should be " + XmlUtil.formatPossibleNames(XmlUtil.toConstants(mappings.keySet()))));
    }
}

