/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.properties;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.internal.PropertyParsingUtil;
import net.sourceforge.pmd.properties.internal.ValueSyntax;
import net.sourceforge.pmd.util.CollectionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class PropertyFactory {
    public static final char DEFAULT_DELIMITER = ',';

    private PropertyFactory() {
    }

    public static PropertyBuilder.GenericPropertyBuilder<Integer> intProperty(String name) {
        return new PropertyBuilder.GenericPropertyBuilder<Integer>(name, PropertyParsingUtil.INTEGER);
    }

    public static PropertyBuilder.GenericCollectionPropertyBuilder<Integer, List<Integer>> intListProperty(String name) {
        return PropertyFactory.intProperty(name).toList();
    }

    public static PropertyBuilder.GenericPropertyBuilder<Long> longIntProperty(String name) {
        return new PropertyBuilder.GenericPropertyBuilder<Long>(name, PropertyParsingUtil.LONG);
    }

    public static PropertyBuilder.GenericCollectionPropertyBuilder<Long, List<Long>> longIntListProperty(String name) {
        return PropertyFactory.longIntProperty(name).toList();
    }

    public static PropertyBuilder.GenericPropertyBuilder<Double> doubleProperty(String name) {
        return new PropertyBuilder.GenericPropertyBuilder<Double>(name, PropertyParsingUtil.DOUBLE);
    }

    public static PropertyBuilder.GenericCollectionPropertyBuilder<Double, List<Double>> doubleListProperty(String name) {
        return PropertyFactory.doubleProperty(name).toList();
    }

    public static PropertyBuilder.RegexPropertyBuilder regexProperty(String name) {
        return new PropertyBuilder.RegexPropertyBuilder(name);
    }

    public static PropertyBuilder.GenericPropertyBuilder<String> stringProperty(String name) {
        return new PropertyBuilder.GenericPropertyBuilder<String>(name, PropertyParsingUtil.STRING);
    }

    public static PropertyBuilder.GenericCollectionPropertyBuilder<String, List<String>> stringListProperty(String name) {
        return PropertyFactory.stringProperty(name).toList();
    }

    public static PropertyBuilder.GenericPropertyBuilder<Character> charProperty(String name) {
        return new PropertyBuilder.GenericPropertyBuilder<Character>(name, PropertyParsingUtil.CHARACTER);
    }

    public static PropertyBuilder.GenericCollectionPropertyBuilder<Character, List<Character>> charListProperty(String name) {
        return PropertyFactory.charProperty(name).toList();
    }

    public static PropertyBuilder.GenericPropertyBuilder<Boolean> booleanProperty(String name) {
        return new PropertyBuilder.GenericPropertyBuilder<Boolean>(name, PropertyParsingUtil.BOOLEAN);
    }

    public static <T> PropertyBuilder.GenericPropertyBuilder<T> enumProperty(String name, Map<String, T> nameToValue) {
        ValueSyntax<Object> parser = PropertyParsingUtil.enumerationParser(nameToValue, t -> Objects.requireNonNull((String)CollectionUtil.getKeyOfValue(nameToValue, t)));
        return new PropertyBuilder.GenericPropertyBuilder<Object>(name, parser);
    }

    public static <T extends Enum<T>> PropertyBuilder.GenericPropertyBuilder<T> enumProperty(String name, Class<T> enumClass) {
        return PropertyFactory.enumProperty(name, enumClass, Object::toString);
    }

    public static <T extends Enum<T>> PropertyBuilder.GenericPropertyBuilder<T> enumProperty(String name, Class<T> enumClass, Function<? super T, @NonNull String> labelMaker) {
        Map<String, Enum> labelsToValues = Arrays.stream((Enum[])enumClass.getEnumConstants()).collect(Collectors.toMap(labelMaker, t -> t));
        return new PropertyBuilder.GenericPropertyBuilder<T>(name, PropertyParsingUtil.enumerationParser(labelsToValues, labelMaker));
    }

    public static <T> PropertyBuilder.GenericCollectionPropertyBuilder<T, List<T>> enumListProperty(String name, Map<String, T> nameToValue) {
        return PropertyFactory.enumProperty(name, nameToValue).toList();
    }

    public static <T extends Enum<T>> PropertyBuilder.GenericCollectionPropertyBuilder<T, List<T>> enumListProperty(String name, Class<T> enumClass, Function<? super T, String> labelMaker) {
        Map<String, ? super T> enumMap = CollectionUtil.associateBy(Arrays.asList((Enum[])enumClass.getEnumConstants()), labelMaker);
        return PropertyFactory.enumListProperty(name, enumMap);
    }
}

