/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.impl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import net.sourceforge.pmd.annotation.Experimental;
import net.sourceforge.pmd.cpd.CpdCapableLanguage;
import net.sourceforge.pmd.cpd.CpdLexer;
import net.sourceforge.pmd.lang.AbstractPmdLanguageVersionHandler;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageModuleBase;
import net.sourceforge.pmd.lang.LanguageProcessor;
import net.sourceforge.pmd.lang.LanguagePropertyBundle;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.LanguageVersionHandler;
import net.sourceforge.pmd.lang.PmdCapableLanguage;
import net.sourceforge.pmd.lang.ast.Parser;
import net.sourceforge.pmd.lang.impl.BasePmdDialectLanguageVersionHandler;
import net.sourceforge.pmd.lang.impl.BatchLanguageProcessor;
import net.sourceforge.pmd.lang.metrics.LanguageMetricsProvider;
import net.sourceforge.pmd.lang.rule.xpath.impl.XPathHandler;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.reporting.ViolationDecorator;
import net.sourceforge.pmd.reporting.ViolationSuppressor;
import net.sourceforge.pmd.util.CollectionUtil;
import net.sourceforge.pmd.util.designerbindings.DesignerBindings;
import org.checkerframework.checker.nullness.qual.NonNull;

@Experimental
public class SimpleDialectLanguageModuleBase
extends LanguageModuleBase
implements PmdCapableLanguage,
CpdCapableLanguage {
    private final Function<LanguagePropertyBundle, BasePmdDialectLanguageVersionHandler> handler;

    protected SimpleDialectLanguageModuleBase(LanguageModuleBase.DialectLanguageMetadata metadata) {
        this(metadata, new BasePmdDialectLanguageVersionHandler());
    }

    protected SimpleDialectLanguageModuleBase(LanguageModuleBase.DialectLanguageMetadata metadata, BasePmdDialectLanguageVersionHandler handler) {
        this(metadata, (LanguagePropertyBundle p) -> handler);
    }

    protected SimpleDialectLanguageModuleBase(LanguageModuleBase.DialectLanguageMetadata metadata, Function<LanguagePropertyBundle, BasePmdDialectLanguageVersionHandler> makeHandler) {
        super(metadata);
        assert (this.getBaseLanguageId() != null) : "Language " + this.getId() + " is not a dialect of another language.";
        this.handler = makeHandler;
    }

    private @NonNull Language getBaseLanguageFromRegistry(LanguageRegistry registry) {
        Language baseLanguage = registry.getLanguageById(this.getBaseLanguageId());
        if (baseLanguage == null) {
            throw new IllegalStateException("Language " + this.getId() + " has unsatisfied dependencies: " + this.getBaseLanguageId() + " is not found in " + registry);
        }
        return baseLanguage;
    }

    @Override
    public final LanguagePropertyBundle newPropertyBundle() {
        LanguagePropertyBundle baseBundle = this.getBaseLanguageFromRegistry(LanguageRegistry.PMD).newPropertyBundle();
        LanguagePropertyBundle dialectBundle = this.newDialectPropertyBundle();
        for (PropertyDescriptor<?> pd : baseBundle.getPropertyDescriptors()) {
            if (dialectBundle.hasDescriptor(pd)) continue;
            dialectBundle.definePropertyDescriptor(pd);
        }
        return dialectBundle;
    }

    protected @NonNull LanguagePropertyBundle newDialectPropertyBundle() {
        return new LanguagePropertyBundle(this);
    }

    @Override
    public final LanguageProcessor createProcessor(LanguagePropertyBundle bundle) {
        PmdCapableLanguage baseLanguage = (PmdCapableLanguage)this.getBaseLanguageFromRegistry(LanguageRegistry.PMD);
        BasePmdDialectLanguageVersionHandler dialectHandler = this.handler.apply(bundle);
        return new DialectLanguageProcessor(baseLanguage, dialectHandler, bundle);
    }

    @Override
    public CpdLexer createCpdLexer(LanguagePropertyBundle bundle) {
        CpdCapableLanguage baseLanguage = (CpdCapableLanguage)this.getBaseLanguageFromRegistry(LanguageRegistry.CPD);
        return baseLanguage.createCpdLexer(bundle);
    }

    private static class SimpleDialectLanguageVersionHandler
    extends AbstractPmdLanguageVersionHandler {
        private final LanguageVersionHandler baseLanguageVersionHandler;
        private final LanguageVersionHandler dialectLanguageVersionHandler;

        SimpleDialectLanguageVersionHandler(LanguageVersionHandler baseLanguageVersionHandler, LanguageVersionHandler dialectLanguageVersionHandler) {
            this.baseLanguageVersionHandler = baseLanguageVersionHandler;
            this.dialectLanguageVersionHandler = dialectLanguageVersionHandler;
        }

        @Override
        public XPathHandler getXPathHandler() {
            return this.baseLanguageVersionHandler.getXPathHandler().combine(this.dialectLanguageVersionHandler.getXPathHandler());
        }

        @Override
        public Parser getParser() {
            return this.baseLanguageVersionHandler.getParser();
        }

        @Override
        public ViolationDecorator getViolationDecorator() {
            return ViolationDecorator.chain(Arrays.asList(this.baseLanguageVersionHandler.getViolationDecorator(), this.dialectLanguageVersionHandler.getViolationDecorator()));
        }

        @Override
        public List<ViolationSuppressor> getExtraViolationSuppressors() {
            return CollectionUtil.concatView(this.baseLanguageVersionHandler.getExtraViolationSuppressors(), this.dialectLanguageVersionHandler.getExtraViolationSuppressors());
        }

        @Override
        public LanguageMetricsProvider getLanguageMetricsProvider() {
            if (this.baseLanguageVersionHandler.getLanguageMetricsProvider() == null) {
                return this.dialectLanguageVersionHandler.getLanguageMetricsProvider();
            }
            if (this.dialectLanguageVersionHandler.getLanguageMetricsProvider() == null) {
                return this.baseLanguageVersionHandler.getLanguageMetricsProvider();
            }
            return () -> {
                HashSet mergedSet = new HashSet();
                mergedSet.addAll(this.baseLanguageVersionHandler.getLanguageMetricsProvider().getMetrics());
                mergedSet.addAll(this.dialectLanguageVersionHandler.getLanguageMetricsProvider().getMetrics());
                return mergedSet;
            };
        }

        @Override
        public DesignerBindings getDesignerBindings() {
            if (DesignerBindings.DefaultDesignerBindings.getInstance().equals(this.dialectLanguageVersionHandler.getDesignerBindings())) {
                return this.baseLanguageVersionHandler.getDesignerBindings();
            }
            return this.dialectLanguageVersionHandler.getDesignerBindings();
        }
    }

    private static final class DialectLanguageProcessor
    extends BatchLanguageProcessor<LanguagePropertyBundle> {
        private final LanguageProcessor baseLanguageProcessor;
        private final LanguageVersionHandler combinedHandler;

        private DialectLanguageProcessor(PmdCapableLanguage baseLanguage, BasePmdDialectLanguageVersionHandler dialectHandler, LanguagePropertyBundle bundle) {
            super(bundle);
            this.baseLanguageProcessor = baseLanguage.createProcessor(bundle);
            this.combinedHandler = new SimpleDialectLanguageVersionHandler(this.baseLanguageProcessor.services(), dialectHandler);
        }

        @Override
        public @NonNull LanguageVersionHandler services() {
            return this.combinedHandler;
        }

        @Override
        public @NonNull AutoCloseable launchAnalysis(@NonNull LanguageProcessor.AnalysisTask analysisTask) {
            return this.baseLanguageProcessor.launchAnalysis(analysisTask);
        }

        @Override
        public void close() throws Exception {
            super.close();
            this.baseLanguageProcessor.close();
        }
    }
}

