/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast.impl.antlr4;

import net.sourceforge.pmd.lang.TokenManager;
import net.sourceforge.pmd.lang.ast.LexException;
import net.sourceforge.pmd.lang.ast.impl.antlr4.AntlrToken;
import net.sourceforge.pmd.lang.document.TextDocument;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;

public class AntlrTokenManager
implements TokenManager<AntlrToken> {
    private final Lexer lexer;
    private final TextDocument textDoc;
    private AntlrToken previousToken;

    public AntlrTokenManager(Lexer lexer, TextDocument textDocument) {
        this.lexer = lexer;
        this.textDoc = textDocument;
        this.resetListeners();
    }

    @Override
    public AntlrToken getNextToken() {
        AntlrToken nextToken = this.getNextTokenFromAnyChannel();
        while (!nextToken.isDefault()) {
            nextToken = this.getNextTokenFromAnyChannel();
        }
        return nextToken;
    }

    private AntlrToken getNextTokenFromAnyChannel() {
        AntlrToken previousComment = this.previousToken != null && this.previousToken.isHidden() ? this.previousToken : null;
        AntlrToken currentToken = new AntlrToken(this.lexer.nextToken(), previousComment, this.textDoc);
        if (this.previousToken != null) {
            this.previousToken.next = currentToken;
        }
        this.previousToken = currentToken;
        return currentToken;
    }

    private void resetListeners() {
        this.lexer.removeErrorListeners();
        this.lexer.addErrorListener((ANTLRErrorListener)new ErrorHandler());
    }

    private final class ErrorHandler
    extends BaseErrorListener {
        private ErrorHandler() {
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException ex) {
            throw new LexException(line, charPositionInLine, AntlrTokenManager.this.textDoc.getFileId(), msg, (Throwable)ex);
        }
    }
}

