/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.LookaheadParser;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.LookaheadStream;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@SuppressFBWarnings(value={"REDOS"})
public class XlcCompilerParser
extends LookaheadParser {
    private static final long serialVersionUID = 5490211629355204910L;
    private static final String XLC_WARNING_PATTERN = "^(?:.*\\[[^]]*\\])?\\s*.*((?:[A-Z]+|[0-9]+-)[0-9]+)* ?\\([USEWI]\\)\\s*(.*)$";
    private static final String XLC_WARNING_PATTERN_WITH_LINE = "^(?:.*\\[[^]]*\\])?\\s*\"?([^\"]*)\"?, line ([0-9]+)\\.[0-9]+:( (?:[A-Z]+|[0-9]+-)[0-9]+)? \\(([USEWI])\\)\\s*(.*)$";
    private static final String XLC_WARNING_PATTERN_NO_LINE = "^(?:.*\\[[^]]*\\])?\\s*\\s*((?:[A-Z]+|[0-9]+-)[0-9]+)?:? ?\\(([USEWI])\\)( INFORMATION:)?\\s*(.*)$";
    private static final Pattern PATTERN_WITH_LINE = Pattern.compile("^(?:.*\\[[^]]*\\])?\\s*\"?([^\"]*)\"?, line ([0-9]+)\\.[0-9]+:( (?:[A-Z]+|[0-9]+-)[0-9]+)? \\(([USEWI])\\)\\s*(.*)$");
    private static final Pattern PATTERN_WITHOUT_LINE = Pattern.compile("^(?:.*\\[[^]]*\\])?\\s*\\s*((?:[A-Z]+|[0-9]+-)[0-9]+)?:? ?\\(([USEWI])\\)( INFORMATION:)?\\s*(.*)$");

    public XlcCompilerParser() {
        super(XLC_WARNING_PATTERN);
    }

    private Severity toPriority(String severity) {
        return switch (severity.charAt(0)) {
            case 'E', 'S', 'U' -> Severity.WARNING_HIGH;
            case 'W' -> Severity.WARNING_NORMAL;
            case 'I' -> Severity.WARNING_LOW;
            default -> Severity.WARNING_HIGH;
        };
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, LookaheadStream lookahead, IssueBuilder builder) {
        String line = matcher.group(0);
        Matcher lineMatcher = PATTERN_WITH_LINE.matcher(line);
        if (lineMatcher.find()) {
            return builder.setFileName(lineMatcher.group(1)).setLineStart(lineMatcher.group(2)).setCategory(lineMatcher.group(3).trim()).setMessage(lineMatcher.group(5)).setSeverity(this.toPriority(lineMatcher.group(4))).buildOptional();
        }
        return this.createIssueWithoutLine(builder, line);
    }

    private Optional<Issue> createIssueWithoutLine(IssueBuilder builder, String line) {
        Matcher matcher = PATTERN_WITHOUT_LINE.matcher(line);
        if (matcher.find()) {
            return builder.setFileName("").setLineStart(0).setCategory(matcher.group(1).trim()).setMessage(matcher.group(4)).setSeverity(this.toPriority(matcher.group(2))).buildOptional();
        }
        return Optional.empty();
    }
}

