/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class AjcParser
extends IssueParser {
    private static final long serialVersionUID = -9123765511497052454L;
    private static final Pattern ESCAPE_CHARACTERS = Pattern.compile("\u001b\\[.*\u001b\\[0m");
    private static final String WARNING_TAG = "[WARNING] ";
    static final String ADVICE = "Advice";

    @Override
    public Report parseReport(ReaderFactory reader) throws ParsingException {
        Report report;
        block8: {
            Stream<String> lines = reader.readStream();
            try {
                report = this.parse(lines);
                if (lines == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (lines != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (UncheckedIOException exception) {
                    throw new ParsingException(exception, reader);
                }
            }
            lines.close();
        }
        return report;
    }

    private Report parse(Stream<String> lines) {
        try (IssueBuilder builder = new IssueBuilder();){
            Report report = new Report();
            States state = States.START;
            Iterator lineIterator = lines.iterator();
            while (lineIterator.hasNext()) {
                String line = (String)lineIterator.next();
                line = ESCAPE_CHARACTERS.matcher(line).replaceAll("");
                switch (state.ordinal()) {
                    case 0: {
                        if (!line.startsWith("[INFO] Showing AJC message detail for messages of types")) break;
                        state = States.PARSING;
                        break;
                    }
                    case 1: {
                        if (!line.startsWith(WARNING_TAG)) break;
                        line = line.substring(WARNING_TAG.length());
                        state = States.WAITING_FOR_END;
                        this.fillMessageAndCategory(builder, line);
                        break;
                    }
                    case 2: {
                        if (line.startsWith("\t")) {
                            this.fillFileName(builder, line);
                            break;
                        }
                        if (!line.isEmpty()) break;
                        state = States.PARSING;
                        report.add(builder.buildAndClean());
                    }
                }
            }
            Report report2 = report;
            return report2;
        }
    }

    private void fillFileName(IssueBuilder builder, String line) {
        int indexOfColon = line.lastIndexOf(58);
        if (indexOfColon != -1) {
            builder.setFileName(line.substring(0, indexOfColon));
            if (line.length() > indexOfColon + 1) {
                builder.setLineStart(line.substring(indexOfColon + 1));
            }
        }
    }

    private void fillMessageAndCategory(IssueBuilder builder, String line) {
        String category = line.contains("is deprecated") || line.contains("overrides a deprecated") ? "Deprecation" : (line.contains("adviceDidNotMatch") ? ADVICE : "");
        builder.setMessage(line);
        builder.setCategory(category);
    }

    private static enum States {
        START,
        PARSING,
        WAITING_FOR_END;

    }
}

