/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types.internal.infer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.internal.infer.ExprMirror;
import net.sourceforge.pmd.lang.java.types.internal.infer.Infer;
import net.sourceforge.pmd.lang.java.types.internal.infer.InferenceContext;
import net.sourceforge.pmd.lang.java.types.internal.infer.MethodResolutionPhase;
import net.sourceforge.pmd.lang.java.types.internal.infer.PolySite;
import net.sourceforge.pmd.lang.java.types.internal.infer.ResolutionFailure;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MethodCallSite
extends PolySite<ExprMirror.InvocationMirror> {
    private final InferenceContext localInferenceContext;
    private final MethodCallSite outerSite;
    private boolean logEnabled = true;
    private final Map<MethodResolutionPhase, List<ResolutionFailure>> errors = new EnumMap<MethodResolutionPhase, List<ResolutionFailure>>(MethodResolutionPhase.class);
    private boolean isInInvocation = false;
    private boolean canSkipInvocation = true;
    private boolean needsUncheckedConversion = false;
    private final boolean isSpecificityCheck;

    MethodCallSite(ExprMirror.InvocationMirror expr, @Nullable JTypeMirror expectedType, @Nullable MethodCallSite outerSite, @NonNull InferenceContext infCtx, boolean isSpecificityCheck) {
        super(expr, expectedType);
        this.outerSite = outerSite;
        this.localInferenceContext = infCtx;
        this.isSpecificityCheck = isSpecificityCheck;
    }

    boolean isSpecificityCheck() {
        return this.isSpecificityCheck;
    }

    MethodCallSite cloneForSpecificityCheck(Infer infer) {
        return new MethodCallSite((ExprMirror.InvocationMirror)this.getExpr(), this.getExpectedType(), null, infer.emptyContext(), true);
    }

    void acceptFailure(ResolutionFailure exception) {
        if (this.logEnabled) {
            this.errors.computeIfAbsent(exception.getPhase(), k -> new ArrayList()).add(exception);
        }
    }

    public boolean isLogEnabled() {
        return this.logEnabled;
    }

    void setLogging(boolean enabled) {
        this.logEnabled = enabled;
    }

    void setInInvocation() {
        this.isInInvocation = true;
    }

    void maySkipInvocation(boolean canSkipInvocation) {
        this.canSkipInvocation &= canSkipInvocation;
    }

    boolean canSkipInvocation() {
        return this.canSkipInvocation;
    }

    boolean isInFinalInvocation() {
        return (this.outerSite == null || this.outerSite.isInFinalInvocation()) && this.isInInvocation;
    }

    public Map<MethodResolutionPhase, List<ResolutionFailure>> getResolutionFailures() {
        return Collections.unmodifiableMap(this.errors);
    }

    void clearFailures() {
        this.errors.clear();
    }

    boolean needsUncheckedConversion() {
        return this.needsUncheckedConversion;
    }

    void setNeedsUncheckedConversion() {
        this.needsUncheckedConversion = true;
    }

    void resetInferenceData() {
        this.canSkipInvocation = true;
        this.needsUncheckedConversion = false;
        this.isInInvocation = false;
    }

    void loadInferenceData(ExprMirror.InvocationMirror.MethodCtDecl ctdecl) {
        this.canSkipInvocation = ctdecl.canSkipInvocation();
        this.needsUncheckedConversion = ctdecl.needsUncheckedConversion();
    }

    @NonNull InferenceContext getOuterCtx() {
        return this.localInferenceContext;
    }

    @Override
    public String toString() {
        return "CallSite:" + this.getExpr();
    }
}

