/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.JExecutableSymbol;
import net.sourceforge.pmd.lang.java.symbols.JFieldSymbol;
import net.sourceforge.pmd.lang.java.symbols.JFormalParamSymbol;
import net.sourceforge.pmd.lang.java.symbols.JLocalVariableSymbol;
import net.sourceforge.pmd.lang.java.symbols.JModuleSymbol;
import net.sourceforge.pmd.lang.java.symbols.JTypeDeclSymbol;
import net.sourceforge.pmd.lang.java.symbols.JTypeParameterSymbol;
import net.sourceforge.pmd.lang.java.symbols.SymbolResolver;
import net.sourceforge.pmd.lang.java.symbols.SymbolicValue;
import net.sourceforge.pmd.lang.java.symbols.internal.UnresolvedClassStore;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.AsmSymbolResolver;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.Classpath;
import net.sourceforge.pmd.lang.java.types.ArraySymbolImpl;
import net.sourceforge.pmd.lang.java.types.BasePrimitiveSymbol;
import net.sourceforge.pmd.lang.java.types.ClassMethodSigImpl;
import net.sourceforge.pmd.lang.java.types.ClassTypeImpl;
import net.sourceforge.pmd.lang.java.types.ErasedClassType;
import net.sourceforge.pmd.lang.java.types.JArrayType;
import net.sourceforge.pmd.lang.java.types.JClassType;
import net.sourceforge.pmd.lang.java.types.JMethodSig;
import net.sourceforge.pmd.lang.java.types.JPrimitiveType;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.JTypeVar;
import net.sourceforge.pmd.lang.java.types.JTypeVisitor;
import net.sourceforge.pmd.lang.java.types.JVariableSig;
import net.sourceforge.pmd.lang.java.types.JWildcardType;
import net.sourceforge.pmd.lang.java.types.Lub;
import net.sourceforge.pmd.lang.java.types.SentinelType;
import net.sourceforge.pmd.lang.java.types.SubstVar;
import net.sourceforge.pmd.lang.java.types.Substitution;
import net.sourceforge.pmd.lang.java.types.TypeVarImpl;
import net.sourceforge.pmd.lang.java.types.UnresolvedMethodSig;
import net.sourceforge.pmd.lang.java.types.WildcardTypeImpl;
import net.sourceforge.pmd.util.AssertionUtil;
import net.sourceforge.pmd.util.CollectionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.pcollections.HashTreePSet;
import org.pcollections.PSet;

public final class TypeSystem {
    public final JClassType OBJECT;
    public final JTypeMirror NULL_TYPE = new NullType(this);
    public final JPrimitiveType BOOLEAN;
    public final JPrimitiveType CHAR;
    public final JPrimitiveType BYTE;
    public final JPrimitiveType SHORT;
    public final JPrimitiveType INT;
    public final JPrimitiveType LONG;
    public final JPrimitiveType FLOAT;
    public final JPrimitiveType DOUBLE;
    public final Set<JPrimitiveType> allPrimitives;
    private final Map<JPrimitiveType.PrimitiveTypeKind, JPrimitiveType> primitivesByKind;
    public final JTypeMirror NO_TYPE;
    public final JTypeMirror UNKNOWN;
    public final JTypeMirror ERROR;
    public final JMethodSig UNRESOLVED_METHOD = new UnresolvedMethodSig(this);
    public final JWildcardType UNBOUNDED_WILD;
    public final JClassType CLONEABLE;
    public final JClassType SERIALIZABLE;
    public final JClassType BOXED_VOID;
    private final Map<JTypeDeclSymbol, JTypeMirror> sharedTypes;
    final SymbolResolver resolver;

    public static TypeSystem usingClassLoaderClasspath(ClassLoader bootstrapResourceLoader) {
        return TypeSystem.usingClasspath(Classpath.forClassLoader(bootstrapResourceLoader));
    }

    public static TypeSystem usingClasspath(Classpath bootstrapResourceLoader) {
        return new TypeSystem(ts -> new AsmSymbolResolver((TypeSystem)ts, bootstrapResourceLoader));
    }

    public TypeSystem(Function<TypeSystem, ? extends SymbolResolver> symResolverMaker) {
        this.resolver = symResolverMaker.apply(this);
        this.BOOLEAN = this.createPrimitive(JPrimitiveType.PrimitiveTypeKind.BOOLEAN, Boolean.class);
        this.CHAR = this.createPrimitive(JPrimitiveType.PrimitiveTypeKind.CHAR, Character.class);
        this.BYTE = this.createPrimitive(JPrimitiveType.PrimitiveTypeKind.BYTE, Byte.class);
        this.SHORT = this.createPrimitive(JPrimitiveType.PrimitiveTypeKind.SHORT, Short.class);
        this.INT = this.createPrimitive(JPrimitiveType.PrimitiveTypeKind.INT, Integer.class);
        this.LONG = this.createPrimitive(JPrimitiveType.PrimitiveTypeKind.LONG, Long.class);
        this.FLOAT = this.createPrimitive(JPrimitiveType.PrimitiveTypeKind.FLOAT, Float.class);
        this.DOUBLE = this.createPrimitive(JPrimitiveType.PrimitiveTypeKind.DOUBLE, Double.class);
        this.BOOLEAN.superTypes = CollectionUtil.immutableSetOf((Object)this.BOOLEAN, (Object[])new JTypeMirror[0]);
        this.CHAR.superTypes = CollectionUtil.immutableSetOf((Object)this.CHAR, (Object[])new JTypeMirror[]{this.INT, this.LONG, this.FLOAT, this.DOUBLE});
        this.BYTE.superTypes = CollectionUtil.immutableSetOf((Object)this.BYTE, (Object[])new JTypeMirror[]{this.SHORT, this.INT, this.LONG, this.FLOAT, this.DOUBLE});
        this.SHORT.superTypes = CollectionUtil.immutableSetOf((Object)this.SHORT, (Object[])new JTypeMirror[]{this.INT, this.LONG, this.FLOAT, this.DOUBLE});
        this.INT.superTypes = CollectionUtil.immutableSetOf((Object)this.INT, (Object[])new JTypeMirror[]{this.LONG, this.FLOAT, this.DOUBLE});
        this.LONG.superTypes = CollectionUtil.immutableSetOf((Object)this.LONG, (Object[])new JTypeMirror[]{this.FLOAT, this.DOUBLE});
        this.FLOAT.superTypes = CollectionUtil.immutableSetOf((Object)this.FLOAT, (Object[])new JTypeMirror[]{this.DOUBLE});
        this.DOUBLE.superTypes = CollectionUtil.immutableSetOf((Object)this.DOUBLE, (Object[])new JTypeMirror[0]);
        this.allPrimitives = CollectionUtil.immutableSetOf((Object)this.BOOLEAN, (Object[])new JPrimitiveType[]{this.CHAR, this.BYTE, this.SHORT, this.INT, this.LONG, this.FLOAT, this.DOUBLE});
        this.primitivesByKind = new EnumMap<JPrimitiveType.PrimitiveTypeKind, JPrimitiveType>(JPrimitiveType.PrimitiveTypeKind.class);
        this.primitivesByKind.put(JPrimitiveType.PrimitiveTypeKind.BOOLEAN, this.BOOLEAN);
        this.primitivesByKind.put(JPrimitiveType.PrimitiveTypeKind.CHAR, this.CHAR);
        this.primitivesByKind.put(JPrimitiveType.PrimitiveTypeKind.BYTE, this.BYTE);
        this.primitivesByKind.put(JPrimitiveType.PrimitiveTypeKind.SHORT, this.SHORT);
        this.primitivesByKind.put(JPrimitiveType.PrimitiveTypeKind.INT, this.INT);
        this.primitivesByKind.put(JPrimitiveType.PrimitiveTypeKind.LONG, this.LONG);
        this.primitivesByKind.put(JPrimitiveType.PrimitiveTypeKind.FLOAT, this.FLOAT);
        this.primitivesByKind.put(JPrimitiveType.PrimitiveTypeKind.DOUBLE, this.DOUBLE);
        UnresolvedClassStore unresolvedSyms = new UnresolvedClassStore(this);
        JClassSymbol unresolvedTypeSym = unresolvedSyms.makeUnresolvedReference("(*unknown*)", 0);
        this.UNKNOWN = new SentinelType(this, "(*unknown*)", unresolvedTypeSym);
        JClassSymbol errorTypeSym = unresolvedSyms.makeUnresolvedReference("(*error*)", 0);
        this.ERROR = new SentinelType(this, "(*error*)", errorTypeSym);
        BasePrimitiveSymbol.VoidSymbol primitiveVoidSym = new BasePrimitiveSymbol.VoidSymbol(this);
        this.NO_TYPE = new SentinelType(this, "void", primitiveVoidSym);
        HashMap<JClassSymbol, JTypeMirror> shared = new HashMap<JClassSymbol, JTypeMirror>();
        this.OBJECT = this.addSpecial(Object.class, shared);
        this.SERIALIZABLE = this.addSpecial(Serializable.class, shared);
        this.CLONEABLE = this.addSpecial(Cloneable.class, shared);
        this.BOXED_VOID = this.addSpecial(Void.class, shared);
        shared.put(primitiveVoidSym, this.NO_TYPE);
        shared.put(unresolvedTypeSym, this.UNKNOWN);
        shared.put(errorTypeSym, this.ERROR);
        for (JPrimitiveType prim : this.allPrimitives) {
            shared.put(prim.getSymbol(), prim);
            shared.put(prim.box().getSymbol(), prim.box());
        }
        this.sharedTypes = Collections.unmodifiableMap(new HashMap<JClassSymbol, JTypeMirror>(shared));
        this.UNBOUNDED_WILD = new WildcardTypeImpl(this, true, this.OBJECT, (PSet<SymbolicValue.SymAnnot>)HashTreePSet.empty());
    }

    public SymbolResolver bootstrapResolver() {
        return this.resolver;
    }

    private JClassType addSpecial(Class<?> klass, Map<JClassSymbol, JTypeMirror> shared) {
        JClassSymbol sym = this.getBootStrapSymbol(klass);
        ClassTypeImpl nonErased = new ClassTypeImpl(this, sym, (PSet<SymbolicValue.SymAnnot>)HashTreePSet.empty());
        shared.put(sym, nonErased);
        return nonErased;
    }

    private JClassSymbol getBootStrapSymbol(Class<?> clazz) {
        AssertionUtil.requireParamNotNull((String)"clazz", clazz);
        JClassSymbol sym = this.resolver.resolveClassFromBinaryName(clazz.getName());
        return Objects.requireNonNull(sym, "sym");
    }

    private @NonNull JPrimitiveType createPrimitive(JPrimitiveType.PrimitiveTypeKind kind, Class<?> box) {
        return new JPrimitiveType(this, kind, new BasePrimitiveSymbol.RealPrimitiveSymbol(this, kind), this.getBootStrapSymbol(box), (PSet<SymbolicValue.SymAnnot>)HashTreePSet.empty());
    }

    public @Nullable JClassSymbol getClassSymbol(@Nullable Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isPrimitive()) {
            JPrimitiveType.PrimitiveTypeKind kind = JPrimitiveType.PrimitiveTypeKind.fromName(clazz.getName());
            if (kind == null) {
                return (JClassSymbol)this.NO_TYPE.getSymbol();
            }
            return this.getPrimitive(kind).getSymbol();
        }
        if (clazz.isArray()) {
            return new ArraySymbolImpl(this, this.getClassSymbol(clazz.getComponentType()));
        }
        return this.resolver.resolveClassFromBinaryName(clazz.getName());
    }

    public @Nullable JClassSymbol getClassSymbol(String binaryName) {
        return this.getClassSymbolImpl(binaryName, false);
    }

    public @Nullable JClassSymbol getClassSymbolFromCanonicalName(String canonicalName) {
        return this.getClassSymbolImpl(canonicalName, true);
    }

    private @Nullable JClassSymbol getClassSymbolImpl(String name, boolean isCanonical) {
        if (name == null) {
            return null;
        }
        if ("void".equals(name)) {
            return (JClassSymbol)this.NO_TYPE.getSymbol();
        }
        JPrimitiveType.PrimitiveTypeKind kind = JPrimitiveType.PrimitiveTypeKind.fromName(name);
        if (kind != null) {
            return this.getPrimitive(kind).getSymbol();
        }
        AssertionUtil.assertValidJavaBinaryNameNoArray((CharSequence)name);
        return isCanonical ? this.resolver.resolveClassFromCanonicalName(name) : this.resolver.resolveClassFromBinaryName(name);
    }

    public @Nullable JModuleSymbol getModuleSymbol(String moduleName) {
        return this.resolver.resolveModule(moduleName);
    }

    public JTypeMirror typeOf(@Nullable JTypeDeclSymbol symbol, boolean isErased) {
        if (symbol == null) {
            return null;
        }
        JTypeMirror common = this.specialCache(symbol);
        if (common != null) {
            return common;
        }
        if (symbol instanceof JClassSymbol) {
            JClassSymbol classSym = (JClassSymbol)symbol;
            if (classSym.isArray()) {
                JTypeMirror component = this.typeOf(classSym.getArrayComponent(), isErased);
                assert (component != null) : "the symbol necessarily has an array component symbol";
                return this.arrayType(component, classSym);
            }
            return new ClassTypeImpl(this, classSym, CollectionUtil.emptyList(), isErased, (PSet<SymbolicValue.SymAnnot>)HashTreePSet.empty());
        }
        if (symbol instanceof JTypeParameterSymbol) {
            return ((JTypeParameterSymbol)symbol).getTypeMirror();
        }
        throw AssertionUtil.shouldNotReachHere((String)("Uncategorized type symbol " + symbol.getClass() + ": " + symbol));
    }

    JClassType forceErase(JClassType t) {
        JClassType erasure = t.getErasure();
        if (erasure == t) {
            return new ErasedClassType(this, t.getSymbol(), t.getTypeAnnotations());
        }
        return erasure;
    }

    public JTypeMirror rawType(@Nullable JTypeDeclSymbol klass) {
        return this.typeOf(klass, true);
    }

    public JTypeMirror declaration(@Nullable JClassSymbol klass) {
        return this.typeOf(klass, false);
    }

    public @NonNull JTypeMirror parameterise(@NonNull JClassSymbol klass, @NonNull List<? extends JTypeMirror> typeArgs) {
        if (typeArgs.isEmpty()) {
            return this.rawType(klass);
        }
        return new ClassTypeImpl(this, klass, CollectionUtil.defensiveUnmodifiableCopy(typeArgs), true, (PSet<SymbolicValue.SymAnnot>)HashTreePSet.empty());
    }

    public JTypeMirror arrayType(@NonNull JTypeMirror element, int numDimensions) {
        AssertionUtil.requireNonNegative((String)"numDimensions", (int)numDimensions);
        this.checkArrayElement(element);
        if (numDimensions == 0) {
            return element;
        }
        JArrayType res = new JArrayType(this, element);
        while (--numDimensions > 0) {
            res = new JArrayType(this, res);
        }
        return res;
    }

    public JArrayType arrayType(@NonNull JTypeMirror component) {
        return this.arrayType(component, null);
    }

    private JArrayType arrayType(@NonNull JTypeMirror component, @Nullable JClassSymbol symbol) {
        this.checkArrayElement(component);
        return new JArrayType(this, component, symbol, (PSet<SymbolicValue.SymAnnot>)HashTreePSet.empty());
    }

    private void checkArrayElement(@NonNull JTypeMirror element) {
        AssertionUtil.requireParamNotNull((String)"elementType", (Object)element);
        if (element instanceof JWildcardType || element == this.NULL_TYPE || element == this.NO_TYPE) {
            throw new IllegalArgumentException("The type < " + element + " > is not a valid array element type");
        }
    }

    public JMethodSig sigOf(JExecutableSymbol methodSym) {
        return this.sigOf(methodSym, Substitution.EMPTY);
    }

    public JMethodSig sigOf(JExecutableSymbol methodSym, Substitution subst) {
        JClassType klass = (JClassType)this.declaration(methodSym.getEnclosingClass());
        return new ClassMethodSigImpl((JClassType)klass.subst((Function)subst), methodSym);
    }

    public JVariableSig.FieldSig sigOf(JTypeMirror decl, JFieldSymbol fieldSym) {
        return JVariableSig.forField(decl, fieldSym);
    }

    public JVariableSig sigOf(JClassType decl, JLocalVariableSymbol fieldSym) {
        return JVariableSig.forLocal(decl, fieldSym);
    }

    public JVariableSig sigOf(JClassType decl, JFormalParamSymbol fieldSym) {
        return JVariableSig.forLocal(decl, fieldSym);
    }

    public JWildcardType wildcard(boolean isUpperBound, @NonNull JTypeMirror bound) {
        Objects.requireNonNull(bound, "Argument shouldn't be null");
        if (bound.isPrimitive() || bound instanceof JWildcardType) {
            throw new IllegalArgumentException("<" + bound + "> cannot be a wildcard bound");
        }
        return isUpperBound && bound == this.OBJECT ? this.UNBOUNDED_WILD : new WildcardTypeImpl(this, isUpperBound, bound, (PSet<SymbolicValue.SymAnnot>)HashTreePSet.empty());
    }

    private @Nullable JTypeMirror specialCache(JTypeDeclSymbol raw) {
        return this.sharedTypes.get(raw);
    }

    public @NonNull JPrimitiveType getPrimitive(@NonNull JPrimitiveType.PrimitiveTypeKind kind) {
        AssertionUtil.requireParamNotNull((String)"kind", (Object)((Object)kind));
        return this.primitivesByKind.get((Object)kind);
    }

    public JTypeMirror lub(Collection<? extends JTypeMirror> types) {
        return Lub.lub(this, types);
    }

    public JTypeMirror glb(Collection<? extends JTypeMirror> types) {
        return Lub.glb(this, types);
    }

    JClassType erasedType(@NonNull JClassSymbol symbol) {
        JTypeMirror t = this.specialCache(symbol);
        if (t != null) {
            return (JClassType)t.getErasure();
        }
        return new ErasedClassType(this, symbol, (PSet<SymbolicValue.SymAnnot>)HashTreePSet.empty());
    }

    public JTypeVar newTypeVar(JTypeParameterSymbol symbol) {
        return new TypeVarImpl.RegularTypeVar(this, symbol, (PSet<SymbolicValue.SymAnnot>)HashTreePSet.empty());
    }

    public void logStats() {
        this.resolver.logStats();
    }

    private static final class NullType
    implements JTypeMirror {
        private final TypeSystem ts;

        NullType(TypeSystem ts) {
            this.ts = ts;
        }

        @Override
        public JTypeMirror withAnnotations(PSet<SymbolicValue.SymAnnot> newTypeAnnots) {
            return this;
        }

        @Override
        public PSet<SymbolicValue.SymAnnot> getTypeAnnotations() {
            return HashTreePSet.empty();
        }

        @Override
        public JTypeMirror subst(Function<? super SubstVar, ? extends @NonNull JTypeMirror> subst) {
            return this;
        }

        @Override
        public TypeSystem getTypeSystem() {
            return this.ts;
        }

        @Override
        public boolean isBottom() {
            return true;
        }

        @Override
        public @Nullable JClassSymbol getSymbol() {
            return null;
        }

        @Override
        public @Nullable JTypeMirror getAsSuper(@NonNull JClassSymbol symbol) {
            throw new UnsupportedOperationException("Null type cannot call asSuper, will return null always");
        }

        @Override
        public <T, P> T acceptVisitor(JTypeVisitor<T, P> visitor, P p) {
            return visitor.visitNullType(this, p);
        }

        @Override
        public String toString() {
            return "null";
        }
    }
}

