/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.java.ast.ASTAssignableExpr;
import net.sourceforge.pmd.lang.java.ast.ASTAssignmentExpression;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorCall;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.java.ast.ASTVariableAccess;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.symbols.JVariableSymbol;

public class SingletonClassReturningNewInstanceRule
extends AbstractJavaRulechainRule {
    public SingletonClassReturningNewInstanceRule() {
        super(ASTMethodDeclaration.class, new Class[0]);
    }

    public Object visit(ASTMethodDeclaration node, Object data) {
        if (node.isVoid() || !"getInstance".equals(node.getName())) {
            return data;
        }
        NodeStream.DescendantNodeStream rsl = node.descendants(ASTReturnStatement.class);
        if (this.returnsNewInstances((NodeStream<ASTReturnStatement>)rsl) || this.returnsLocalVariables((NodeStream<ASTReturnStatement>)rsl)) {
            this.asCtx(data).addViolation((Node)node);
        }
        return data;
    }

    private boolean returnsNewInstances(NodeStream<ASTReturnStatement> returns) {
        return returns.descendants(ASTConstructorCall.class).nonEmpty();
    }

    private boolean returnsLocalVariables(NodeStream<ASTReturnStatement> returns) {
        return returns.children(ASTVariableAccess.class).filter(JavaAstUtils::isReferenceToLocal).filterNot(this::isDoubleAssignment).nonEmpty();
    }

    private boolean isDoubleAssignment(ASTVariableAccess variableAccess) {
        return variableAccess.ancestors(ASTMethodDeclaration.class).descendants(ASTVariableAccess.class).filter(v -> v.getAccessType() == ASTAssignableExpr.AccessType.WRITE).filter(v -> JavaAstUtils.isReferenceToSameVar(variableAccess, v)).filter(v -> v.getNextSibling() instanceof ASTConstructorCall || v.getNextSibling() instanceof ASTAssignmentExpression).filter(v -> {
            boolean variant1 = false;
            boolean variant2 = false;
            if (v.getNextSibling() instanceof ASTConstructorCall) {
                if (v.getParent() instanceof ASTAssignmentExpression && ((JavaNode)v.getParent()).getParent() instanceof ASTAssignmentExpression) {
                    ASTAssignmentExpression leftAssignment = (ASTAssignmentExpression)((JavaNode)v.getParent()).getParent();
                    ASTAssignmentExpression rightAssignment = (ASTAssignmentExpression)v.getParent();
                    boolean fromConstructor = rightAssignment.getRightOperand() instanceof ASTConstructorCall;
                    boolean fromRightToLeft = leftAssignment.getRightOperand() == rightAssignment;
                    boolean leftIsField = false;
                    if (leftAssignment.getLeftOperand() instanceof ASTAssignableExpr.ASTNamedReferenceExpr) {
                        JVariableSymbol symbol = ((ASTAssignableExpr.ASTNamedReferenceExpr)leftAssignment.getLeftOperand()).getReferencedSym();
                        leftIsField = symbol != null && symbol.isField();
                    }
                    variant1 = fromConstructor && fromRightToLeft && leftIsField;
                }
            } else if (v.getNextSibling() instanceof ASTAssignmentExpression && v.getParent() instanceof ASTAssignmentExpression) {
                ASTAssignmentExpression leftAssignment = (ASTAssignmentExpression)v.getParent();
                ASTAssignmentExpression rightAssignment = (ASTAssignmentExpression)v.getNextSibling();
                boolean fromConstructor = rightAssignment.getRightOperand() instanceof ASTConstructorCall;
                boolean fromRightToLeft = leftAssignment.getRightOperand() == rightAssignment;
                boolean rightIsField = false;
                if (rightAssignment.getLeftOperand() instanceof ASTAssignableExpr.ASTNamedReferenceExpr) {
                    JVariableSymbol symbol = ((ASTAssignableExpr.ASTNamedReferenceExpr)rightAssignment.getLeftOperand()).getReferencedSym();
                    rightIsField = symbol != null && symbol.isField();
                }
                variant2 = fromConstructor && fromRightToLeft && rightIsField;
            }
            return variant1 || variant2;
        }).nonEmpty();
    }
}

