/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.errorprone.OverrideBothEqualsAndHashcodeRule;
import net.sourceforge.pmd.lang.java.types.JPrimitiveType;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.reporting.RuleContext;

public class OverrideBothEqualsAndHashCodeOnComparableRule
extends OverrideBothEqualsAndHashcodeRule {
    private static final String MESSAGE_PREFIX = "When implementing Comparable, ";
    private static final String MISSING_HASH_CODE = "When implementing Comparable, hashCode() should be overridden";
    private static final String MISSING_EQUALS = "When implementing Comparable, equals() should be overridden";
    private static final String MISSING_EQUALS_AND_HASH_CODE = "When implementing Comparable, both equals() and hashCode() should be overridden";

    @Override
    protected boolean skipType(ASTTypeDeclaration node) {
        return !TypeTestUtil.isA(Comparable.class, (TypeNode)node) || TypeTestUtil.isA(Enum.class, (TypeNode)node);
    }

    private static boolean isCompareToMethod(ASTMethodDeclaration method) {
        return "compareTo".equals(method.getName()) && method.getArity() == 1 && method.getResultTypeNode().getTypeMirror().isPrimitive(JPrimitiveType.PrimitiveTypeKind.INT) && !method.isStatic();
    }

    @Override
    protected void maybeReport(RuleContext ctx, ASTTypeDeclaration node, ASTMethodDeclaration hashCodeMethod, ASTMethodDeclaration equalsMethod) {
        ASTMethodDeclaration compareToMethod = (ASTMethodDeclaration)node.getDeclarations(ASTMethodDeclaration.class).first(OverrideBothEqualsAndHashCodeOnComparableRule::isCompareToMethod);
        if (compareToMethod == null) {
            return;
        }
        if (equalsMethod == null && hashCodeMethod == null) {
            ctx.addViolationWithMessage((Node)compareToMethod, MISSING_EQUALS_AND_HASH_CODE);
        } else if (equalsMethod == null) {
            ctx.addViolationWithMessage((Node)hashCodeMethod, MISSING_EQUALS);
        } else if (hashCodeMethod == null) {
            ctx.addViolationWithMessage((Node)equalsMethod, MISSING_HASH_CODE);
        }
    }
}

