/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTExecutableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;

public class AbstractClassWithoutAbstractMethodRule
extends AbstractJavaRulechainRule {
    public AbstractClassWithoutAbstractMethodRule() {
        super(ASTClassDeclaration.class, new Class[0]);
    }

    public Object visit(ASTClassDeclaration node, Object data) {
        if (node.isInterface() || !node.isAbstract() || this.doesExtend(node) || this.doesImplement(node)) {
            return data;
        }
        if (node.getDeclarations(ASTMethodDeclaration.class).none(ASTExecutableDeclaration::isAbstract)) {
            this.asCtx(data).addViolation((Node)node);
        }
        return data;
    }

    private boolean doesExtend(ASTClassDeclaration node) {
        return node.getSuperClassTypeNode() != null;
    }

    private boolean doesImplement(ASTClassDeclaration node) {
        return !node.getSuperInterfaceTypeNodes().isEmpty();
    }
}

