/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.reports;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import se.bjurr.violations.lib.ViolationsLogger;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.Utils;

public class ViolationsFinder {
    private final ViolationsParser violationsParser;

    public ViolationsFinder(ViolationsParser violationsParser) {
        this.violationsParser = violationsParser;
    }

    public Set<Violation> findViolations(ViolationsLogger violationsLogger, List<File> includedFiles) {
        TreeSet<Violation> violations = new TreeSet<Violation>();
        for (File file : includedFiles) {
            String content = null;
            try {
                content = Utils.toString(Files.newInputStream(file.toPath(), new OpenOption[0]));
                if (Logger.getLogger(Parser.class.getSimpleName()).isLoggable(Level.FINE)) {
                    violationsLogger.log(Level.FINE, "Using " + this.violationsParser.getClass().getName() + " to parse " + content);
                }
                violations.addAll(this.violationsParser.parseReportOutput(content, violationsLogger));
            }
            catch (Throwable e) {
                Object withContent = content == null ? "" : " content:\n\n" + content;
                violationsLogger.log(Level.SEVERE, "Error when parsing " + file.getAbsolutePath() + " as " + this.violationsParser.getClass().getName() + (String)withContent, e);
            }
        }
        return violations;
    }
}

