/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.stream.XMLStreamReader;
import se.bjurr.violations.lib.ViolationsLogger;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.ViolationParserUtils;

public class XUnitParser
implements ViolationsParser {
    @Override
    public Set<Violation> parseReportOutput(String string, ViolationsLogger violationsLogger) throws Exception {
        TreeSet<Violation> violations = new TreeSet<Violation>();
        try (ByteArrayInputStream input = new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8));){
            XMLStreamReader xmlr = ViolationParserUtils.createXmlReader(input);
            HashMap<String, String> specifics = new HashMap<String, String>();
            String testSuiteName = null;
            String file = null;
            String message = null;
            String type = null;
            String prevLocalName = "";
            String testcaseName = "";
            while (xmlr.hasNext()) {
                int eventType = xmlr.next();
                if (eventType == 1 && xmlr.getLocalName().equalsIgnoreCase("testsuite")) {
                    prevLocalName = xmlr.getLocalName();
                    Integer failures = ViolationParserUtils.findIntegerAttribute(xmlr, "failures").orElse(-1);
                    Integer errors = ViolationParserUtils.findIntegerAttribute(xmlr, "errors").orElse(-1);
                    Integer tests = ViolationParserUtils.findIntegerAttribute(xmlr, "tests").orElse(-1);
                    testSuiteName = ViolationParserUtils.findAttribute(xmlr, "name").orElse("");
                    file = ViolationParserUtils.findAttribute(xmlr, "file").orElse("");
                    specifics.put("tests", tests.toString());
                    specifics.put("errors", errors.toString());
                    specifics.put("failures", failures.toString());
                }
                if (eventType == 1 && xmlr.getLocalName().equalsIgnoreCase("testcase")) {
                    prevLocalName = xmlr.getLocalName();
                    testcaseName = ViolationParserUtils.findAttribute(xmlr, "name").orElse("");
                    specifics.put("testcaseName", testcaseName);
                }
                if (eventType == 1 && xmlr.getLocalName().equalsIgnoreCase("failure")) {
                    prevLocalName = xmlr.getLocalName();
                    message = ViolationParserUtils.findAttribute(xmlr, "message").orElse("");
                    type = ViolationParserUtils.findAttribute(xmlr, "type").orElse("");
                }
                if (!prevLocalName.equalsIgnoreCase("failure") || eventType != 4) continue;
                prevLocalName = "";
                String content = xmlr.getText();
                String violationFile = testSuiteName;
                if (!file.isEmpty()) {
                    violationFile = file;
                }
                violations.add(Violation.violationBuilder().setFile(violationFile).setMessage(message + "\n\n" + content).setParser(Parser.XUNIT).setCategory(type).setSeverity(SEVERITY.ERROR).setSpecifics(specifics).setStartLine(0).setRule(testcaseName).build());
            }
        }
        return violations;
    }
}

