/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import se.bjurr.violations.lib.ViolationsLogger;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.model.generated.coverity.CheckerProperty;
import se.bjurr.violations.lib.model.generated.coverity.CoveritySchema;
import se.bjurr.violations.lib.model.generated.coverity.Issue;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.Utils;
import se.bjurr.violations.violationslib.com.google.gson.Gson;

public class CoverityParser
implements ViolationsParser {
    @Override
    public Set<Violation> parseReportOutput(String string, ViolationsLogger violationsLogger) throws Exception {
        CoveritySchema coverityReport = new Gson().fromJson(string, CoveritySchema.class);
        TreeSet<Violation> violations = new TreeSet<Violation>();
        List<Issue> issues = coverityReport.getIssues();
        if (issues == null) {
            return violations;
        }
        for (Issue issue : issues) {
            violations.add(Violation.violationBuilder().setFile(issue.getMainEventFilePathname()).setMessage(this.getMessage(issue.getCheckerProperties())).setParser(Parser.COVERITY).setCategory(issue.getCheckerProperties().getCategory()).setRule(issue.getType() + "/" + issue.getSubtype()).setSeverity(this.toSeverity(issue.getCheckerProperties().getImpact())).setStartLine(issue.getMainEventLineNumber()).build());
        }
        return violations;
    }

    private String getMessage(CheckerProperty checkerProperty) {
        boolean hasLocalEffect;
        boolean hasLongDescription = !Utils.isNullOrEmpty(checkerProperty.getSubcategoryLongDescription());
        boolean bl = hasLocalEffect = !Utils.isNullOrEmpty(checkerProperty.getSubcategoryLocalEffect());
        if (hasLongDescription && hasLocalEffect) {
            if (checkerProperty.getSubcategoryLongDescription().contains(checkerProperty.getSubcategoryLocalEffect())) {
                return checkerProperty.getSubcategoryLongDescription();
            }
            return checkerProperty.getSubcategoryLongDescription() + ".\n" + checkerProperty.getSubcategoryLocalEffect();
        }
        if (hasLongDescription) {
            return checkerProperty.getSubcategoryLongDescription();
        }
        if (hasLocalEffect) {
            return checkerProperty.getSubcategoryLocalEffect();
        }
        return checkerProperty.getImpactDescription();
    }

    private SEVERITY toSeverity(String from) {
        if (from.equalsIgnoreCase("Medium")) {
            return SEVERITY.WARN;
        }
        return SEVERITY.ERROR;
    }
}

