/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.Utils;

public class Violation
implements Serializable,
Comparable<Violation> {
    private static final long serialVersionUID = -6052921679385466168L;
    public static final String NO_FILE = "-";
    public static final Integer NO_LINE = 0;
    private Integer column;
    private final Integer endLine;
    private final Integer endColumn;
    private final String file;
    private final String message;
    private final Parser parser;
    private String reporter;
    private final String rule;
    private final String category;
    private final String group;
    private final SEVERITY severity;
    private final String source;
    private final Map<String, String> specifics;
    private final Integer startLine;

    public static ViolationBuilder violationBuilder() {
        return new ViolationBuilder();
    }

    public Violation() {
        this.startLine = null;
        this.endLine = null;
        this.endColumn = null;
        this.severity = null;
        this.message = null;
        this.file = null;
        this.source = null;
        this.rule = null;
        this.category = null;
        this.reporter = null;
        this.specifics = null;
        this.parser = null;
        this.group = null;
    }

    public Violation(ViolationBuilder vb) {
        this.parser = Utils.checkNotNull(vb.parser, "reporter");
        this.reporter = vb.reporter != null && !vb.reporter.trim().isEmpty() ? vb.reporter : this.parser.name();
        this.startLine = Utils.checkNotNull(vb.startLine, "startline");
        this.endLine = Utils.firstNonNull(vb.endLine, vb.startLine);
        this.column = vb.column;
        this.endColumn = vb.endColumn;
        this.severity = Utils.checkNotNull(vb.severity, "severity");
        this.message = Utils.checkNotNull(Utils.emptyToNull(vb.message), "message");
        this.file = Violation.frontSlashes(Utils.checkNotNull(Utils.emptyToNull(vb.file), "file"));
        this.source = Utils.nullToEmpty(vb.source);
        this.rule = Utils.nullToEmpty(vb.rule);
        this.category = Utils.nullToEmpty(vb.category);
        this.group = Utils.nullToEmpty(vb.group);
        this.specifics = vb.specifics;
    }

    public static String frontSlashes(String in) {
        return in.replace("\\\\", "\\").replaceAll("\\\\", "/");
    }

    public Violation(Violation v) {
        this.parser = v.parser;
        this.reporter = v.reporter;
        this.startLine = v.startLine;
        this.endLine = v.endLine;
        this.endColumn = v.endColumn;
        this.column = v.column;
        this.severity = v.severity;
        this.message = v.message;
        this.file = v.file;
        this.source = v.source;
        this.rule = v.rule;
        this.category = v.category;
        this.group = v.group;
        this.specifics = v.specifics;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Violation other = (Violation)obj;
        if (this.category == null ? other.category != null : !this.category.equals(other.category)) {
            return false;
        }
        if (this.column == null ? other.column != null : !this.column.equals(other.column)) {
            return false;
        }
        if (this.endLine == null ? other.endLine != null : !this.endLine.equals(other.endLine)) {
            return false;
        }
        if (this.endColumn == null ? other.endColumn != null : !this.endColumn.equals(other.endColumn)) {
            return false;
        }
        if (this.file == null ? other.file != null : !this.file.equals(other.file)) {
            return false;
        }
        if (this.group == null ? other.group != null : !this.group.equals(other.group)) {
            return false;
        }
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        if (this.parser != other.parser) {
            return false;
        }
        if (this.reporter == null ? other.reporter != null : !this.reporter.equals(other.reporter)) {
            return false;
        }
        if (this.rule == null ? other.rule != null : !this.rule.equals(other.rule)) {
            return false;
        }
        if (this.severity != other.severity) {
            return false;
        }
        if (this.source == null ? other.source != null : !this.source.equals(other.source)) {
            return false;
        }
        if (this.specifics == null ? other.specifics != null : !this.specifics.equals(other.specifics)) {
            return false;
        }
        return !(this.startLine == null ? other.startLine != null : !this.startLine.equals(other.startLine));
    }

    public Integer getColumn() {
        return Utils.firstNonNull(this.column, -1);
    }

    public Integer getEndLine() {
        return this.endLine;
    }

    public Integer getEndColumn() {
        return this.endColumn;
    }

    public String getFile() {
        return this.file;
    }

    public String getMessage() {
        return this.message;
    }

    public Parser getParser() {
        return this.parser;
    }

    public void setReporter(String reporter) {
        this.reporter = Utils.checkNotNull(reporter, "reporter");
    }

    public String getReporter() {
        return this.reporter;
    }

    public String getRule() {
        return this.rule;
    }

    public String getCategory() {
        return this.category;
    }

    public SEVERITY getSeverity() {
        return this.severity;
    }

    public String getSource() {
        return this.source;
    }

    public Map<String, String> getSpecifics() {
        return this.specifics;
    }

    public Integer getStartLine() {
        return this.startLine;
    }

    public String getGroup() {
        return this.group;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.category == null ? 0 : this.category.hashCode());
        result = 31 * result + (this.column == null ? 0 : this.column.hashCode());
        result = 31 * result + (this.endLine == null ? 0 : this.endLine.hashCode());
        result = 31 * result + (this.endColumn == null ? 0 : this.endColumn.hashCode());
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        result = 31 * result + (this.group == null ? 0 : this.group.hashCode());
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (this.parser == null ? 0 : this.parser.hashCode());
        result = 31 * result + (this.reporter == null ? 0 : this.reporter.hashCode());
        result = 31 * result + (this.rule == null ? 0 : this.rule.hashCode());
        result = 31 * result + (this.severity == null ? 0 : this.severity.hashCode());
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        result = 31 * result + (this.specifics == null ? 0 : this.specifics.hashCode());
        result = 31 * result + (this.startLine == null ? 0 : this.startLine.hashCode());
        return result;
    }

    public String toString() {
        return "Violation [column=" + this.column + ", endLine=" + this.endLine + ", endColumn=" + this.endColumn + ", file=" + this.file + ", message=" + this.message + ", parser=" + String.valueOf((Object)this.parser) + ", reporter=" + this.reporter + ", rule=" + this.rule + ", category=" + this.category + ", severity=" + String.valueOf((Object)this.severity) + ", source=" + this.source + ", specifics=" + String.valueOf(this.specifics) + ", startLine=" + this.startLine + ", group=" + this.group + "]";
    }

    @Override
    public int compareTo(Violation o) {
        return this.comparingString(this).compareTo(this.comparingString(o));
    }

    private String comparingString(Violation o) {
        StringBuilder compare = new StringBuilder();
        compare.append(o.file);
        compare.append("_");
        compare.append(Integer.MAX_VALUE - o.getStartLine());
        compare.append("_");
        compare.append((Object)o.getParser());
        compare.append("_");
        compare.append(o.getMessage());
        compare.append("_");
        compare.append(o.getReporter());
        compare.append("_");
        compare.append(o.getEndLine());
        compare.append("_");
        compare.append(o.getEndColumn());
        compare.append("_");
        compare.append(o.getColumn());
        compare.append("_");
        compare.append((Object)o.getSeverity());
        compare.append("_");
        compare.append(o.getSource());
        compare.append("_");
        compare.append(o.getRule());
        compare.append("_");
        compare.append(o.getCategory());
        compare.append("_");
        compare.append(o.getGroup());
        o.getSpecifics().forEach((k, v) -> compare.append("_").append((String)k).append((String)v));
        return compare.toString();
    }

    public static class ViolationBuilder {
        private Integer column;
        private Integer endLine;
        private Integer endColumn;
        private String file;
        private String message;
        private Parser parser;
        private String reporter;
        private String rule;
        private String category;
        private SEVERITY severity;
        private String source;
        private Map<String, String> specifics = new HashMap<String, String>();
        private Integer startLine;
        private String group;

        private ViolationBuilder() {
        }

        public Violation build() {
            return new Violation(this);
        }

        public ViolationBuilder setColumn(Integer column) {
            this.column = column;
            return this;
        }

        public ViolationBuilder setEndLine(Integer endLine) {
            this.endLine = endLine;
            return this;
        }

        public ViolationBuilder setEndColumn(Integer endColumn) {
            this.endColumn = endColumn;
            return this;
        }

        public ViolationBuilder setFile(String file) {
            this.file = file;
            return this;
        }

        public ViolationBuilder setMessage(String message) {
            this.message = message;
            return this;
        }

        public ViolationBuilder setParser(Parser parser) {
            this.parser = parser;
            return this;
        }

        public ViolationBuilder setReporter(String reporter) {
            this.reporter = reporter;
            return this;
        }

        public ViolationBuilder setRule(String rule) {
            this.rule = rule;
            return this;
        }

        public ViolationBuilder setCategory(String category) {
            this.category = category;
            return this;
        }

        public ViolationBuilder setSeverity(SEVERITY severity) {
            this.severity = severity;
            return this;
        }

        public ViolationBuilder setSource(String source) {
            this.source = source;
            return this;
        }

        public ViolationBuilder setSpecific(String specificsKey, Integer specificsValue) {
            this.specifics.put(specificsKey, Integer.toString(specificsValue));
            return this;
        }

        public ViolationBuilder setSpecific(String specificsKey, String specificsValue) {
            this.specifics.put(specificsKey, specificsValue);
            return this;
        }

        public ViolationBuilder setSpecifics(Map<String, String> specifics) {
            this.specifics = specifics;
            return this;
        }

        public ViolationBuilder setStartLine(Integer startLine) {
            this.startLine = startLine;
            return this;
        }

        public ViolationBuilder setGroup(String group) {
            this.group = group;
            return this;
        }
    }
}

