/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Categories;
import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.LookaheadParser;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.LookaheadStream;
import java.util.Optional;
import java.util.regex.Matcher;

public class SphinxBuildLinkCheckParser
extends LookaheadParser {
    private static final long serialVersionUID = 1L;
    private static final String SPHINX_BUILD_LINK_CHECK_WARNING_PATTERN = "^(.*):(\\d+|None|): \\[(.*?)\\] (.*)";

    public SphinxBuildLinkCheckParser() {
        super(SPHINX_BUILD_LINK_CHECK_WARNING_PATTERN);
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, LookaheadStream lookahead, IssueBuilder builder) {
        String message = matcher.group(4);
        String category = Categories.guessCategoryIfEmpty(matcher.group(3), message);
        return builder.setFileName(matcher.group(1)).setLineStart(matcher.group(2)).setCategory(category).setMessage(message).setSeverity(this.mapPriority(category)).buildOptional();
    }

    private Severity mapPriority(String priority) {
        if (SphinxBuildLinkCheckParser.equalsIgnoreCase(priority, "broken")) {
            return Severity.WARNING_HIGH;
        }
        return Severity.WARNING_NORMAL;
    }
}

