/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.ParsingCanceledException;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.analysis.util.IntegerParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PvsStudioParser
extends IssueParser {
    private static final long serialVersionUID = -7777775729854832128L;
    private static final String SEVERITY_HIGH = "1";
    private static final String SEVERITY_NORMAL = "2";
    private static final String SEVERITY_LOW = "3";

    private static Severity getSeverity(String level) {
        if (SEVERITY_HIGH.equals(level)) {
            return Severity.WARNING_HIGH;
        }
        if (SEVERITY_NORMAL.equals(level)) {
            return Severity.WARNING_NORMAL;
        }
        if (SEVERITY_LOW.equals(level)) {
            return Severity.WARNING_LOW;
        }
        return Severity.ERROR;
    }

    @Override
    public Report parseReport(ReaderFactory readerFactory) throws ParsingException, ParsingCanceledException {
        try (IssueBuilder issueBuilder = new IssueBuilder();){
            Report report = new Report();
            PlogMessagesReader parser = new PlogMessagesReader();
            for (PlogMessagesReader.PlogMessage plogMessage : parser.getMessagesFromReport(readerFactory)) {
                issueBuilder.setFileName(plogMessage.getFilePath());
                issueBuilder.setSeverity(PvsStudioParser.getSeverity(plogMessage.getLevel()));
                issueBuilder.setMessage(plogMessage.toString());
                issueBuilder.setCategory(plogMessage.getType());
                issueBuilder.setType(AnalyzerType.fromErrorCode(plogMessage.getType()).getMessage());
                issueBuilder.setLineStart(plogMessage.getLine());
                report.add(issueBuilder.buildAndClean());
            }
            Report report2 = report;
            return report2;
        }
    }

    static class PlogMessagesReader {
        private int failWarningsCount;
        private int falseAlarmCount;

        PlogMessagesReader() {
        }

        List<PlogMessage> getMessagesFromReport(ReaderFactory readerFactory) {
            Document plogDoc = readerFactory.readDocument();
            plogDoc.getDocumentElement().normalize();
            NodeList nList = plogDoc.getElementsByTagName("PVS-Studio_Analysis_Log");
            ArrayList<PlogMessage> plogMessages = new ArrayList<PlogMessage>();
            for (int nodeCount = 0; nodeCount < nList.getLength(); ++nodeCount) {
                Node nNode = nList.item(nodeCount);
                if (nNode.getNodeType() != 1) continue;
                this.processNode(plogMessages, nNode);
            }
            if (plogMessages.size() + this.falseAlarmCount == 0 && this.failWarningsCount > 0) {
                Logger.getLogger(PvsStudioParser.class.getName()).log(Level.SEVERE, "No messages were parsed!");
            }
            return plogMessages;
        }

        private void processNode(List<PlogMessage> plogMessages, Node node) {
            Element eElement = (Element)node;
            NodeList nodeFalseAlarm = eElement.getElementsByTagName("FalseAlarm");
            if (this.skipMessage(nodeFalseAlarm)) {
                ++this.falseAlarmCount;
                return;
            }
            NodeList nodeFile = eElement.getElementsByTagName("File");
            PlogMessage msg = new PlogMessage();
            if (this.nodeNotNull(nodeFile)) {
                msg.file = nodeFile.item(0).getTextContent().trim();
            }
            if (msg.file.isEmpty()) {
                ++this.failWarningsCount;
                return;
            }
            NodeList nodeErrorCode = eElement.getElementsByTagName("ErrorCode");
            if (this.nodeNotNull(nodeErrorCode)) {
                msg.errorCode = nodeErrorCode.item(0).getTextContent().trim();
            }
            if (!this.errorCodeIsValid(msg.errorCode)) {
                ++this.failWarningsCount;
                return;
            }
            msg.message = "<a target=\"_blank\" href=\"https://pvs-studio.com/en/docs/warnings/" + msg.errorCode.toLowerCase(Locale.ENGLISH) + "/\">" + msg.errorCode + "</a> " + eElement.getElementsByTagName("Message").item(0).getTextContent();
            msg.level = eElement.getElementsByTagName("Level").item(0).getTextContent();
            msg.lineNumber = IntegerParser.parseInt(eElement.getElementsByTagName("Line").item(0).getTextContent());
            if (msg.lineNumber <= 0) {
                ++this.failWarningsCount;
                return;
            }
            plogMessages.add(msg);
        }

        private boolean skipMessage(NodeList elements) {
            return elements != null && elements.item(0) != null && IssueParser.equalsIgnoreCase(elements.item(0).getTextContent(), "true");
        }

        private boolean nodeNotNull(NodeList elements) {
            return elements != null && elements.item(0) != null && elements.item(0).getTextContent() != null;
        }

        private boolean errorCodeIsValid(String errorCode) {
            return !errorCode.isEmpty() && errorCode.charAt(0) == 'V';
        }

        static class PlogMessage {
            private String file = "";
            private int lineNumber;
            private String errorCode = "";
            private String message = "";
            private String level = "";

            PlogMessage() {
            }

            public String getHash() {
                return this.errorCode + this.message + this.file + this.lineNumber;
            }

            public String toString() {
                return this.message;
            }

            String getFilePath() {
                return this.file;
            }

            public int getLine() {
                return this.lineNumber;
            }

            public String getType() {
                return this.errorCode;
            }

            public String getLevel() {
                return this.level;
            }
        }
    }

    static final class AnalyzerType {
        private static final int VIVA64_CCPP_ERRORCODE_BEGIN = 100;
        private static final int VIVA64_CCPP_ERRORCODE_END = 499;
        private static final int GENERAL_CCPP_LOW_ERRORCODE_BEGIN = 500;
        private static final int GENERAL_CCPP_LOW_ERRORCODE_END = 799;
        private static final int OPTIMIZATION_CCPP_ERRORCODE_BEGIN = 800;
        private static final int OPTIMIZATION_CCPP_ERRORCODE_END = 999;
        private static final int GENERAL_CCPP_HIGH_ERRORCODE_BEGIN = 1000;
        private static final int GENERAL_CCPP_HIGH_ERRORCODE_END = 1999;
        private static final int CUSTOMERSPECIFIC_CCPP_ERRORCODE_BEGIN = 2000;
        private static final int CUSTOMERSPECIFIC_CCPP_ERRORCODE_END = 2499;
        private static final int MISRA_CCPP_ERRORCODE_BEGIN = 2500;
        private static final int MISRA_CCPP_ERRORCODE_END = 2999;
        private static final int GENERAL_CS_ERRORCODE_BEGIN = 3000;
        private static final int GENERAL_CS_ERRORCODE_END = 3499;
        private static final int GENERAL_JAVA_ERRORCODE_BEGIN = 6000;
        private static final int GENERAL_JAVA_ERRORCODE_END = 6999;
        static final String VIVA_64_MESSAGE = "64-bit";
        static final String GENERAL_MESSAGE = "General Analysis";
        static final String OPTIMIZATION_MESSAGE = "Micro-optimization";
        static final String CUSTOMER_SPECIFIC_MESSAGE = "Specific Requests";
        static final String MISRA_MESSAGE = "MISRA";
        static final String UNKNOWN_MESSAGE = "Unknown";
        private static final AnalysisType[] ANALYSIS_TYPES = new AnalysisType[]{new Viva64(), new General(), new Optimization(), new CustomerSpecific(), new Misra()};

        private AnalyzerType() {
        }

        static AnalysisType fromErrorCode(String errorCodeStr) {
            if (IssueParser.equalsIgnoreCase(errorCodeStr, "External")) {
                return new General();
            }
            int errorCode = IntegerParser.parseInt(errorCodeStr.substring(1));
            return Arrays.stream(ANALYSIS_TYPES).map(type -> type.create(errorCode)).flatMap(o -> o.map(Stream::of).orElseGet(Stream::empty)).findFirst().orElse(new Unknown());
        }

        private static final class General
        implements AnalysisType {
            private General() {
            }

            @Override
            public String getMessage() {
                return AnalyzerType.GENERAL_MESSAGE;
            }

            @Override
            public Optional<AnalysisType> create(int errorCode) {
                if (errorCode >= 500 && errorCode <= 799) {
                    return Optional.of(new General());
                }
                if (errorCode >= 1000 && errorCode <= 1999) {
                    return Optional.of(new General());
                }
                if (errorCode >= 3000 && errorCode <= 3499) {
                    return Optional.of(new General());
                }
                if (errorCode >= 6000 && errorCode <= 6999) {
                    return Optional.of(new General());
                }
                return Optional.empty();
            }
        }

        static interface AnalysisType {
            public String getMessage();

            public Optional<AnalysisType> create(int var1);
        }

        private static final class Unknown
        implements AnalysisType {
            private Unknown() {
            }

            @Override
            public String getMessage() {
                return AnalyzerType.UNKNOWN_MESSAGE;
            }

            @Override
            public Optional<AnalysisType> create(int errorCode) {
                return Optional.empty();
            }
        }

        static final class Viva64
        implements AnalysisType {
            Viva64() {
            }

            @Override
            public String getMessage() {
                return AnalyzerType.VIVA_64_MESSAGE;
            }

            @Override
            public Optional<AnalysisType> create(int errorCode) {
                if (errorCode >= 100 && errorCode <= 499) {
                    return Optional.of(new Viva64());
                }
                return Optional.empty();
            }
        }

        private static final class Optimization
        implements AnalysisType {
            private Optimization() {
            }

            @Override
            public String getMessage() {
                return AnalyzerType.OPTIMIZATION_MESSAGE;
            }

            @Override
            public Optional<AnalysisType> create(int errorCode) {
                if (errorCode >= 800 && errorCode <= 999) {
                    return Optional.of(new Optimization());
                }
                return Optional.empty();
            }
        }

        private static final class CustomerSpecific
        implements AnalysisType {
            private CustomerSpecific() {
            }

            @Override
            public String getMessage() {
                return AnalyzerType.CUSTOMER_SPECIFIC_MESSAGE;
            }

            @Override
            public Optional<AnalysisType> create(int errorCode) {
                if (errorCode >= 2000 && errorCode <= 2499) {
                    return Optional.of(new CustomerSpecific());
                }
                return Optional.empty();
            }
        }

        private static final class Misra
        implements AnalysisType {
            private Misra() {
            }

            @Override
            public String getMessage() {
                return AnalyzerType.MISRA_MESSAGE;
            }

            @Override
            public Optional<AnalysisType> create(int errorCode) {
                if (errorCode >= 2500 && errorCode <= 2999) {
                    return Optional.of(new Misra());
                }
                return Optional.empty();
            }
        }
    }
}

