/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.SecureDigester;
import edu.hm.hafner.analysis.Severity;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.Strings;
import org.xml.sax.SAXException;

public class CcmParser
extends IssueParser {
    private static final long serialVersionUID = -5172155190810975806L;

    @Override
    public Report parseReport(ReaderFactory readerFactory) throws ParsingException {
        Ccm report = this.parseCcmXmlFile(readerFactory);
        return this.convert(report);
    }

    private Ccm parseCcmXmlFile(ReaderFactory ccmXmlFile) {
        Ccm ccm;
        block9: {
            SecureDigester digester = new SecureDigester(CcmParser.class);
            String rootXPath = "ccm";
            digester.addObjectCreate(rootXPath, Ccm.class);
            digester.addSetProperties(rootXPath);
            String fileMetric = "ccm/metric";
            digester.addObjectCreate(fileMetric, Metric.class);
            digester.addSetProperties(fileMetric);
            digester.addBeanPropertySetter("ccm/metric/complexity");
            digester.addBeanPropertySetter("ccm/metric/unit");
            digester.addBeanPropertySetter("ccm/metric/classification");
            digester.addBeanPropertySetter("ccm/metric/file");
            digester.addBeanPropertySetter("ccm/metric/startLineNumber");
            digester.addBeanPropertySetter("ccm/metric/endLineNumber");
            digester.addSetNext(fileMetric, "addMetric", Metric.class.getName());
            Reader reader = ccmXmlFile.create();
            try {
                Ccm report = (Ccm)digester.parse(reader);
                if (report == null) {
                    throw new ParsingException(ccmXmlFile, "Input stream is not a CCM file.", new Object[0]);
                }
                ccm = report;
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | SAXException exception) {
                    throw new ParsingException(exception, ccmXmlFile);
                }
            }
            reader.close();
        }
        return ccm;
    }

    private Report convert(Ccm collection) {
        try (IssueBuilder issueBuilder = new IssueBuilder();){
            Report report = new Report();
            for (Metric metric : collection.getMetrics()) {
                Severity priority = this.calculateMetricPriority(metric);
                String complexity = String.format(Locale.ENGLISH, "%s has a complexity of %d", metric.getUnit(), metric.getComplexity());
                issueBuilder.setSeverity(priority).setMessage(complexity).setCategory(metric.getClassification()).setLineStart(metric.getStartLineNumber()).setLineEnd(metric.getEndLineNumber()).setFileName(metric.getFile());
                report.add(issueBuilder.buildAndClean());
            }
            Report report2 = report;
            return report2;
        }
    }

    private Severity calculateMetricPriority(Metric metric) {
        if (this.isMetricHighPriority(metric)) {
            return Severity.WARNING_HIGH;
        }
        if (this.isMetricModeratePriority(metric)) {
            return Severity.WARNING_NORMAL;
        }
        return Severity.WARNING_LOW;
    }

    private boolean isMetricHighPriority(Metric metric) {
        String metricClassification = metric.getClassification();
        if (Strings.CS.contains((CharSequence)metricClassification, (CharSequence)"high")) {
            return true;
        }
        return "C".equals(metricClassification) || "D".equals(metricClassification) || "E".equals(metricClassification) || "F".equals(metricClassification);
    }

    private boolean isMetricModeratePriority(Metric metric) {
        String metricClassification = metric.getClassification();
        return Strings.CS.contains((CharSequence)metricClassification, (CharSequence)"moderate") || "B".equals(metricClassification);
    }

    @SuppressFBWarnings(value={"EI"})
    public static class Ccm {
        private List<Metric> metrics = new ArrayList<Metric>();

        public List<Metric> getMetrics() {
            return this.metrics;
        }

        public void setMetrics(List<Metric> metrics) {
            this.metrics = metrics;
        }

        public void addMetric(Metric metric) {
            this.metrics.add(metric);
        }
    }

    public static class Metric {
        private int complexity;
        @CheckForNull
        private String unit;
        @CheckForNull
        private String classification;
        @CheckForNull
        private String file;
        private int startLineNumber;
        private int endLineNumber;

        public int getComplexity() {
            return this.complexity;
        }

        public void setComplexity(int complexity) {
            this.complexity = complexity;
        }

        @CheckForNull
        public String getUnit() {
            return this.unit;
        }

        public void setUnit(String unit) {
            this.unit = unit;
        }

        @CheckForNull
        public String getClassification() {
            return this.classification;
        }

        public void setClassification(String classification) {
            this.classification = classification;
        }

        @CheckForNull
        public String getFile() {
            return this.file;
        }

        public void setFile(String file) {
            this.file = file;
        }

        public int getStartLineNumber() {
            return this.startLineNumber;
        }

        public void setStartLineNumber(int startLineNumber) {
            this.startLineNumber = startLineNumber;
        }

        public int getEndLineNumber() {
            return this.endLineNumber;
        }

        public void setEndLineNumber(int endLineNumber) {
            this.endLineNumber = endLineNumber;
        }
    }
}

