/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.document;

import java.util.Comparator;
import java.util.Objects;
import net.sourceforge.pmd.lang.document.TextPos2d;

public final class TextRange2d
implements Comparable<TextRange2d> {
    private static final Comparator<TextRange2d> COMPARATOR = Comparator.comparingInt(TextRange2d::getStartLine).thenComparingInt(TextRange2d::getStartColumn).thenComparingInt(TextRange2d::getEndLine).thenComparingInt(TextRange2d::getEndColumn);
    private final int startLine;
    private final int startCol;
    private final int endLine;
    private final int endCol;

    public TextRange2d(int startLine, int startCol, int endLine, int endCol) {
        this.startLine = startLine;
        this.startCol = startCol;
        this.endLine = endLine;
        this.endCol = endCol;
        assert (startCol >= 1 && startLine >= 1 && endLine >= 1 && endCol >= 1) : "Not a valid range " + this.toDisplayStringWithColon();
    }

    public TextPos2d getStartPos() {
        return TextPos2d.pos2d(this.startLine, this.startCol);
    }

    public TextPos2d getEndPos() {
        return TextPos2d.pos2d(this.endLine, this.endCol);
    }

    public String toDisplayStringWithColon() {
        return this.getStartPos().toDisplayStringWithColon() + "-" + this.getEndPos().toDisplayStringWithColon();
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int getStartColumn() {
        return this.startCol;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getEndColumn() {
        return this.endCol;
    }

    public static TextRange2d range2d(TextPos2d start, TextPos2d end) {
        return new TextRange2d(start.getLine(), start.getColumn(), end.getLine(), end.getColumn());
    }

    public static TextRange2d range2d(int bline, int bcol, int eline, int ecol) {
        return new TextRange2d(bline, bcol, eline, ecol);
    }

    public static TextRange2d fullLine(int line, int lineLength) {
        return new TextRange2d(line, 1, line, 1 + lineLength);
    }

    @Override
    public int compareTo(TextRange2d o) {
        return COMPARATOR.compare(this, o);
    }

    public boolean contains(TextRange2d range) {
        return this.getStartPos().compareTo(range.getStartPos()) <= 0 && this.getEndPos().compareTo(range.getEndPos()) >= 0;
    }

    public boolean contains(TextPos2d pos) {
        return this.getStartPos().compareTo(pos) <= 0 && this.getEndPos().compareTo(pos) >= 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextRange2d that = (TextRange2d)o;
        return this.getStartPos().equals(that.getStartPos()) && this.getEndPos().equals(that.getEndPos());
    }

    public int hashCode() {
        return Objects.hash(this.getStartPos(), this.getEndPos());
    }

    public String toString() {
        return "!debug only! [" + this.getStartPos().toTupleString() + " - " + this.getEndPos().toTupleString() + ']';
    }
}

