/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import net.sourceforge.pmd.internal.util.IOUtil;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageProcessor;
import net.sourceforge.pmd.lang.LanguagePropertyBundle;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.PmdCapableLanguage;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertySource;
import net.sourceforge.pmd.util.CollectionUtil;
import net.sourceforge.pmd.util.StringUtil;
import net.sourceforge.pmd.util.log.PmdReporter;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LanguageProcessorRegistry
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(LanguageProcessorRegistry.class);
    private final Map<PmdCapableLanguage, LanguageProcessor> processors;
    private final LanguageRegistry languages;

    private LanguageProcessorRegistry(Set<LanguageProcessor> processors) {
        this.processors = Collections.unmodifiableMap(CollectionUtil.associateBy(processors, LanguageProcessor::getLanguage));
        this.languages = new LanguageRegistry(this.processors.keySet());
        for (Language language : this.languages.getLanguages()) {
            for (String id : language.getDependencies()) {
                if (this.languages.getLanguageById(id) != null) continue;
                throw new IllegalStateException("Language " + language.getId() + " has unsatisfied dependencies: " + id + " is not loaded");
            }
        }
    }

    public LanguageRegistry getLanguages() {
        return this.languages;
    }

    public @NonNull LanguageProcessor getProcessor(Language l) {
        LanguageProcessor obj = this.processors.get(l);
        if (obj == null) {
            throw new IllegalArgumentException("Language " + l.getId() + " is not initialized in " + this);
        }
        return obj;
    }

    @Override
    public void close() throws LanguageTerminationException {
        Exception e = IOUtil.closeAll(this.processors.values());
        if (e != null) {
            throw new LanguageTerminationException(e);
        }
    }

    public static LanguageProcessorRegistry singleton(@NonNull LanguageProcessor lp) {
        return new LanguageProcessorRegistry(Collections.singleton(lp));
    }

    public static LanguageProcessorRegistry create(LanguageRegistry registry, Map<Language, LanguagePropertyBundle> languageProperties, PmdReporter messageReporter) {
        return LanguageProcessorRegistry.create(registry, languageProperties, messageReporter, System.getenv());
    }

    static LanguageProcessorRegistry create(LanguageRegistry registry, Map<Language, LanguagePropertyBundle> languageProperties, PmdReporter messageReporter, Map<String, String> env) {
        HashSet<LanguageProcessor> processors = new HashSet<LanguageProcessor>();
        for (Language language : registry) {
            if (!(language instanceof PmdCapableLanguage)) {
                LOG.trace("Not instantiating language {} because it does not support PMD", (Object)language);
                continue;
            }
            LanguagePropertyBundle properties = languageProperties.getOrDefault(language, language.newPropertyBundle());
            if (!properties.getLanguage().equals(language)) {
                throw new IllegalArgumentException("Mismatched language");
            }
            try {
                LanguageProcessorRegistry.readLanguagePropertiesFromEnv(properties, messageReporter, env);
                processors.add(((PmdCapableLanguage)language).createProcessor(properties));
            }
            catch (IllegalArgumentException e) {
                messageReporter.error(e);
            }
        }
        return new LanguageProcessorRegistry(processors);
    }

    public static Map<Language, LanguagePropertyBundle> derivePropertiesFromStrings(Map<Language, Properties> stringProperties, PmdReporter reporter) {
        HashMap<Language, LanguagePropertyBundle> typedProperties = new HashMap<Language, LanguagePropertyBundle>();
        stringProperties.forEach((l, props) -> {
            LanguagePropertyBundle properties = l.newPropertyBundle();
            LanguageProcessorRegistry.setLanguageProperties(stringProperties, reporter, l, properties);
        });
        return typedProperties;
    }

    private static void setLanguageProperties(Map<Language, Properties> languageProperties, PmdReporter messageReporter, Language language, LanguagePropertyBundle properties) {
        Properties props = languageProperties.get(language);
        if (props != null) {
            props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                PropertyDescriptor<?> descriptor = properties.getPropertyDescriptor(k.toString());
                if (descriptor == null) {
                    messageReporter.error("No property {0} for language {1}", k, language.getId());
                    return;
                }
                LanguageProcessorRegistry.trySetPropertyCapture(properties, descriptor, v.toString(), messageReporter);
            }));
        }
    }

    private static <T> void trySetPropertyCapture(PropertySource source, PropertyDescriptor<T> propertyDescriptor, String propertyValue, PmdReporter reporter) {
        try {
            T value = propertyDescriptor.serializer().fromString(propertyValue);
            source.setProperty(propertyDescriptor, value);
        }
        catch (IllegalArgumentException e) {
            reporter.error("Cannot set property {0} to {1}: {2}", propertyDescriptor.name(), propertyValue, e.getMessage());
        }
    }

    private static void readLanguagePropertiesFromEnv(LanguagePropertyBundle props, PmdReporter reporter, Map<String, String> env) {
        for (PropertyDescriptor<?> propertyDescriptor : props.getPropertyDescriptors()) {
            String envVarName = LanguageProcessorRegistry.getEnvironmentVariableName(props.getLanguage(), propertyDescriptor);
            String propertyValue = env.get(envVarName);
            if (propertyValue == null) continue;
            if (props.isPropertyOverridden(propertyDescriptor)) {
                LOG.debug("Property {} for lang {} is already set, ignoring environment variable {}={}", new Object[]{propertyDescriptor.name(), props.getLanguage().getId(), envVarName, propertyValue});
                continue;
            }
            LOG.debug("Property {} for lang {} is not yet set, using environment variable {}={}", new Object[]{propertyDescriptor.name(), props.getLanguage().getId(), envVarName, propertyValue});
            LanguageProcessorRegistry.trySetPropertyCapture(props, propertyDescriptor, propertyValue, reporter);
        }
    }

    private static String getEnvironmentVariableName(Language lang, PropertyDescriptor<?> propertyDescriptor) {
        return "PMD_" + lang.getId().toUpperCase(Locale.ROOT) + "_" + StringUtil.CaseConvention.CAMEL_CASE.convertTo(StringUtil.CaseConvention.SCREAMING_SNAKE_CASE, propertyDescriptor.name());
    }

    public String toString() {
        return "LanguageProcessorRegistry(" + new LanguageRegistry(this.processors.keySet()).commaSeparatedList(Language::getId) + ")";
    }

    public static class LanguageTerminationException
    extends RuntimeException {
        public LanguageTerminationException(Throwable cause) {
            super(cause);
        }
    }
}

