/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Lookup;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.SystemProperties;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Method;

public class FindFinalizeInvocations
extends BytecodeScanningDetector
implements StatelessDetector {
    private static final boolean DEBUG = SystemProperties.getBoolean("ffi.debug");
    private final BugReporter bugReporter;
    private final BugAccumulator bugAccumulator;
    boolean sawSuperFinalize;

    public FindFinalizeInvocations(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.bugAccumulator = new BugAccumulator(bugReporter);
    }

    @Override
    public void visit(Method obj) {
        if (DEBUG) {
            System.out.println("FFI: visiting " + this.getFullyQualifiedMethodName());
        }
        if ("finalize".equals(this.getMethodName()) && "()V".equals(this.getMethodSig()) && (obj.getAccessFlags() & 1) != 0) {
            this.bugReporter.reportBug(new BugInstance(this, "FI_PUBLIC_SHOULD_BE_PROTECTED", 2).addClassAndMethod(this));
        }
    }

    @Override
    public void visit(Code obj) {
        this.sawSuperFinalize = false;
        super.visit(obj);
        this.bugAccumulator.reportAccumulatedBugs();
        if (!"finalize".equals(this.getMethodName()) || !"()V".equals(this.getMethodSig())) {
            return;
        }
        String overridesFinalizeIn = Lookup.findSuperImplementor(this.getDottedClassName(), "finalize", "()V", this.bugReporter);
        boolean superHasNoFinalizer = "java.lang.Object".equals(overridesFinalizeIn);
        if (obj.getCode().length == 1) {
            if (superHasNoFinalizer) {
                if (!this.getMethod().isFinal()) {
                    this.bugReporter.reportBug(new BugInstance(this, "FI_EMPTY", 2).addClassAndMethod(this));
                }
            } else {
                this.bugReporter.reportBug(new BugInstance(this, "FI_NULLIFY_SUPER", 2).addClassAndMethod(this).addClass(overridesFinalizeIn));
            }
        } else if (obj.getCode().length == 5 && this.sawSuperFinalize) {
            this.bugReporter.reportBug(new BugInstance(this, "FI_USELESS", 2).addClassAndMethod(this));
        } else if (!this.sawSuperFinalize && !superHasNoFinalizer) {
            this.bugReporter.reportBug(new BugInstance(this, "FI_MISSING_SUPER_CALL", 2).addClassAndMethod(this).addClass(overridesFinalizeIn));
        }
    }

    @Override
    public void sawOpcode(int seen) {
        if (seen == 182 && "finalize".equals(this.getNameConstantOperand()) && "()V".equals(this.getSigConstantOperand())) {
            this.bugAccumulator.accumulateBug(new BugInstance(this, "FI_EXPLICIT_INVOCATION", "finalize".equals(this.getMethodName()) && "()V".equals(this.getMethodSig()) ? 1 : 2).addClassAndMethod(this).addCalledMethod(this), this);
        }
        if (seen == 183 && "finalize".equals(this.getNameConstantOperand())) {
            this.sawSuperFinalize = true;
        }
    }
}

