/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;

public class DateFormatStringChecker
extends OpcodeStackDetector {
    private final BugReporter bugReporter;

    public DateFormatStringChecker(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void sawOpcode(int seen) {
        if (seen != 183 && seen != 182 && seen != 184 && seen != 185 || this.stack.getStackDepth() == 0) {
            return;
        }
        String cl = this.getClassConstantOperand();
        String nm = this.getNameConstantOperand();
        String si = this.getSigConstantOperand();
        int idx = -1;
        if ("java/text/SimpleDateFormat".equals(cl) && "(Ljava/lang/String;)V".equals(si) && ("<init>".equals(nm) || "applyPattern".equals(nm) || "applyLocalizedPattern".equals(nm)) || "java/time/format/DateTimeFormatter".equals(cl) && "ofPattern".equals(nm) && "(Ljava/lang/String;)Ljava/time/format/DateTimeFormatter;".equals(si) || "org/apache/commons/lang3/time/FastDateFormat".equals(cl) && "getInstance".equals(nm) && "(Ljava/lang/String;)Lorg/apache/commons/lang3/time/FastDateFormat;".equals(si)) {
            idx = 0;
        } else if ("java/text/SimpleDateFormat".equals(cl) && "<init>".equals(nm) && ("(Ljava/lang/String;Ljava/util/Locale;)V".equals(si) || "(Ljava/lang/String;Ljava/text/DateFormatSymbols;)V".equals(si)) || "java/time/format/DateTimeFormatter".equals(cl) && "ofPattern".equals(nm) && "(Ljava/lang/String;Ljava/util/Locale;)Ljava/time/format/DateTimeFormatter;".equals(si) || "org/apache/commons/lang3/time/FastDateFormat".equals(cl) && "getInstance".equals(nm) && ("(Ljava/lang/String;Ljava/util/Locale;)Lorg/apache/commons/lang3/time/FastDateFormat;".equals(si) || "(Ljava/lang/String;Ljava/util/TimeZone;)Lorg/apache/commons/lang3/time/FastDateFormat;".equals(si))) {
            idx = 1;
        }
        if (idx == -1) {
            return;
        }
        String dateFormatString = (String)this.stack.getStackItem(idx).getConstant();
        if (dateFormatString != null && this.runDateFormatRuleVerify(dateFormatString)) {
            this.bugReporter.reportBug(new BugInstance(this, "FS_BAD_DATE_FORMAT_FLAG_COMBO", 2).addClassAndMethod(this).addCalledMethod(this).addString(dateFormatString).describe("STRING_FORMAT_STRING").addSourceLine(this));
        }
    }

    private boolean runDateFormatRuleVerify(String dateFormat) {
        String interpretedDateFormat = this.removeNonInterpretedText(dateFormat);
        return Stream.of(new Rule(Arrays.asList("a", "B"), null, true, Arrays.asList("h", "K")), new Rule(Arrays.asList("a", "B"), null, false, Arrays.asList("H", "k")), new Rule(Collections.singletonList("Y"), "w", false, Arrays.asList("M", "d")), new Rule(Arrays.asList("H", "h", "K", "k", "m", "s"), null, false, Arrays.asList("A", "N")), new Rule(Collections.singletonList("A"), null, false, Collections.singletonList("N")), new Rule(Collections.singletonList("N"), null, false, Collections.singletonList("A")), new Rule(Collections.singletonList("S"), null, false, Collections.singletonList("n")), new Rule(Collections.singletonList("n"), null, false, Collections.singletonList("S")), new Rule(Collections.singletonList("a"), null, false, Collections.singletonList("B")), new Rule(Collections.singletonList("B"), null, false, Collections.singletonList("a")), new Rule(Collections.singletonList("u"), null, false, Collections.singletonList("y")), new Rule(Collections.singletonList("y"), null, false, Collections.singletonList("u"))).anyMatch(rule -> rule.verify(interpretedDateFormat));
    }

    protected String removeNonInterpretedText(String dateFormat) {
        int length = dateFormat.length();
        boolean inQuote = false;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char c = dateFormat.charAt(i);
            if (c == '\'') {
                inQuote = !inQuote;
                continue;
            }
            if (inQuote) continue;
            builder.append(c);
        }
        return builder.toString();
    }

    private static final class Rule {
        private final boolean isRequired;
        private final String ignoreFlag;
        private final List<String> checkItems;
        private final List<String> triggers;

        Rule(List<String> checkItems, String ignoreFlag, boolean isRequired, List<String> triggers) {
            this.checkItems = checkItems;
            this.ignoreFlag = ignoreFlag;
            this.isRequired = isRequired;
            this.triggers = triggers;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean containsAny(String dateFormat, List<String> listOfFlags) {
            if (listOfFlags == null) return false;
            if (!listOfFlags.stream().anyMatch(dateFormat::contains)) return false;
            return true;
        }

        boolean verify(String dateFormat) {
            if (this.ignoreFlag != null && dateFormat.contains(this.ignoreFlag) || !this.containsAny(dateFormat, this.triggers)) {
                return false;
            }
            boolean cond = this.containsAny(dateFormat, this.checkItems);
            if (this.isRequired) {
                return !cond;
            }
            return cond;
        }
    }
}

