/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.obl;

import edu.umd.cs.findbugs.ba.obl.Obligation;
import edu.umd.cs.findbugs.ba.obl.ObligationFactory;
import java.util.Arrays;

public class ObligationSet {
    private static final int INVALID_HASH_CODE = -1;
    private final short[] countList;
    private final ObligationFactory factory;
    private int cachedHashCode;

    public ObligationSet(ObligationFactory factory) {
        this.countList = new short[factory.getMaxObligationTypes()];
        this.factory = factory;
        this.invalidate();
    }

    public boolean isEmpty() {
        for (short s : this.countList) {
            if (s <= 0) continue;
            return false;
        }
        return true;
    }

    public void add(Obligation obligation) {
        this.invalidate();
        int n = obligation.getId();
        this.countList[n] = (short)(this.countList[n] + 1);
    }

    public void remove(Obligation obligation) {
        this.invalidate();
        short count = this.countList[obligation.getId()];
        if (count > 0) {
            int n = obligation.getId();
            this.countList[n] = (short)(this.countList[n] - 1);
        }
    }

    public int getCount(int id) {
        return this.countList[id];
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        ObligationSet other = (ObligationSet)o;
        return Arrays.equals(this.countList, other.countList);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        int count = 0;
        for (int i = 0; i < this.countList.length; ++i) {
            if (this.countList[i] == 0) continue;
            if (count > 0) {
                buf.append(",");
            }
            buf.append(this.factory.getObligationById(i).toString());
            buf.append(" x ");
            buf.append(this.countList[i]);
            ++count;
        }
        buf.append("}");
        return buf.toString();
    }

    public void copyFrom(ObligationSet other) {
        System.arraycopy(other.countList, 0, this.countList, 0, other.countList.length);
        this.invalidate();
    }

    public ObligationSet duplicate() {
        ObligationSet dup = new ObligationSet(this.factory);
        dup.copyFrom(this);
        return dup;
    }

    public int hashCode() {
        if (this.cachedHashCode == -1) {
            int value = 0;
            for (int i = 0; i < this.countList.length; ++i) {
                value += 13 * i * this.countList[i];
            }
            this.cachedHashCode = value;
        }
        return this.cachedHashCode;
    }

    private void invalidate() {
        this.cachedHashCode = -1;
    }
}

