/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.ba.SourceFileDataSource;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class FileSourceFileDataSource
implements SourceFileDataSource {
    private final String fileName;
    private final URI uri;

    public FileSourceFileDataSource(String fileName) {
        this.fileName = fileName;
        this.uri = new File(fileName).toURI();
    }

    @Override
    public InputStream open() throws IOException {
        return new BufferedInputStream(Files.newInputStream(Path.of(this.fileName, new String[0]), new OpenOption[0]));
    }

    @Override
    public String getFullFileName() {
        return this.fileName;
    }

    @Override
    public URI getFullURI() {
        return this.uri;
    }

    @Override
    public long getLastModified() {
        return new File(this.fileName).lastModified();
    }
}

