/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.inspector.jenkins.amazoninspectorbuildstep.csvconversion;

import com.amazon.inspector.jenkins.amazoninspectorbuildstep.csvconversion.CsvData;
import com.amazon.inspector.jenkins.amazoninspectorbuildstep.html.HtmlConversionUtils;
import com.amazon.inspector.jenkins.amazoninspectorbuildstep.models.sbom.Components.Affect;
import com.amazon.inspector.jenkins.amazoninspectorbuildstep.models.sbom.Components.Component;
import com.amazon.inspector.jenkins.amazoninspectorbuildstep.models.sbom.Components.Property;
import com.amazon.inspector.jenkins.amazoninspectorbuildstep.models.sbom.Components.Rating;
import com.amazon.inspector.jenkins.amazoninspectorbuildstep.models.sbom.Components.Vulnerability;
import com.amazon.inspector.jenkins.amazoninspectorbuildstep.models.sbom.SbomData;
import com.amazon.inspector.jenkins.amazoninspectorbuildstep.sbomparsing.Severity;
import com.amazon.inspector.jenkins.amazoninspectorbuildstep.sbomparsing.SeverityCounts;
import com.google.common.annotations.VisibleForTesting;
import com.opencsv.CSVWriter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

@SuppressFBWarnings
public class CsvConverter {
    private SbomData sbomData;
    private Map<String, Component> componentMap;
    static List<CsvData> dockerData;
    static List<CsvData> vulnData;

    public CsvConverter(SbomData sbomData) {
        this.sbomData = sbomData;
        this.componentMap = this.populateComponentMap(sbomData);
        dockerData = new ArrayList<CsvData>();
        vulnData = new ArrayList<CsvData>();
    }

    Map<String, Component> populateComponentMap(SbomData sbomData) {
        HashMap<String, Component> componentMap = new HashMap<String, Component>();
        if (sbomData == null || sbomData.getSbom() == null || sbomData.getSbom().getComponents() == null) {
            return componentMap;
        }
        for (Component component : sbomData.getSbom().getComponents()) {
            componentMap.put(component.getBomRef(), component);
        }
        return componentMap;
    }

    public String convertVulnerabilities(String imageName, String imageSha, String buildId, SeverityCounts counts) throws IOException {
        Map<Severity, Integer> countMap = counts.getCounts();
        String tmpdir = System.getProperty("java.io.tmpdir");
        ArrayList<String[]> dataLineArray = new ArrayList<String[]>();
        dataLineArray.add(new String[]{String.format("#image_name: %s; image_sha: %s; build_id: %s", imageName, imageSha, buildId)});
        dataLineArray.add(new String[]{String.format("#low_vulnerabilities: %s; medium_vulnerabilities: %s; high_vulnerabilities: %s; critical_vulnerabilities: %s; other_vulnerabilities: %s", countMap.get((Object)Severity.LOW), countMap.get((Object)Severity.MEDIUM), countMap.get((Object)Severity.HIGH), countMap.get((Object)Severity.CRITICAL), countMap.get((Object)Severity.OTHER))});
        List<String[]> dataLines = this.buildVulnerabilityDataLines();
        if (vulnData.size() <= 0) {
            return null;
        }
        dataLineArray.addAll(dataLines);
        File file = new File(tmpdir + "/temp.csv");
        FileWriter outputfile = new FileWriter(file, Charset.forName("UTF-8"));
        CSVWriter writer = new CSVWriter((Writer)outputfile);
        writer.writeAll(dataLineArray);
        writer.close();
        return new String(Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0])), StandardCharsets.UTF_8);
    }

    public String convertDocker(String imageName, String imageSha, String buildId, SeverityCounts vulnCounts) throws IOException {
        Map<Severity, Integer> countMap = vulnCounts.getCounts();
        String tmpdir = System.getProperty("java.io.tmpdir");
        ArrayList<String[]> dataLineArray = new ArrayList<String[]>();
        dataLineArray.add(new String[]{String.format("#image_name: %s; image_sha: %s; build_id: %s", imageName, imageSha, buildId)});
        dataLineArray.add(new String[]{String.format("#low_vulnerabilities: %s; medium_vulnerabilities: %s; high_vulnerabilities: %s; critical_vulnerabilities: %s; other_vulnerabilities: %s", countMap.get((Object)Severity.LOW), countMap.get((Object)Severity.MEDIUM), countMap.get((Object)Severity.HIGH), countMap.get((Object)Severity.CRITICAL), countMap.get((Object)Severity.OTHER))});
        List<String[]> dataLines = this.buildDockerDataLines();
        if (dockerData.size() <= 0) {
            return null;
        }
        dataLineArray.addAll(dataLines);
        File file = new File(tmpdir + "/temp.csv");
        FileWriter outputfile = new FileWriter(file, Charset.forName("UTF-8"));
        CSVWriter writer = new CSVWriter((Writer)outputfile);
        writer.writeAll(dataLineArray);
        writer.close();
        return new String(Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0])), StandardCharsets.UTF_8);
    }

    protected List<String[]> buildVulnerabilityDataLines() {
        ArrayList<String[]> dataLines = new ArrayList<String[]>();
        String[] headers = new String[]{"Vulnerability ID", "Severity", "Published", "Modified", "Description", "Package Installed Version", "Package Fixed Version", "Package Path", "EPSS Score", "Exploit Available", "Exploit Last Seen", "CWEs"};
        dataLines.add(headers);
        for (CsvData csvData : vulnData) {
            String[] dataLine = new String[]{csvData.getVulnerabilityId(), StringUtils.capitalize((String)csvData.getSeverity()), csvData.getPublished(), csvData.getModified(), csvData.getDescription(), csvData.getPackageInstalledVersion(), csvData.getPackageFixedVersion(), csvData.getPackagePath(), csvData.getEpssScore(), csvData.getExploitAvailable(), csvData.getExploitLastSeen(), csvData.getCwes()};
            dataLines.add(dataLine);
        }
        return dataLines;
    }

    protected List<String[]> buildDockerDataLines() {
        ArrayList<String[]> dataLines = new ArrayList<String[]>();
        String[] headers = new String[]{"Vulnerability ID", "Severity", "Description", "File", "Line(s)"};
        dataLines.add(headers);
        for (CsvData csvData : dockerData) {
            String[] dataLine = new String[]{csvData.getVulnerabilityId(), StringUtils.capitalize((String)csvData.getSeverity()), csvData.getDescription(), csvData.getFile(), csvData.getLines()};
            dataLines.add(dataLine);
        }
        return dataLines;
    }

    public void routeVulnerabilities() {
        List<Vulnerability> vulnerabilities = this.sbomData.getSbom().getVulnerabilities();
        if (vulnerabilities == null) {
            return;
        }
        for (Vulnerability vulnerability : vulnerabilities) {
            for (Affect componentRef : vulnerability.getAffects()) {
                Component comp = this.componentMap.get(componentRef.getRef());
                if (comp == null) continue;
                this.routeDockerCsvData(vulnerability, comp);
                this.routeVulnCsvData(vulnerability, comp);
            }
        }
    }

    @SuppressFBWarnings
    public void routeDockerCsvData(Vulnerability vulnerability, Component component) {
        String installedVersion = component.getPurl();
        String fixedVersion = CsvConverter.getPropertyValueFromKey(vulnerability, String.format("amazon:inspector:sbom_scanner:fixed_version:%s", component.getBomRef()));
        String exploitAvailable = CsvConverter.getPropertyValueFromKey(vulnerability, "amazon:inspector:sbom_scanner:exploit_available");
        String exploitLastSeen = CsvConverter.getPropertyValueFromKey(vulnerability, "amazon:inspector:sbom_scanner:exploit_last_seen_in_public");
        String path = this.getPropertyValueFromKey(component, "amazon:inspector:sbom_scanner:path");
        List<Component> lineComponents = HtmlConversionUtils.getLineComponents(this.sbomData.getSbom().getComponents());
        for (Component lineComponent : lineComponents) {
            String file = lineComponent.getName();
            Object lines = HtmlConversionUtils.getLines(vulnerability.getId(), lineComponent.getProperties());
            if (lineComponent != null && lineComponent.getName().startsWith("dockerfile:")) {
                lines = (String)lines + " - Derived";
            }
            CsvData csvData = CsvData.builder().vulnerabilityId(vulnerability.getId()).severity(this.getSeverity(vulnerability)).published(vulnerability.getCreated()).modified(this.getUpdated(vulnerability)).epssScore(this.getEpssScore(vulnerability)).description(vulnerability.getDescription()).packageInstalledVersion(installedVersion).packageFixedVersion(fixedVersion).packagePath(path).cwes(this.getCwesAsString(vulnerability)).exploitAvailable(exploitAvailable).exploitLastSeen(exploitLastSeen).file(file).lines((String)lines).build();
            if (!vulnerability.getId().startsWith("IN-DOCKER")) continue;
            dockerData.add(csvData);
        }
    }

    public void routeVulnCsvData(Vulnerability vulnerability, Component component) {
        String installedVersion = component.getPurl();
        String fixedVersion = CsvConverter.getPropertyValueFromKey(vulnerability, String.format("amazon:inspector:sbom_scanner:fixed_version:%s", component.getBomRef()));
        String exploitAvailable = CsvConverter.getPropertyValueFromKey(vulnerability, "amazon:inspector:sbom_scanner:exploit_available");
        String exploitLastSeen = CsvConverter.getPropertyValueFromKey(vulnerability, "amazon:inspector:sbom_scanner:exploit_last_seen_in_public");
        String path = this.getPropertyValueFromKey(component, "amazon:inspector:sbom_scanner:path");
        CsvData csvData = CsvData.builder().vulnerabilityId(vulnerability.getId()).severity(this.getSeverity(vulnerability)).published(vulnerability.getCreated()).modified(this.getUpdated(vulnerability)).epssScore(this.getEpssScore(vulnerability)).description(vulnerability.getDescription()).packageInstalledVersion(installedVersion).packageFixedVersion(fixedVersion).packagePath(path).cwes(this.getCwesAsString(vulnerability)).exploitAvailable(exploitAvailable).exploitLastSeen(exploitLastSeen).build();
        if (!vulnerability.getId().startsWith("IN-DOCKER")) {
            vulnData.add(csvData);
        }
    }

    @VisibleForTesting
    protected String getUpdated(Vulnerability vulnerability) {
        if (vulnerability == null || vulnerability.getUpdated() == null) {
            return "N/A";
        }
        return vulnerability.getUpdated();
    }

    @VisibleForTesting
    protected String getCwesAsString(Vulnerability vulnerability) {
        ArrayList<String> cwes = new ArrayList<String>();
        if (vulnerability == null || vulnerability.getCwes() == null) {
            return "";
        }
        for (Integer cwe : vulnerability.getCwes()) {
            cwes.add(String.format("CWE-%s", cwe.toString()));
        }
        return String.join((CharSequence)", ", cwes);
    }

    @VisibleForTesting
    protected String getEpssScore(Vulnerability vulnerability) {
        if (vulnerability == null || vulnerability.getRatings() == null) {
            return "N/A";
        }
        for (Rating rating : vulnerability.getRatings()) {
            if (!rating.getSource().getName().equals("EPSS")) continue;
            return Double.toString(rating.getScore());
        }
        return "N/A";
    }

    @VisibleForTesting
    protected static String getPropertyValueFromKey(Vulnerability vulnerability, String key) {
        if (vulnerability == null || vulnerability.getProperties() == null) {
            return "N/A";
        }
        for (Property property : vulnerability.getProperties()) {
            if (!property.getName().equals(key)) continue;
            return property.getValue();
        }
        return "N/A";
    }

    protected String getPropertyValueFromKey(Component component, String key) {
        if (component == null || component.getProperties() == null) {
            return "N/A";
        }
        for (Property property : component.getProperties()) {
            if (!property.getName().equals(key)) continue;
            return property.getValue();
        }
        return "N/A";
    }

    protected String getSeverity(Vulnerability vulnerability) {
        String OTHER = "OTHER";
        if (vulnerability == null || vulnerability.getRatings() == null) {
            return "OTHER";
        }
        List<Rating> ratings = vulnerability.getRatings();
        if (ratings.isEmpty()) {
            return "OTHER";
        }
        String nvd = "NVD";
        String cvss = "CVSSv3";
        for (Rating rating : ratings) {
            String sourceName = rating.getSource().getName();
            String method = rating.getMethod();
            if (!sourceName.equals("NVD") || !method.startsWith("CVSSv3")) continue;
            return rating.getSeverity();
        }
        return ratings.get(0).getSeverity();
    }
}

