/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.inspector.jenkins.amazoninspectorbuildstep;

import com.amazon.inspector.jenkins.amazoninspectorbuildstep.csvconversion.CsvConverter;
import com.amazon.inspector.jenkins.amazoninspectorbuildstep.html.HtmlConversionUtils;
import com.amazon.inspector.jenkins.amazoninspectorbuildstep.html.HtmlJarHandler;
import com.amazon.inspector.jenkins.amazoninspectorbuildstep.models.html.HtmlData;
import com.amazon.inspector.jenkins.amazoninspectorbuildstep.models.html.components.ImageMetadata;
import com.amazon.inspector.jenkins.amazoninspectorbuildstep.models.requests.SdkRequests;
import com.amazon.inspector.jenkins.amazoninspectorbuildstep.models.sbom.Components.Vulnerability;
import com.amazon.inspector.jenkins.amazoninspectorbuildstep.models.sbom.Sbom;
import com.amazon.inspector.jenkins.amazoninspectorbuildstep.models.sbom.SbomData;
import com.amazon.inspector.jenkins.amazoninspectorbuildstep.sbomgen.SbomgenDownloader;
import com.amazon.inspector.jenkins.amazoninspectorbuildstep.sbomgen.SbomgenRunner;
import com.amazon.inspector.jenkins.amazoninspectorbuildstep.sbomparsing.SbomOutputParser;
import com.amazon.inspector.jenkins.amazoninspectorbuildstep.sbomparsing.Severity;
import com.amazon.inspector.jenkins.amazoninspectorbuildstep.utils.InspectorRegions;
import com.amazon.inspector.jenkins.amazoninspectorbuildstep.utils.Sanitizer;
import com.cloudbees.jenkins.plugins.awscredentials.AmazonWebServicesCredentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.security.Permission;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.oidc_provider.IdTokenFileCredentials;
import io.jenkins.plugins.oidc_provider.IdTokenStringCredentials;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import jenkins.util.BuildListenerAdapter;
import lombok.Generated;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.verb.POST;

public class AmazonInspectorBuilder
extends Builder
implements SimpleBuildStep {
    @SuppressFBWarnings
    public static PrintStream logger;
    private static final int MAX_BLOCKED_CVES_CONSOLE = 20;
    private static final int MAX_IGNORED_CVES_CONSOLE = 10;
    private static final int MAX_EPSS_CVES_CONSOLE = 10;
    private static final int MAX_HIGH_MEDIUM_CVES_CONSOLE = 10;
    private static final int MAX_LOW_CVES_CONSOLE = 5;
    private static final int MAX_CRITICAL_CVES_CONSOLE = 20;
    private final String archivePath;
    private final String archiveType;
    private final String iamRole;
    private final String awsRegion;
    private final String credentialId;
    private final String oidcCredentialId;
    private boolean isSeverityThresholdEnabled;
    private boolean isEpssThresholdEnabled;
    private final boolean isSuppressedCveEnabled;
    private final boolean isAutoFailCveEnabled;
    private final boolean osArch;
    private final int countCritical;
    private final int countHigh;
    private final int countMedium;
    private final int countLow;
    private final String awsCredentialId;
    private final String awsProfileName;
    private final String sbomgenSelection;
    private final String sbomgenPath;
    private final String sbomgenSkipFiles;
    private final Double epssThreshold;
    private final String suppressedCveList;
    private final String autoFailCveList;
    private Job<?, ?> job;
    private String reportArtifactName = "default-report";
    private final boolean showThresholdDeprecationWarning;
    private final boolean showEpssDeprecationWarning;

    @DataBoundConstructor
    public AmazonInspectorBuilder(String archivePath, String artifactPath, String archiveType, boolean osArch, String iamRole, String awsRegion, String credentialId, String awsProfileName, String awsCredentialId, String sbomgenSelection, String sbomgenPath, int countCritical, int countHigh, int countMedium, int countLow, String oidcCredentialId, String sbomgenSkipFiles, Double epssThreshold, String suppressedCveList, Boolean isSuppressedCveEnabled, Boolean isAutoFailCveEnabled, String autoFailCveList, Boolean isThresholdEnabled, Boolean isEpssEnabled) {
        this.archivePath = artifactPath != null && !artifactPath.isEmpty() ? artifactPath : archivePath;
        this.archiveType = archiveType;
        this.credentialId = credentialId;
        this.awsCredentialId = awsCredentialId;
        this.oidcCredentialId = oidcCredentialId;
        this.awsProfileName = awsProfileName;
        this.osArch = osArch;
        this.iamRole = iamRole;
        this.awsRegion = awsRegion;
        this.sbomgenSelection = sbomgenSelection != null ? sbomgenSelection : "automatic";
        this.sbomgenPath = sbomgenPath;
        this.sbomgenSkipFiles = sbomgenSkipFiles;
        boolean finalSeverityThresholdEnabled = false;
        boolean finalEpssThresholdEnabled = false;
        this.showThresholdDeprecationWarning = isThresholdEnabled != null;
        boolean bl = this.showEpssDeprecationWarning = isEpssEnabled != null;
        if (isThresholdEnabled != null) {
            finalSeverityThresholdEnabled = isThresholdEnabled;
        }
        if (isEpssEnabled != null) {
            finalEpssThresholdEnabled = isEpssEnabled;
        }
        this.isSeverityThresholdEnabled = finalSeverityThresholdEnabled;
        this.isEpssThresholdEnabled = finalEpssThresholdEnabled;
        this.isSuppressedCveEnabled = isSuppressedCveEnabled != null ? isSuppressedCveEnabled : false;
        this.isAutoFailCveEnabled = isAutoFailCveEnabled != null ? isAutoFailCveEnabled : false;
        this.suppressedCveList = suppressedCveList != null ? suppressedCveList : "";
        this.autoFailCveList = autoFailCveList != null ? autoFailCveList : "";
        this.countCritical = countCritical;
        this.countHigh = countHigh;
        this.countMedium = countMedium;
        this.countLow = countLow;
        this.epssThreshold = epssThreshold;
        this.reportArtifactName = this.reportArtifactName != null && !this.reportArtifactName.isEmpty() ? this.reportArtifactName : "default-report";
    }

    private boolean doesBuildFail(Map<Severity, Integer> counts) {
        boolean criticalExceedsLimit = counts.get((Object)Severity.CRITICAL) > this.countCritical;
        boolean highExceedsLimit = counts.get((Object)Severity.HIGH) > this.countHigh;
        boolean mediumExceedsLimit = counts.get((Object)Severity.MEDIUM) > this.countMedium;
        boolean lowExceedsLimit = counts.get((Object)Severity.LOW) > this.countLow;
        return criticalExceedsLimit || highExceedsLimit || mediumExceedsLimit || lowExceedsLimit;
    }

    private void logThresholdBreachDetails(SbomData sbomData, TaskListener listener, Map<Severity, Integer> counts) {
        List<Vulnerability> vulnerabilities = sbomData.getSbom().getVulnerabilities();
        if (vulnerabilities == null || vulnerabilities.isEmpty()) {
            return;
        }
        boolean hasBreaches = false;
        HashMap<Severity, Integer> exceedingCounts = new HashMap<Severity, Integer>();
        if (counts.get((Object)Severity.CRITICAL) > this.countCritical) {
            exceedingCounts.put(Severity.CRITICAL, counts.get((Object)Severity.CRITICAL) - this.countCritical);
            hasBreaches = true;
        }
        if (counts.get((Object)Severity.HIGH) > this.countHigh) {
            exceedingCounts.put(Severity.HIGH, counts.get((Object)Severity.HIGH) - this.countHigh);
            hasBreaches = true;
        }
        if (counts.get((Object)Severity.MEDIUM) > this.countMedium) {
            exceedingCounts.put(Severity.MEDIUM, counts.get((Object)Severity.MEDIUM) - this.countMedium);
            hasBreaches = true;
        }
        if (counts.get((Object)Severity.LOW) > this.countLow) {
            exceedingCounts.put(Severity.LOW, counts.get((Object)Severity.LOW) - this.countLow);
            hasBreaches = true;
        }
        if (!hasBreaches) {
            return;
        }
        listener.getLogger().println("THRESHOLD BREACH DETAILS:");
        listener.getLogger().println("Thresholds: Critical\u2264" + this.countCritical + ", High\u2264" + this.countHigh + ", Medium\u2264" + this.countMedium + ", Low\u2264" + this.countLow);
        listener.getLogger().println("Actual: Critical=" + String.valueOf(counts.get((Object)Severity.CRITICAL)) + ", High=" + String.valueOf(counts.get((Object)Severity.HIGH)) + ", Medium=" + String.valueOf(counts.get((Object)Severity.MEDIUM)) + ", Low=" + String.valueOf(counts.get((Object)Severity.LOW)));
        HashMap cvesBySeverity = new HashMap();
        cvesBySeverity.put(Severity.CRITICAL, new HashSet());
        cvesBySeverity.put(Severity.HIGH, new HashSet());
        cvesBySeverity.put(Severity.MEDIUM, new HashSet());
        cvesBySeverity.put(Severity.LOW, new HashSet());
        block17: for (Vulnerability vulnerability : vulnerabilities) {
            Severity severity;
            String severityStr = "UNKNOWN";
            if (vulnerability.getRatings() != null && !vulnerability.getRatings().isEmpty()) {
                severityStr = vulnerability.getRatings().get(0).getSeverity();
            }
            switch (severityStr.toUpperCase()) {
                case "CRITICAL": {
                    severity = Severity.CRITICAL;
                    break;
                }
                case "HIGH": {
                    severity = Severity.HIGH;
                    break;
                }
                case "MEDIUM": {
                    severity = Severity.MEDIUM;
                    break;
                }
                case "LOW": {
                    severity = Severity.LOW;
                    break;
                }
                default: {
                    continue block17;
                }
            }
            if (!exceedingCounts.containsKey((Object)severity)) continue;
            ((Set)cvesBySeverity.get((Object)severity)).add(vulnerability.getId());
        }
        block18: for (Severity severity : new Severity[]{Severity.CRITICAL, Severity.HIGH, Severity.MEDIUM, Severity.LOW}) {
            Set cves;
            if (!exceedingCounts.containsKey((Object)severity) || (cves = (Set)cvesBySeverity.get((Object)severity)).isEmpty()) continue;
            listener.getLogger().println(severity.name() + " CVEs (" + cves.size() + "):");
            int maxToShow = switch (severity) {
                case Severity.CRITICAL -> 20;
                case Severity.HIGH, Severity.MEDIUM -> 10;
                case Severity.LOW -> 5;
                default -> 5;
            };
            int count = 0;
            for (String cve : cves) {
                if (count < maxToShow) {
                    listener.getLogger().println("  - " + cve);
                    ++count;
                    continue;
                }
                listener.getLogger().println("  ... and " + (cves.size() - count) + " more " + severity.name() + " CVEs (check SBOM file for complete list)");
                continue block18;
            }
        }
    }

    private void filterSuppressedCvesFromCounts(SbomData sbomData, Set<String> suppressedCveSet, TaskListener listener) {
        List<Vulnerability> vulnerabilities = sbomData.getSbom().getVulnerabilities();
        if (vulnerabilities == null || vulnerabilities.isEmpty()) {
            return;
        }
        int suppressedCount = 0;
        HashMap<Severity, Integer> suppressedCounts = new HashMap<Severity, Integer>();
        suppressedCounts.put(Severity.CRITICAL, 0);
        suppressedCounts.put(Severity.HIGH, 0);
        suppressedCounts.put(Severity.MEDIUM, 0);
        suppressedCounts.put(Severity.LOW, 0);
        suppressedCounts.put(Severity.OTHER, 0);
        for (Vulnerability vulnerability : vulnerabilities) {
            String cveId = vulnerability.getId();
            if (!suppressedCveSet.contains(cveId.toUpperCase())) continue;
            ++suppressedCount;
            String severityStr = "UNKNOWN";
            if (vulnerability.getRatings() != null && !vulnerability.getRatings().isEmpty()) {
                severityStr = vulnerability.getRatings().get(0).getSeverity();
            }
            Severity severity = switch (severityStr.toUpperCase()) {
                case "CRITICAL" -> Severity.CRITICAL;
                case "HIGH" -> Severity.HIGH;
                case "MEDIUM" -> Severity.MEDIUM;
                case "LOW" -> Severity.LOW;
                default -> Severity.OTHER;
            };
            suppressedCounts.put(severity, (Integer)suppressedCounts.get((Object)severity) + 1);
        }
        if (suppressedCount > 0) {
            listener.getLogger().println("Suppressing " + suppressedCount + " CVEs from threshold calculations: " + String.valueOf(suppressedCveSet));
            Map<Severity, Integer> currentCounts = SbomOutputParser.aggregateCounts.getCounts();
            for (Map.Entry entry : suppressedCounts.entrySet()) {
                if ((Integer)entry.getValue() <= 0) continue;
                int newCount = Math.max(0, currentCounts.get(entry.getKey()) - (Integer)entry.getValue());
                currentCounts.put((Severity)((Object)entry.getKey()), newCount);
            }
        }
    }

    private boolean checkForAutoFailCves(SbomData sbomData, Set<String> autoFailCveSet, TaskListener listener) {
        List<Vulnerability> vulnerabilities = sbomData.getSbom().getVulnerabilities();
        if (vulnerabilities == null || vulnerabilities.isEmpty()) {
            return false;
        }
        HashSet<String> foundAutoFailCves = new HashSet<String>();
        for (Vulnerability vulnerability : vulnerabilities) {
            String cveId = vulnerability.getId();
            if (!autoFailCveSet.contains(cveId.toUpperCase())) continue;
            foundAutoFailCves.add(cveId);
        }
        if (!foundAutoFailCves.isEmpty()) {
            listener.getLogger().println("BUILD FAILED: Found " + foundAutoFailCves.size() + " auto-fail CVE(s):");
            int count = 0;
            for (String cve : foundAutoFailCves) {
                if (count < 20) {
                    listener.getLogger().println("  - " + cve);
                    ++count;
                    continue;
                }
                listener.getLogger().println("  ... and " + (foundAutoFailCves.size() - count) + " more auto-fail CVEs (check assessment file for complete list)");
                break;
            }
            listener.getLogger().println("These CVEs are configured to always fail the build.");
            return true;
        }
        return false;
    }

    private void logSecurityAssessmentSummary(TaskListener listener, Set<String> suppressedCveSet, int suppressedCount) {
        listener.getLogger().println("");
        listener.getLogger().println("=== SECURITY ASSESSMENT SUMMARY ===");
        listener.getLogger().println("Timestamp: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(Calendar.getInstance().getTime()));
        listener.getLogger().println("Features: Thresholds=" + (this.isSeverityThresholdEnabled ? "\u2713" : "\u2717") + ", EPSS=" + (this.isEpssThresholdEnabled ? "\u2713" : "\u2717") + ", CVE Suppression=" + (this.isSuppressedCveEnabled ? "\u2713" : "\u2717") + ", CVE Auto-fail=" + (this.isAutoFailCveEnabled ? "\u2713" : "\u2717"));
        if (this.isSuppressedCveEnabled && suppressedCount > 0 && suppressedCveSet != null) {
            listener.getLogger().println("CVE Suppression List (" + suppressedCount + " CVEs ignored from thresholds):");
            int count = 0;
            for (String cve : suppressedCveSet) {
                if (count < 10) {
                    listener.getLogger().println("  - " + cve);
                    ++count;
                    continue;
                }
                listener.getLogger().println("  ... and " + (suppressedCount - count) + " more (check assessment file for complete list)");
                break;
            }
        }
        listener.getLogger().println("=====================================");
        listener.getLogger().println("");
    }

    @DataBoundSetter
    public void setReportArtifactName(String reportArtifactName) {
        if (reportArtifactName == null || reportArtifactName.trim().isEmpty()) {
            this.reportArtifactName = "default-report";
            return;
        }
        String sanitizedName = reportArtifactName.trim();
        if (sanitizedName.length() > 255) {
            throw new IllegalArgumentException("Report artifact name must not exceed 255 characters");
        }
        if (!sanitizedName.matches("^[a-zA-Z0-9._-]+$")) {
            throw new IllegalArgumentException("Report artifact name must only contain letters, numbers, dots, underscores, or hyphens");
        }
        this.reportArtifactName = sanitizedName;
    }

    @DataBoundSetter
    public void setIsSeverityThresholdEnabled(boolean isSeverityThresholdEnabled) {
        this.isSeverityThresholdEnabled = isSeverityThresholdEnabled;
    }

    @DataBoundSetter
    public void setIsEpssThresholdEnabled(boolean isEpssThresholdEnabled) {
        this.isEpssThresholdEnabled = isEpssThresholdEnabled;
    }

    @DataBoundSetter
    public void setIsThresholdEnabled(boolean isThresholdEnabled) {
        this.isSeverityThresholdEnabled = isThresholdEnabled;
    }

    @DataBoundSetter
    public void setIsEpssEnabled(boolean isEpssEnabled) {
        this.isEpssThresholdEnabled = isEpssEnabled;
    }

    public String getReportArtifactName() {
        return this.reportArtifactName != null ? this.reportArtifactName : "default-report";
    }

    public boolean getIsSeverityThresholdEnabled() {
        return this.isSeverityThresholdEnabled;
    }

    public boolean getIsEpssThresholdEnabled() {
        return this.isEpssThresholdEnabled;
    }

    public boolean getIsSuppressedCveEnabled() {
        return this.isSuppressedCveEnabled;
    }

    public boolean getIsAutoFailCveEnabled() {
        return this.isAutoFailCveEnabled;
    }

    public String getSuppressedCveList() {
        return this.suppressedCveList;
    }

    public String getAutoFailCveList() {
        return this.autoFailCveList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform(Run<?, ?> build, FilePath workspace, EnvVars env, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        logger = listener.getLogger();
        File outFile = new File(build.getRootDir(), "out");
        this.job = build.getParent();
        try (PrintStream printStream = new PrintStream(outFile, StandardCharsets.UTF_8);){
            String csvDockerContent;
            String activeSbomgenPath;
            String sbomgenSelection;
            if (this.showThresholdDeprecationWarning) {
                listener.getLogger().println("[DEPRECATED] Parameter 'isThresholdEnabled' is deprecated. Use 'isSeverityThresholdEnabled' instead.");
            }
            if (this.showEpssDeprecationWarning) {
                listener.getLogger().println("[DEPRECATED] Parameter 'isEpssEnabled' is deprecated. Use 'isEpssThresholdEnabled' instead.");
            }
            HashMap<String, String> artifactMap = new HashMap<String, String>();
            if (Jenkins.getInstanceOrNull() == null) {
                throw new RuntimeException("No Jenkins instance found.");
            }
            String activeArchiveType = this.archiveType;
            if (activeArchiveType == null || activeArchiveType.isEmpty()) {
                activeArchiveType = "container";
            }
            if ("automatic".equalsIgnoreCase(sbomgenSelection = this.sbomgenSelection)) {
                logger.println("Automatic SBOMGen selected, downloading using default settings...");
                activeSbomgenPath = SbomgenDownloader.getBinary(workspace, env, launcher);
            } else if ("manual".equalsIgnoreCase(sbomgenSelection)) {
                if (this.sbomgenPath == null || this.sbomgenPath.isEmpty()) {
                    throw new IllegalArgumentException("Manual SBOMGen selected but no path provided.");
                }
                File sbomgenFile = new File(this.sbomgenPath);
                if (!sbomgenFile.exists() || !sbomgenFile.canExecute()) {
                    throw new IllegalArgumentException("Provided SBOMgen path is invalid or not executable: " + this.sbomgenPath);
                }
                logger.println("Manual SBOMGen selected, using provided path: " + this.sbomgenPath);
                activeSbomgenPath = this.sbomgenPath;
            } else {
                logger.println("Invalid SBOMGen selection. Defaulting to Automatic.");
                activeSbomgenPath = SbomgenDownloader.getBinary(workspace, env, launcher);
            }
            StandardUsernamePasswordCredentials credential = null;
            if (this.credentialId == null) {
                logger.println("Credential ID is null, this is not normal, please check your config. Continuing without docker credentials.");
            } else {
                credential = (StandardUsernamePasswordCredentials)CredentialsProvider.findCredentialById((String)this.credentialId, StandardUsernamePasswordCredentials.class, build);
            }
            String skipfiles = this.sbomgenSkipFiles != null ? this.sbomgenSkipFiles : "";
            String sbom = credential != null ? new SbomgenRunner(launcher, workspace, activeSbomgenPath, activeArchiveType, this.archivePath, credential.getUsername(), credential.getPassword().getPlainText(), skipfiles).run() : new SbomgenRunner(launcher, workspace, activeSbomgenPath, activeArchiveType, this.archivePath, null, null, skipfiles).run();
            JsonElement metadata = JsonParser.parseString((String)sbom).getAsJsonObject().get("metadata");
            JsonObject component = null;
            if (metadata != null && metadata.getAsJsonObject().get("component") != null) {
                component = metadata.getAsJsonObject().get("component").getAsJsonObject();
            }
            Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            String imageSha = AmazonInspectorBuilder.getImageSha(sbom);
            listener.getLogger().printf("Sending SBOM to Inspector for validation with info: credential:%s, role:%s, profile:%s", this.awsCredentialId, this.iamRole, this.awsProfileName);
            AmazonWebServicesCredentials awsCredential = null;
            if (this.awsCredentialId != null) {
                awsCredential = (AmazonWebServicesCredentials)CredentialsProvider.findCredentialById((String)this.awsCredentialId, AmazonWebServicesCredentials.class, build);
            }
            listener.getLogger().print("\n");
            String workingOidcCredentialId = this.oidcCredentialId;
            if (workingOidcCredentialId == null) {
                workingOidcCredentialId = "";
            }
            IdTokenStringCredentials oidcStr = (IdTokenStringCredentials)CredentialsProvider.findCredentialById((String)workingOidcCredentialId, IdTokenStringCredentials.class, build);
            IdTokenFileCredentials oidcFile = (IdTokenFileCredentials)CredentialsProvider.findCredentialById((String)workingOidcCredentialId, IdTokenFileCredentials.class, build);
            String oidcToken = this.getOidcToken(oidcStr, oidcFile);
            String responseData = new SdkRequests(this.awsRegion, awsCredential, oidcToken, this.awsProfileName, this.iamRole).requestSbom(sbom);
            SbomData sbomData = SbomData.builder().sbom((Sbom)gson.fromJson(responseData, Sbom.class)).build();
            String sbomFileName = String.format("%s-%s-sbom.json", this.reportArtifactName, build.getDisplayName()).replaceAll("[ #]", "");
            String sbomWorkspacePath = String.format("%s/%s", build.getId(), sbomFileName);
            FilePath sbomFile = workspace.child(sbomWorkspacePath);
            FilePath sbomFileParent = sbomFile.getParent();
            if (sbomFile == null || sbomFileParent == null) {
                throw new NullPointerException("SbomFile cannot be null.");
            }
            if (!sbomFileParent.exists()) {
                sbomFileParent.mkdirs();
            }
            sbomFile.write(gson.toJson((Object)sbomData.getSbom()), "UTF-8");
            artifactMap.put(sbomFileName, sbomWorkspacePath);
            build.getArtifactManager().archive(workspace, launcher, (BuildListener)new BuildListenerAdapter(listener), artifactMap);
            listener.getLogger().println("Artifact saved: " + sbomFile.getRemote());
            CsvConverter converter = new CsvConverter(sbomData);
            String csvVulnFileName = String.format("%s-%s-vuln.csv", build.getParent().getDisplayName(), build.getDisplayName()).replaceAll("[ #]", "");
            String csvVulnWorkspacePath = String.format("%s/%s", build.getId(), csvVulnFileName);
            FilePath csvVulnFile = workspace.child(csvVulnWorkspacePath);
            String csvDockerFileName = String.format("%s-%s-docker.csv", build.getParent().getDisplayName(), build.getDisplayName()).replaceAll("[ #]", "");
            String csvDockerWorkspacePath = String.format("%s/%s", build.getId(), csvDockerFileName);
            FilePath csvDockerFile = workspace.child(csvDockerWorkspacePath);
            logger.println("Converting SBOM Results to CSV.");
            SbomOutputParser parser = new SbomOutputParser(sbomData);
            parser.parseVulnCounts();
            HashSet<String> suppressedCveSet = null;
            int suppressedCount = 0;
            if (this.isSuppressedCveEnabled && this.suppressedCveList != null && !this.suppressedCveList.trim().isEmpty()) {
                String[] cveArray;
                suppressedCveSet = new HashSet<String>();
                for (String cve : cveArray = this.suppressedCveList.split("[,\\n\\r]+")) {
                    suppressedCveSet.add(cve.trim().toUpperCase());
                }
                suppressedCount = suppressedCveSet.size();
                this.filterSuppressedCvesFromCounts(sbomData, suppressedCveSet, listener);
            }
            String sanitizedArchiveName = null;
            String componentName = null;
            if (component != null && component.get("name") != null) {
                componentName = component.get("name").getAsString();
            }
            sanitizedArchiveName = componentName != null && componentName.endsWith(".tar") ? Sanitizer.sanitizeFilePath("file://" + componentName) : this.archivePath;
            converter.routeVulnerabilities();
            String csvVulnContent = converter.convertVulnerabilities(sanitizedArchiveName, imageSha, build.getId(), SbomOutputParser.vulnCounts);
            if (csvVulnContent != null) {
                artifactMap.put(csvVulnFileName, csvVulnWorkspacePath);
                csvVulnFile.write(csvVulnContent, "UTF-8");
            }
            if ((csvDockerContent = converter.convertDocker(sanitizedArchiveName, imageSha, build.getId(), SbomOutputParser.dockerCounts)) != null) {
                artifactMap.put(csvDockerFileName, csvDockerWorkspacePath);
                csvDockerFile.write(csvDockerContent, "UTF-8");
            }
            String[] splitName = sanitizedArchiveName.split(":");
            String tag = null;
            if (splitName.length > 1) {
                tag = splitName[1];
            }
            HtmlData htmlData = HtmlData.builder().artifactsPath(Sanitizer.sanitizeUrl((String)env.get((Object)"RUN_ARTIFACTS_DISPLAY_URL"))).updatedAt(new SimpleDateFormat("MM/dd/yyyy, hh:mm:ss aa").format(Calendar.getInstance().getTime())).imageMetadata(ImageMetadata.builder().id(splitName[0]).tags(tag).sha(imageSha).build()).docker(HtmlConversionUtils.convertDocker(sbomData.getSbom().getVulnerabilities(), sbomData.getSbom().getComponents())).vulnerabilities(HtmlConversionUtils.convertVulnerabilities(sbomData.getSbom().getVulnerabilities(), sbomData.getSbom().getComponents())).build();
            String reportData = gson.toJson((Object)htmlData);
            String htmlJarPath = String.valueOf(new FilePath(new File(HtmlJarHandler.class.getProtectionDomain().getCodeSource().getLocation().toURI())));
            new HtmlJarHandler(htmlJarPath, reportData).copyHtmlToDir(workspace, build.getId());
            artifactMap.put("index.html", String.format("%s/%s", build.getId(), "index.html"));
            build.getArtifactManager().archive(workspace, launcher, (BuildListener)new BuildListenerAdapter(listener), artifactMap);
            listener.getLogger().println("Build Artifacts: " + (String)env.get((Object)"RUN_ARTIFACTS_DISPLAY_URL"));
            boolean doesBuildPass = true;
            if (this.isAutoFailCveEnabled && this.autoFailCveList != null && !this.autoFailCveList.trim().isEmpty()) {
                String[] cveArray;
                HashSet<String> autoFailCveSet = new HashSet<String>();
                for (String cve : cveArray = this.autoFailCveList.split("[,\\n\\r]+")) {
                    autoFailCveSet.add(cve.trim().toUpperCase());
                }
                listener.getLogger().println("Checking for " + autoFailCveSet.size() + " auto-fail CVE(s): " + String.valueOf(autoFailCveSet));
                boolean foundAutoFailCves = this.checkForAutoFailCves(sbomData, autoFailCveSet, listener);
                if (foundAutoFailCves) {
                    doesBuildPass = false;
                }
            }
            if (this.isSeverityThresholdEnabled) {
                boolean vulnThresholdsFailed = this.doesBuildFail(SbomOutputParser.aggregateCounts.getCounts());
                if (vulnThresholdsFailed) {
                    doesBuildPass = false;
                    this.logThresholdBreachDetails(sbomData, listener, SbomOutputParser.aggregateCounts.getCounts());
                }
            } else {
                listener.getLogger().println("Vulnerability thresholds disabled. Skipping threshold checks.");
            }
            if (this.isEpssThresholdEnabled && this.epssThreshold != null) {
                listener.getLogger().println("EPSS Threshold set to: " + this.epssThreshold);
                boolean cvesExceedThreshold = this.assessCVEsAgainstEPSS(build, workspace, listener, this.epssThreshold, sbomWorkspacePath);
                if (cvesExceedThreshold) {
                    doesBuildPass = false;
                }
            } else {
                listener.getLogger().println("EPSS assessment disabled or no threshold specified. Skipping EPSS assessment.");
            }
            if (doesBuildPass) {
                build.setResult(Result.SUCCESS);
            } else {
                build.setResult(Result.FAILURE);
            }
            if (this.isSeverityThresholdEnabled) {
                listener.getLogger().println("Results: " + SbomOutputParser.aggregateCounts.toString());
            }
            this.logSecurityAssessmentSummary(listener, suppressedCveSet, suppressedCount);
            listener.getLogger().println("Does Build Pass: " + doesBuildPass);
        }
    }

    private boolean assessCVEsAgainstEPSS(Run<?, ?> build, FilePath workspace, TaskListener listener, Double epssThreshold, String sbomPath) throws IOException, InterruptedException {
        FilePath sbomFile = workspace.child(sbomPath);
        if (!sbomFile.exists()) {
            listener.getLogger().println("SBOM file not found at: " + sbomFile.getRemote());
            return true;
        }
        try {
            String sbomContent = sbomFile.readToString();
            listener.getLogger().println("SBOM file read successfully.");
            Gson gson = new Gson();
            Sbom sbom = (Sbom)gson.fromJson(sbomContent, Sbom.class);
            listener.getLogger().println("SBOM JSON parsed successfully.");
            List<Vulnerability> vulnerabilities = sbom.getVulnerabilities();
            if (vulnerabilities == null || vulnerabilities.isEmpty()) {
                listener.getLogger().println("No vulnerabilities found in the SBOM.");
                return false;
            }
            HashSet<String> suppressedCveSet = new HashSet<String>();
            if (this.isSuppressedCveEnabled && this.suppressedCveList != null && !this.suppressedCveList.trim().isEmpty()) {
                String[] cveArray;
                for (String cve : cveArray = this.suppressedCveList.split("[,\\n\\r]+")) {
                    suppressedCveSet.add(cve.trim().toUpperCase());
                }
                listener.getLogger().println("Suppressing " + suppressedCveSet.size() + " CVEs from EPSS assessment: " + String.valueOf(suppressedCveSet));
            }
            listener.getLogger().println("Starting EPSS assessment for vulnerabilities...");
            boolean exceedsThreshold = false;
            HashMap<String, Double> exceedingCVEsMap = new HashMap<String, Double>();
            int suppressedCount = 0;
            for (Vulnerability vulnerability : vulnerabilities) {
                String cveId = vulnerability.getId();
                Double epssScore = vulnerability.getEpssScore();
                if (suppressedCveSet.contains(cveId.toUpperCase())) {
                    ++suppressedCount;
                    continue;
                }
                if (epssScore == null || !(epssScore >= epssThreshold)) continue;
                exceedsThreshold = true;
                exceedingCVEsMap.put(cveId, epssScore);
            }
            if (suppressedCount > 0) {
                listener.getLogger().println("Suppressed " + suppressedCount + " CVEs from EPSS assessment.");
            }
            if (exceedsThreshold) {
                listener.getLogger().println("The following CVEs exceed the EPSS threshold of " + epssThreshold + ":");
                int count = 0;
                for (Map.Entry entry : exceedingCVEsMap.entrySet()) {
                    if (count < 10) {
                        listener.getLogger().println(String.format("  - %s (EPSS: %.3f)", entry.getKey(), entry.getValue()));
                        ++count;
                        continue;
                    }
                    listener.getLogger().println("  ... and " + (exceedingCVEsMap.size() - count) + " more EPSS breaches (check assessment file for complete list)");
                    break;
                }
                listener.getLogger().println("Failing the build due to EPSS threshold breach.");
            } else {
                listener.getLogger().println("All assessed CVEs are within the EPSS threshold of " + epssThreshold + ".");
            }
            return exceedsThreshold;
        }
        catch (JsonParseException e) {
            listener.getLogger().println("Invalid JSON structure in SBOM file: " + e.getMessage());
            return true;
        }
        catch (IOException e) {
            listener.getLogger().println("Error reading SBOM file: " + e.getMessage());
            return true;
        }
    }

    private String getOidcToken(IdTokenStringCredentials oidcStr, IdTokenFileCredentials oidcFile) throws IOException {
        if (oidcStr != null) {
            return oidcStr.getSecret().getPlainText();
        }
        if (oidcFile != null) {
            return new String(oidcFile.getContent().readAllBytes(), StandardCharsets.UTF_8);
        }
        return null;
    }

    public static String getImageSha(String sbom) {
        try {
            JsonElement jsonElement = JsonParser.parseString((String)sbom);
            JsonObject metadata = jsonElement.getAsJsonObject().get("metadata").getAsJsonObject();
            JsonObject component = metadata.get("component").getAsJsonObject();
            JsonArray properties = component.getAsJsonObject().get("properties").getAsJsonArray();
            for (JsonElement property : properties) {
                if (!property.getAsJsonObject().get("name").getAsString().contains("image_id")) continue;
                return property.getAsJsonObject().get("value").getAsString();
            }
        }
        catch (Exception e) {
            logger.println("An exception occurred when getting image sha.");
            logger.println(e);
        }
        return "N/A";
    }

    @Generated
    public String getArchivePath() {
        return this.archivePath;
    }

    @Generated
    public String getArchiveType() {
        return this.archiveType;
    }

    @Generated
    public String getIamRole() {
        return this.iamRole;
    }

    @Generated
    public String getAwsRegion() {
        return this.awsRegion;
    }

    @Generated
    public String getCredentialId() {
        return this.credentialId;
    }

    @Generated
    public String getOidcCredentialId() {
        return this.oidcCredentialId;
    }

    @Generated
    public boolean isOsArch() {
        return this.osArch;
    }

    @Generated
    public int getCountCritical() {
        return this.countCritical;
    }

    @Generated
    public int getCountHigh() {
        return this.countHigh;
    }

    @Generated
    public int getCountMedium() {
        return this.countMedium;
    }

    @Generated
    public int getCountLow() {
        return this.countLow;
    }

    @Generated
    public String getAwsCredentialId() {
        return this.awsCredentialId;
    }

    @Generated
    public String getAwsProfileName() {
        return this.awsProfileName;
    }

    @Generated
    public String getSbomgenSelection() {
        return this.sbomgenSelection;
    }

    @Generated
    public String getSbomgenPath() {
        return this.sbomgenPath;
    }

    @Generated
    public String getSbomgenSkipFiles() {
        return this.sbomgenSkipFiles;
    }

    @Generated
    public Double getEpssThreshold() {
        return this.epssThreshold;
    }

    @Generated
    public Job<?, ?> getJob() {
        return this.job;
    }

    @Generated
    public boolean isShowThresholdDeprecationWarning() {
        return this.showThresholdDeprecationWarning;
    }

    @Generated
    public boolean isShowEpssDeprecationWarning() {
        return this.showEpssDeprecationWarning;
    }

    @Symbol(value={"amazonInspector"})
    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public AmazonInspectorBuilder newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            String sourceVal = formData.optString("sbomgenSource", null);
            formData.put("sbomgenSource", (Object)sourceVal);
            JSONObject selectionObj = formData.optJSONObject("sbomgenSelection");
            if (selectionObj != null && selectionObj.has("value")) {
                String sbomValue = selectionObj.getString("value");
                formData.put("sbomgenSelection", (Object)sbomValue);
                if ("manual".equalsIgnoreCase(sbomValue)) {
                    String manualPath = selectionObj.optString("sbomgenPath", "").trim();
                    if (manualPath.isEmpty()) {
                        throw new Descriptor.FormException("Manual SBOMGen selected but no path provided.", "sbomgenPath");
                    }
                    formData.put("sbomgenPath", (Object)manualPath);
                }
            }
            return (AmazonInspectorBuilder)((Object)req.bindJSON(AmazonInspectorBuilder.class, formData));
        }

        private ListBoxModel getCredentialIdModels() {
            ListBoxModel items = new ListBoxModel();
            List credentials = CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, Collections.emptyList());
            items.add("Select Docker Username", null);
            for (StandardUsernamePasswordCredentials credential : credentials) {
                if (credential.getUsername() == null || credential.getUsername().isEmpty()) continue;
                items.add(String.format("[%s] %s/*****", credential.getId(), credential.getUsername()), credential.getId());
            }
            return items;
        }

        private ListBoxModel getOidcStringIdModels() {
            ListBoxModel items = new ListBoxModel();
            List credentials = CredentialsProvider.lookupCredentials(IdTokenStringCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, Collections.emptyList());
            for (IdTokenStringCredentials credential : credentials) {
                items.add(credential.getId());
            }
            return items;
        }

        private ListBoxModel getOidcFileIdModels() {
            ListBoxModel items = new ListBoxModel();
            List credentials = CredentialsProvider.lookupCredentials(IdTokenFileCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, Collections.emptyList());
            for (IdTokenFileCredentials credential : credentials) {
                items.add(credential.getId());
            }
            return items;
        }

        @POST
        @SuppressFBWarnings
        public ListBoxModel doFillOidcCredentialIdItems() {
            if (Jenkins.get().hasPermission(Permission.READ)) {
                ListBoxModel items = new ListBoxModel();
                items.add("Select OIDC Credential ID", null);
                items.addAll((Collection)this.getOidcFileIdModels());
                items.addAll((Collection)this.getOidcStringIdModels());
                return items;
            }
            return new ListBoxModel();
        }

        @POST
        public ListBoxModel doFillCredentialIdItems() {
            if (Jenkins.get().hasPermission(Permission.READ)) {
                return this.getCredentialIdModels();
            }
            return new ListBoxModel();
        }

        @POST
        public FormValidation doCheckEpssThreshold(@QueryParameter String value) {
            Jenkins.get().checkPermission(Job.CONFIGURE);
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.ok();
            }
            try {
                double d = Double.parseDouble(value);
                if (d < 0.0 || d > 1.0) {
                    return FormValidation.error((String)"EPSS threshold must be between 0.0 and 1.0.");
                }
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)"EPSS threshold must be a numeric value between 0.0 and 1.0.");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckSuppressedCveList(@QueryParameter String value) {
            Jenkins.get().checkPermission(Job.CONFIGURE);
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.ok();
            }
            String[] cves = value.split("[,\\n\\r]+");
            int validCount = 0;
            for (String cve : cves) {
                if ((cve = cve.trim()).isEmpty()) continue;
                if (!cve.matches("^CVE-\\d{4}-\\d{4,}$")) {
                    return FormValidation.error((String)("Invalid CVE format: '" + cve + "'. Expected format: CVE-YYYY-NNNN (e.g., CVE-2023-1234)"));
                }
                ++validCount;
            }
            if (validCount > 0) {
                return FormValidation.ok((String)("Valid: " + validCount + " CVE" + (validCount > 1 ? "s" : "") + " will be suppressed"));
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckAutoFailCveList(@QueryParameter String value) {
            Jenkins.get().checkPermission(Job.CONFIGURE);
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.ok();
            }
            String[] cves = value.split("[,\\n\\r]+");
            int validCount = 0;
            for (String cve : cves) {
                if ((cve = cve.trim()).isEmpty()) continue;
                if (!cve.matches("^CVE-\\d{4}-\\d{4,}$")) {
                    return FormValidation.error((String)("Invalid CVE format: '" + cve + "'. Expected format: CVE-YYYY-NNNN (e.g., CVE-2023-1234)"));
                }
                ++validCount;
            }
            if (validCount > 0) {
                return FormValidation.ok((String)("Valid: " + validCount + " CVE" + (validCount > 1 ? "s" : "") + " will always fail the build"));
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckCountCritical(@QueryParameter String value) {
            Jenkins.get().checkPermission(Job.CONFIGURE);
            return this.validateNumericThreshold(value, "Critical");
        }

        @POST
        public FormValidation doCheckCountHigh(@QueryParameter String value) {
            Jenkins.get().checkPermission(Job.CONFIGURE);
            return this.validateNumericThreshold(value, "High");
        }

        @POST
        public FormValidation doCheckCountMedium(@QueryParameter String value) {
            Jenkins.get().checkPermission(Job.CONFIGURE);
            return this.validateNumericThreshold(value, "Medium");
        }

        @POST
        public FormValidation doCheckCountLow(@QueryParameter String value) {
            Jenkins.get().checkPermission(Job.CONFIGURE);
            return this.validateNumericThreshold(value, "Low");
        }

        private FormValidation validateNumericThreshold(String value, String fieldName) {
            Jenkins.get().checkPermission(Job.CONFIGURE);
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.error((String)(fieldName + " threshold cannot be empty."));
            }
            try {
                int intValue = Integer.parseInt(value);
                if (intValue < 0) {
                    return FormValidation.error((String)(fieldName + " threshold must be a non-negative integer."));
                }
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)(fieldName + " threshold must be a numeric value."));
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckArchivePath(@QueryParameter String value) {
            Jenkins.get().checkPermission(Job.CONFIGURE);
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.error((String)"Image Id is required. Provide a valid local/remote image name or path to an image tar file.");
            }
            if (!(value.contains(":") || value.contains("@") || value.endsWith(".tar"))) {
                return FormValidation.warning((String)"This doesn't look like a standard Docker image name or a tar file path. Verify it matches the expected format.");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckAwsRegion(@QueryParameter String value) {
            Jenkins.get().checkPermission(Job.CONFIGURE);
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.error((String)"You must select an AWS Region.");
            }
            if ("Select AWS Region".equals(value)) {
                return FormValidation.error((String)"Please select a AWS Region from the list.");
            }
            boolean isValid = false;
            for (String region : InspectorRegions.INSPECTOR_REGIONS) {
                if (!region.equals(value)) continue;
                isValid = true;
                break;
            }
            if (!isValid) {
                return FormValidation.error((String)"Please pick one from the list.");
            }
            return FormValidation.ok();
        }

        @SuppressFBWarnings
        private ListBoxModel getAwsCredentialIdModels() {
            ListBoxModel items = new ListBoxModel();
            List credentials = CredentialsProvider.lookupCredentials(AmazonWebServicesCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, Collections.emptyList());
            items.add("Select AWS Credentials", null);
            for (AmazonWebServicesCredentials credential : credentials) {
                if (credential == null || credential.getCredentials() == null) continue;
                items.add(String.format("[%s] %s", credential.getId(), credential.getDisplayName()), credential.getId());
            }
            return items;
        }

        @POST
        public ListBoxModel doFillAwsCredentialIdItems() {
            if (Jenkins.get().hasPermission(Permission.READ)) {
                return this.getAwsCredentialIdModels();
            }
            return new ListBoxModel();
        }

        public ListBoxModel doFillAwsRegionItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Select AWS Region", null);
            for (String region : InspectorRegions.INSPECTOR_REGIONS) {
                items.add(region, region);
            }
            return items;
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Amazon Inspector Scan";
        }
    }
}

