/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.jenkins.utils;

import hudson.util.ChartUtil;
import hudson.util.ShiftedCategoryAxis;
import hudson.util.StackedAreaRenderer2;
import java.awt.Color;
import java.awt.Paint;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleInsets;
import org.kohsuke.stapler.StaplerRequest;
import ru.yandex.qatools.allure.jenkins.AllureReportBuildAction;
import ru.yandex.qatools.allure.jenkins.Messages;

public final class ChartUtils {
    private ChartUtils() {
    }

    public static JFreeChart createChart(StaplerRequest req, CategoryDataset dataset) {
        final String relPath = ChartUtils.getRelPath(req);
        JFreeChart chart = ChartFactory.createStackedAreaChart((String)"Allure history trend", null, (String)"count", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setForegroundAlpha(0.8f);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        StackedAreaRenderer2 ar = new StackedAreaRenderer2(){

            public String generateURL(CategoryDataset dataset, int row, int column) {
                ChartUtil.NumberOnlyBuildLabel label = (ChartUtil.NumberOnlyBuildLabel)dataset.getColumnKey(column);
                return relPath + label.getRun().getNumber() + "/allure/";
            }

            public String generateToolTip(CategoryDataset dataset, int row, int column) {
                ChartUtil.NumberOnlyBuildLabel label = (ChartUtil.NumberOnlyBuildLabel)dataset.getColumnKey(column);
                AllureReportBuildAction buildAction = (AllureReportBuildAction)label.getRun().getAction(AllureReportBuildAction.class);
                String displayName = label.getRun().getDisplayName();
                switch (row) {
                    case 0: {
                        return String.valueOf(Messages._AllureReportBuildAction_failed(displayName, buildAction.getFailedCount()));
                    }
                    case 1: {
                        return String.valueOf(Messages._AllureReportBuildAction_broken(displayName, buildAction.getBrokenCount()));
                    }
                    case 2: {
                        return String.valueOf(Messages.AllureReportBuildAction_passed(displayName, buildAction.getPassedCount()));
                    }
                    case 3: {
                        return String.valueOf(Messages.AllureReportBuildAction_skipped(displayName, buildAction.getSkipCount()));
                    }
                    case 4: {
                        return String.valueOf(Messages.AllureReportBuildAction_unknown(displayName, buildAction.getUnknownCount()));
                    }
                }
                return String.valueOf(Messages.AllureReportBuildAction_total(displayName, buildAction.getTotalCount()));
            }
        };
        ar.setSeriesPaint(0, (Paint)new Color(16603710));
        ar.setSeriesPaint(1, (Paint)new Color(16765008));
        ar.setSeriesPaint(2, (Paint)new Color(9948260));
        ar.setSeriesPaint(3, (Paint)new Color(0xAAAAAA));
        ar.setSeriesPaint(4, (Paint)new Color(13852350));
        ar.setSeriesPaint(5, (Paint)new Color(7512015));
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
        plot.setRenderer((CategoryItemRenderer)ar);
        return chart;
    }

    private static String getRelPath(StaplerRequest req) {
        String relPath = req.getParameter("rel");
        if (relPath == null) {
            return "";
        }
        return relPath;
    }
}

