/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.jenkins.utils;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.EnvVars;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Computer;
import hudson.model.EnvironmentSpecific;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolInstallation;
import java.io.IOException;
import java.util.Objects;
import jenkins.model.Jenkins;

public final class BuildUtils {
    private BuildUtils() {
    }

    public static <T extends ToolInstallation & NodeSpecific<T>> T setUpTool(@Nullable T tool, @NonNull Launcher launcher, @NonNull TaskListener listener, @NonNull EnvVars env) throws IOException, InterruptedException {
        if (tool == null) {
            return null;
        }
        Computer computer = BuildUtils.getComputer(launcher);
        if (computer != null && computer.getNode() != null) {
            tool = (ToolInstallation)((NodeSpecific<T>)tool).forNode(computer.getNode(), listener);
        }
        tool = (ToolInstallation)((EnvironmentSpecific)tool).forEnvironment(env);
        tool.buildEnvVars(env);
        return tool;
    }

    public static Computer getComputer(Launcher launcher) {
        for (Computer computer : Jenkins.get().getComputers()) {
            if (!Objects.equals(computer.getChannel(), launcher.getChannel())) continue;
            return computer;
        }
        return null;
    }

    public static EnvVars getBuildEnvVars(Run<?, ?> run, TaskListener listener) throws IOException, InterruptedException {
        EnvVars env = run.getEnvironment(listener);
        if (run instanceof AbstractBuild) {
            env.overrideAll(((AbstractBuild)run).getBuildVariables());
        }
        return env;
    }
}

