/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.jenkins;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.matrix.MatrixAggregatable;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.JDK;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Recorder;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import jenkins.util.BuildListenerAdapter;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import ru.yandex.qatools.allure.jenkins.AllureReportBuildAction;
import ru.yandex.qatools.allure.jenkins.AllureReportProjectAction;
import ru.yandex.qatools.allure.jenkins.AllureReportPublisherDescriptor;
import ru.yandex.qatools.allure.jenkins.ReportBuilder;
import ru.yandex.qatools.allure.jenkins.callables.AddExecutorInfo;
import ru.yandex.qatools.allure.jenkins.callables.AddTestRunInfo;
import ru.yandex.qatools.allure.jenkins.callables.AllureReportArchive;
import ru.yandex.qatools.allure.jenkins.callables.FindByGlob;
import ru.yandex.qatools.allure.jenkins.config.AllureReportConfig;
import ru.yandex.qatools.allure.jenkins.config.PropertyConfig;
import ru.yandex.qatools.allure.jenkins.config.ReportBuildPolicy;
import ru.yandex.qatools.allure.jenkins.config.ResultPolicy;
import ru.yandex.qatools.allure.jenkins.config.ResultsConfig;
import ru.yandex.qatools.allure.jenkins.exception.AllurePluginException;
import ru.yandex.qatools.allure.jenkins.tools.AllureCommandlineInstallation;
import ru.yandex.qatools.allure.jenkins.utils.BuildSummary;
import ru.yandex.qatools.allure.jenkins.utils.BuildUtils;
import ru.yandex.qatools.allure.jenkins.utils.FilePathUtils;
import ru.yandex.qatools.allure.jenkins.utils.ZipUtils;

public class AllureReportPublisher
extends Recorder
implements SimpleBuildStep,
Serializable,
MatrixAggregatable {
    private static final String ALLURE_PREFIX = "allure";
    private static final String ALLURE_SUFFIX = "results";
    private static final String REPORT_ARCHIVE_NAME = "allure-report.zip";
    private AllureReportConfig config;
    private String configPath;
    private String jdk;
    private String commandline;
    private List<PropertyConfig> properties = new ArrayList<PropertyConfig>();
    private List<ResultsConfig> results;
    private ReportBuildPolicy reportBuildPolicy;
    private Boolean includeProperties;
    private Boolean disabled;
    private String report;
    private String reportName;
    private ResultPolicy resultPolicy;
    @Nullable
    private Integer unstableThresholdPercent;
    @Nullable
    private Integer failureThresholdPercent;
    @Nullable
    private Integer unstableThresholdCount;
    @Nullable
    private Integer failureThresholdCount;

    @DataBoundSetter
    public void setResultPolicy(ResultPolicy resultPolicy) {
        this.resultPolicy = resultPolicy;
    }

    public ResultPolicy getResultPolicy() {
        return this.resultPolicy == null ? ResultPolicy.UNSTABLE_IF_FAILED_OR_BROKEN : this.resultPolicy;
    }

    @DataBoundSetter
    public void setUnstableThresholdPercent(Integer value) {
        this.unstableThresholdPercent = value;
    }

    @DataBoundSetter
    public void setFailureThresholdPercent(Integer value) {
        this.failureThresholdPercent = value;
    }

    @DataBoundSetter
    public void setUnstableThresholdCount(Integer value) {
        this.unstableThresholdCount = value;
    }

    @DataBoundSetter
    public void setFailureThresholdCount(Integer value) {
        this.failureThresholdCount = value;
    }

    @Nullable
    public Integer getUnstableThresholdPercent() {
        return this.unstableThresholdPercent;
    }

    @Nullable
    public Integer getFailureThresholdPercent() {
        return this.failureThresholdPercent;
    }

    @Nullable
    public Integer getUnstableThresholdCount() {
        return this.unstableThresholdCount;
    }

    @Nullable
    public Integer getFailureThresholdCount() {
        return this.failureThresholdCount;
    }

    @DataBoundConstructor
    public AllureReportPublisher(@NonNull List<ResultsConfig> results) {
        this.results = results;
    }

    public List<ResultsConfig> getResults() {
        if (this.results == null && this.config != null) {
            this.results = this.config.getResults();
        }
        return this.results;
    }

    public boolean isDisabled() {
        return this.disabled == null ? Boolean.FALSE : this.disabled;
    }

    @DataBoundSetter
    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    @DataBoundSetter
    public void setConfig(AllureReportConfig config) {
        this.config = config;
    }

    @DataBoundSetter
    public void setConfigPath(String configPath) {
        this.configPath = configPath;
    }

    @DataBoundSetter
    public void setJdk(String jdk) {
        this.jdk = jdk;
    }

    public String getJdk() {
        if (this.jdk == null && this.config != null) {
            this.jdk = this.config.getJdk();
        }
        return this.jdk;
    }

    @DataBoundSetter
    public void setCommandline(String commandline) {
        this.commandline = commandline;
    }

    public String getCommandline() {
        if (this.commandline == null && this.config != null) {
            this.commandline = this.config.getCommandline();
        }
        return this.commandline;
    }

    private AllureCommandlineInstallation getCommandline(@NonNull Launcher launcher, @NonNull TaskListener listener, @NonNull EnvVars env) throws IOException, InterruptedException {
        AllureCommandlineInstallation installation = this.getDescriptor().getCommandlineInstallation(this.getCommandline());
        if (installation == null) {
            throw new AllurePluginException("Can not find any allure commandline installation.");
        }
        AllureCommandlineInstallation tool = BuildUtils.setUpTool(installation, launcher, listener, env);
        if (tool == null) {
            throw new AllurePluginException("Can not find any allure commandline installation for given environment.");
        }
        return tool;
    }

    @DataBoundSetter
    public void setProperties(List<PropertyConfig> properties) {
        this.properties = properties;
    }

    public List<PropertyConfig> getProperties() {
        if (this.config != null) {
            this.properties = this.config.getProperties();
        }
        return this.properties == null ? Collections.emptyList() : this.properties;
    }

    @DataBoundSetter
    public void setReportBuildPolicy(ReportBuildPolicy reportBuildPolicy) {
        this.reportBuildPolicy = reportBuildPolicy;
    }

    public ReportBuildPolicy getReportBuildPolicy() {
        if (this.reportBuildPolicy == null && this.config != null) {
            this.reportBuildPolicy = this.config.getReportBuildPolicy();
        }
        return this.reportBuildPolicy == null ? ReportBuildPolicy.ALWAYS : this.reportBuildPolicy;
    }

    @DataBoundSetter
    public void setIncludeProperties(Boolean includeProperties) {
        this.includeProperties = includeProperties;
    }

    public Boolean getIncludeProperties() {
        if (this.includeProperties == null && this.config != null) {
            this.includeProperties = this.config.getIncludeProperties();
        }
        return this.includeProperties == null ? Boolean.TRUE : this.includeProperties;
    }

    @DataBoundSetter
    public void setReport(String report) {
        this.report = report;
    }

    public String getReport() {
        return this.report == null ? "allure-report" : this.report;
    }

    public String getConfigPath() {
        return StringUtils.isNotBlank((String)this.configPath) ? this.configPath : null;
    }

    @DataBoundSetter
    public void setReportName(String reportName) {
        this.reportName = StringUtils.isBlank((String)reportName) ? null : reportName.trim();
    }

    @Nullable
    public String getReportName() {
        return this.reportName;
    }

    @NonNull
    public AllureReportConfig getConfig() {
        return this.config;
    }

    @NonNull
    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @NonNull
    public AllureReportPublisherDescriptor getDescriptor() {
        return (AllureReportPublisherDescriptor)super.getDescriptor();
    }

    public void perform(@NonNull Run<?, ?> run, @NonNull FilePath workspace, @NonNull EnvVars env, @NonNull Launcher launcher, @NonNull TaskListener listener) throws InterruptedException, IOException {
        if (this.isDisabled()) {
            listener.getLogger().println("Allure report is disabled.");
            return;
        }
        List<ResultsConfig> resultsConfigs = this.getResults();
        if (resultsConfigs == null) {
            throw new AllurePluginException("The property 'Results' have to be specified! Check your job's configuration.");
        }
        ArrayList<FilePath> results = new ArrayList<FilePath>();
        for (ResultsConfig resultsConfig : resultsConfigs) {
            String expandedPath = env.expand(resultsConfig.getPath());
            results.addAll((Collection)workspace.act((FilePath.FileCallable)new FindByGlob(expandedPath)));
        }
        this.prepareResults(results, run, workspace, listener);
        this.generateReport(results, run, workspace, env, launcher, listener);
        this.copyResultsToParentIfNeeded(results, run, listener);
    }

    private void copyResultsToParentIfNeeded(@NonNull List<FilePath> results, @NonNull Run<?, ?> run, @NonNull TaskListener listener) throws IOException, InterruptedException {
        if (run instanceof MatrixRun) {
            MatrixBuild parentBuild = ((MatrixRun)run).getParentBuild();
            FilePath workspace = parentBuild.getWorkspace();
            if (workspace == null) {
                listener.getLogger().format("Can not find workspace for parent build %s", parentBuild.getDisplayName());
                return;
            }
            FilePath aggregationDir = workspace.createTempDir(ALLURE_PREFIX, ALLURE_SUFFIX);
            listener.getLogger().format("Copy matrix build results to directory [%s]", aggregationDir);
            for (FilePath resultsPath : results) {
                FilePathUtils.copyRecursiveTo(resultsPath, aggregationDir, (AbstractBuild)parentBuild, listener.getLogger());
            }
        }
    }

    public MatrixAggregator createAggregator(MatrixBuild build, Launcher launcher, BuildListener listener) {
        final FilePath workspace = build.getWorkspace();
        if (workspace == null) {
            return null;
        }
        return new MatrixAggregator(build, launcher, listener){

            public boolean endBuild() throws InterruptedException, IOException {
                ArrayList<FilePath> resultsPaths = new ArrayList<FilePath>();
                for (FilePath directory : workspace.listDirectories()) {
                    if (!directory.getName().startsWith(AllureReportPublisher.ALLURE_PREFIX) || !directory.getName().contains(AllureReportPublisher.ALLURE_SUFFIX)) continue;
                    resultsPaths.add(directory);
                }
                EnvVars buildEnvVars = BuildUtils.getBuildEnvVars(this.build, (TaskListener)this.listener);
                AllureReportPublisher.this.generateReport((List<FilePath>)resultsPaths, (Run<?, ?>)this.build, workspace, buildEnvVars, this.launcher, (TaskListener)this.listener);
                for (FilePath resultsPath : resultsPaths) {
                    FilePathUtils.deleteRecursive(resultsPath, this.listener.getLogger());
                }
                return true;
            }
        };
    }

    private void generateReport(@NonNull List<FilePath> resultsPaths, @NonNull Run<?, ?> run, @NonNull FilePath workspace, @NonNull EnvVars env, @NonNull Launcher launcher, @NonNull TaskListener listener) throws IOException, InterruptedException {
        int exitCode;
        ReportBuildPolicy reportBuildPolicy = this.getReportBuildPolicy();
        if (!reportBuildPolicy.isNeedToBuildReport(run)) {
            listener.getLogger().printf("Allure report generation reject by policy [%s]%n", reportBuildPolicy.getTitle());
            return;
        }
        this.setAllureProperties(env);
        this.configureJdk(launcher, listener, env);
        AllureCommandlineInstallation commandline = this.getCommandline(launcher, listener, env);
        String reportDirPath = this.getReport();
        FilePath reportDirectoryInWorkspace = workspace.child(reportDirPath);
        ReportBuilder builder = new ReportBuilder(launcher, listener, workspace, env, commandline);
        if (this.getConfigPath() != null && workspace.child(this.getConfigPath()).exists()) {
            FilePath configFilePath = workspace.child(this.getConfigPath()).absolutize();
            listener.getLogger().println("Allure config file: " + String.valueOf(configFilePath.absolutize()));
            builder.setConfigFilePath(configFilePath);
        }
        if ((exitCode = builder.build(resultsPaths, reportDirectoryInWorkspace)) != 0) {
            throw new AllurePluginException("Can not generate Allure Report, exit code: " + exitCode);
        }
        listener.getLogger().println("Allure report was successfully generated.");
        this.saveAllureArtifact(run, workspace, listener, launcher);
        String reportName = reportDirectoryInWorkspace.getName();
        FilePath reportUnderBuild = new FilePath(run.getRootDir()).child(reportName);
        AllureReportBuildAction buildAction = new AllureReportBuildAction(FilePathUtils.extractSummary(run, reportName));
        buildAction.setReportPath(reportUnderBuild);
        run.addAction((Action)buildAction);
        this.applyResultStatus(run, buildAction.getBuildSummary());
    }

    private void applyResultStatus(Run<?, ?> run, BuildSummary summary) {
        Result thresholdResult = this.decideByThresholds(summary);
        if (thresholdResult != null) {
            run.setResult(thresholdResult);
            return;
        }
        Result target = this.getResultPolicy().decide(summary);
        if (target != null) {
            run.setResult(target);
        }
    }

    private void saveAllureArtifact(Run<?, ?> run, FilePath workspace, TaskListener listener, Launcher launcher) throws IOException, InterruptedException {
        FilePath reportUnderBuild;
        listener.getLogger().println("Archiving Allure report via ArtifactManager\u2026");
        String reportDirPath = this.getReport();
        FilePath reportPathWs = workspace.child(reportDirPath);
        if (!reportPathWs.exists()) {
            listener.error("Allure report directory not found: " + reportPathWs.getRemote());
            return;
        }
        String reportName = reportPathWs.getName();
        workspace.act((FilePath.FileCallable)new AllureReportArchive(reportDirPath, REPORT_ARCHIVE_NAME));
        Map<String, String> artifacts = Collections.singletonMap(REPORT_ARCHIVE_NAME, REPORT_ARCHIVE_NAME);
        BuildListener buildListener = listener instanceof BuildListener ? (BuildListener)listener : new BuildListenerAdapter(listener);
        run.pickArtifactManager().archive(workspace, launcher, buildListener, artifacts);
        listener.getLogger().println("Allure artifact archived via ArtifactManager.");
        FilePath zipPath = workspace.child(REPORT_ARCHIVE_NAME);
        if (zipPath.exists()) {
            zipPath.delete();
        }
        if ((reportUnderBuild = new FilePath(run.getRootDir()).child(reportName)).exists()) {
            reportUnderBuild.deleteRecursive();
        }
        reportPathWs.copyRecursiveTo(reportUnderBuild);
        listener.getLogger().println("Allure report copied to: " + reportUnderBuild.getRemote());
    }

    private void setAllureProperties(EnvVars envVars) {
        StringBuilder options = new StringBuilder();
        HashMap<String, String> properties = new HashMap<String, String>();
        for (PropertyConfig propertyConfig : this.getDescriptor().getProperties()) {
            properties.put(propertyConfig.getKey(), propertyConfig.getValue());
        }
        for (PropertyConfig propertyConfig : this.getProperties()) {
            properties.put(propertyConfig.getKey(), propertyConfig.getValue());
        }
        for (Map.Entry entry : properties.entrySet()) {
            String value = envVars.expand((String)entry.getValue());
            options.append(String.format("\"-D%s=%s\" ", entry.getKey(), value));
        }
        envVars.put("ALLURE_OPTS", options.toString());
    }

    @NonNull
    public Collection<? extends Action> getProjectActions(AbstractProject<?, ?> project) {
        return Collections.singleton(new AllureReportProjectAction((Job<?, ?>)project));
    }

    private void prepareResults(@NonNull List<FilePath> resultsPaths, @NonNull Run<?, ?> run, @NonNull FilePath workspace, @NonNull TaskListener listener) throws IOException, InterruptedException {
        this.addHistory(resultsPaths, run, workspace, listener);
        this.addTestRunInfo(resultsPaths, run);
        this.addExecutorInfo(resultsPaths, run);
    }

    private void addTestRunInfo(@NonNull List<FilePath> resultsPaths, @NonNull Run<?, ?> run) throws IOException, InterruptedException {
        long start = run.getStartTimeInMillis();
        long stop = run.getTimeInMillis();
        for (FilePath path : resultsPaths) {
            path.act((FilePath.FileCallable)new AddTestRunInfo(run.getFullDisplayName(), start, stop));
        }
    }

    private void addExecutorInfo(@NonNull List<FilePath> resultsPaths, @NonNull Run<?, ?> run) throws IOException, InterruptedException {
        String rootUrl = Jenkins.get().getRootUrl();
        String buildUrl = rootUrl + run.getUrl();
        String reportUrl = buildUrl + ALLURE_PREFIX;
        String buildId = run.getId();
        String effectiveReportName = StringUtils.isNotBlank((String)this.getReportName()) ? this.getReportName() : "AllureReport";
        AddExecutorInfo callable = new AddExecutorInfo(rootUrl, run.getFullDisplayName(), buildUrl, reportUrl, buildId, effectiveReportName);
        for (FilePath path : resultsPaths) {
            path.act((FilePath.FileCallable)callable);
        }
    }

    private void addHistory(@NonNull List<FilePath> resultsPaths, @NonNull Run<?, ?> run, @NonNull FilePath workspace, @NonNull TaskListener listener) {
        try {
            String reportPath = workspace.child(this.getReport()).getName();
            FilePath previousReport = FilePathUtils.getPreviousReportWithHistory(run, reportPath);
            if (previousReport == null) {
                return;
            }
            this.copyHistoryToResultsPaths(resultsPaths, previousReport, workspace);
        }
        catch (Exception e) {
            listener.getLogger().println("Cannot find a history information about previous builds.");
            listener.getLogger().println(e);
        }
    }

    private void copyHistoryToResultsPaths(@NonNull List<FilePath> resultsPaths, @NonNull FilePath previousReport, @NonNull FilePath workspace) throws IOException, InterruptedException {
        try (ZipFile archive = new ZipFile(previousReport.getRemote());){
            for (FilePath resultsPath : resultsPaths) {
                this.copyHistoryToResultsPath(archive, resultsPath, workspace);
            }
        }
    }

    private void copyHistoryToResultsPath(ZipFile archive, @NonNull FilePath resultsPath, @NonNull FilePath workspace) throws IOException, InterruptedException {
        FilePath reportPath = workspace.child(this.getReport());
        for (ZipEntry historyEntry : ZipUtils.listEntries(archive, reportPath.getName() + "/history")) {
            String historyFile = historyEntry.getName().replace(reportPath.getName() + "/", "");
            InputStream entryStream = archive.getInputStream(historyEntry);
            try {
                FilePath historyCopy = resultsPath.child(historyFile);
                historyCopy.copyFrom(entryStream);
            }
            finally {
                if (entryStream == null) continue;
                entryStream.close();
            }
        }
    }

    @Nullable
    private JDK getJdkInstallation() {
        return Jenkins.get().getJDK(this.getJdk());
    }

    @Nullable
    private Result decideByThresholds(@NonNull BuildSummary summary) {
        if (this.failureThresholdCount == null && this.failureThresholdPercent == null && this.unstableThresholdCount == null && this.unstableThresholdPercent == null) {
            return null;
        }
        long problems = summary.getFailedCount() + summary.getBrokenCount();
        long total = problems + summary.getPassedCount() + summary.getSkipCount() + summary.getUnknownCount();
        double ratio = total > 0L ? (double)problems * 100.0 / (double)total : 0.0;
        Result byCount = AllureReportPublisher.evaluateThresholdPair(problems, this.failureThresholdCount, this.unstableThresholdCount);
        Result byPercent = AllureReportPublisher.evaluateThresholdPair(ratio, this.failureThresholdPercent, this.unstableThresholdPercent);
        return AllureReportPublisher.worstResult(byCount, byPercent);
    }

    @Nullable
    private static Result evaluateThresholdPair(long actualValue, @Nullable Integer failureThreshold, @Nullable Integer unstableThreshold) {
        if (failureThreshold != null && actualValue >= (long)failureThreshold.intValue()) {
            return Result.FAILURE;
        }
        if (unstableThreshold != null && actualValue >= (long)unstableThreshold.intValue()) {
            return Result.UNSTABLE;
        }
        return null;
    }

    @Nullable
    private static Result evaluateThresholdPair(double actualPercent, @Nullable Integer failureThresholdPercentValue, @Nullable Integer unstableThresholdPercentValue) {
        if (failureThresholdPercentValue != null && actualPercent >= (double)failureThresholdPercentValue.intValue()) {
            return Result.FAILURE;
        }
        if (unstableThresholdPercentValue != null && actualPercent >= (double)unstableThresholdPercentValue.intValue()) {
            return Result.UNSTABLE;
        }
        return null;
    }

    @Nullable
    private static Result worstResult(@Nullable Result firstResult, @Nullable Result secondResult) {
        if (Result.FAILURE.equals(firstResult) || Result.FAILURE.equals(secondResult)) {
            return Result.FAILURE;
        }
        if (Result.UNSTABLE.equals(firstResult) || Result.UNSTABLE.equals(secondResult)) {
            return Result.UNSTABLE;
        }
        return null;
    }

    private void configureJdk(Launcher launcher, TaskListener listener, EnvVars env) throws IOException, InterruptedException {
        JDK jdk = BuildUtils.setUpTool(this.getJdkInstallation(), launcher, listener, env);
        if (jdk != null) {
            jdk.buildEnvVars(env);
        }
    }
}

