/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.jenkins.tools;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Functions;
import hudson.Launcher;
import hudson.Util;
import hudson.model.EnvironmentSpecific;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstaller;
import hudson.tools.ToolProperty;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import jenkins.security.MasterToSlaveCallable;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import ru.yandex.qatools.allure.jenkins.Messages;
import ru.yandex.qatools.allure.jenkins.tools.AllureCommandlineInstaller;

public class AllureCommandlineInstallation
extends ToolInstallation
implements EnvironmentSpecific<AllureCommandlineInstallation>,
NodeSpecific<AllureCommandlineInstallation> {
    private static final String CAN_FIND_ALLURE_MESSAGE = "Can't find allure commandline <%s>";
    private static final String ALLURE = "allure";

    @DataBoundConstructor
    public AllureCommandlineInstallation(String name, String home, List<? extends ToolProperty<?>> properties) {
        super(Util.fixEmptyAndTrim((String)name), Util.fixEmptyAndTrim((String)home), properties);
    }

    public String getExecutable(@NonNull Launcher launcher) throws InterruptedException, IOException {
        return (String)launcher.getChannel().call((Callable)new GetExecutable(this.getHome()));
    }

    public String getMajorVersion(@NonNull Launcher launcher) throws InterruptedException, IOException {
        return (String)launcher.getChannel().call((Callable)new GetMajorVersion(this.getHome()));
    }

    private static Path getHomePath(String rawHome) {
        String home = Util.replaceMacro((String)rawHome, (Map)EnvVars.masterEnvVars);
        if (home == null) {
            return null;
        }
        Path homePath = Paths.get(home, new String[0]);
        if (Files.exists(homePath.resolve("bin").resolve(ALLURE), new LinkOption[0])) {
            return homePath;
        }
        File[] listOfFiles = homePath.toFile().listFiles();
        if (listOfFiles == null || listOfFiles.length == 0) {
            return null;
        }
        File allureDir = null;
        for (File file : listOfFiles) {
            if (!file.isDirectory() || !file.getName().startsWith(ALLURE)) continue;
            allureDir = file;
        }
        return allureDir == null ? null : allureDir.toPath();
    }

    private static Path getExecutablePath(String rawHome) {
        Path home = AllureCommandlineInstallation.getHomePath(rawHome);
        return home == null ? null : home.resolve(Functions.isWindows() ? "bin/allure.bat" : "bin/allure");
    }

    public AllureCommandlineInstallation forEnvironment(@NonNull EnvVars environment) {
        return new AllureCommandlineInstallation(this.getName(), environment.expand(this.getHome()), this.getProperties().toList());
    }

    public AllureCommandlineInstallation forNode(@NonNull Node node, TaskListener log) throws IOException, InterruptedException {
        return new AllureCommandlineInstallation(this.getName(), this.translateFor(node, log), this.getProperties().toList());
    }

    public void buildEnvVars(EnvVars env) {
        Path home = AllureCommandlineInstallation.getHomePath(this.getHome());
        if (home != null) {
            env.put("ALLURE_HOME", home.toAbsolutePath().toString());
        }
    }

    @Extension
    @Symbol(value={"allure"})
    public static class DescriptorImpl
    extends ToolDescriptor<AllureCommandlineInstallation> {
        public DescriptorImpl() {
            this.load();
        }

        @NonNull
        public String getDisplayName() {
            return Messages.AllureCommandlineInstallation_DisplayName();
        }

        public List<? extends ToolInstaller> getDefaultInstallers() {
            return Collections.singletonList(new AllureCommandlineInstaller(null));
        }

        public void setInstallations(AllureCommandlineInstallation ... installations) {
            super.setInstallations((ToolInstallation[])installations);
            this.save();
        }
    }

    private static final class GetExecutable
    extends MasterToSlaveCallable<String, IOException> {
        private final String rawHome;

        GetExecutable(String rawHome) {
            this.rawHome = rawHome;
        }

        public String call() throws IOException {
            Path executable = AllureCommandlineInstallation.getExecutablePath(this.rawHome);
            if (executable == null || Files.notExists(executable, new LinkOption[0])) {
                throw new IOException(String.format(AllureCommandlineInstallation.CAN_FIND_ALLURE_MESSAGE, executable));
            }
            return executable.toAbsolutePath().toString();
        }
    }

    private static final class GetMajorVersion
    extends MasterToSlaveCallable<String, IOException> {
        private final String rawHome;

        GetMajorVersion(String rawHome) {
            this.rawHome = rawHome;
        }

        public String call() throws IOException {
            Path home = AllureCommandlineInstallation.getHomePath(this.rawHome);
            if (home == null || Files.notExists(home, new LinkOption[0])) {
                throw new IOException(String.format(AllureCommandlineInstallation.CAN_FIND_ALLURE_MESSAGE, home));
            }
            return Files.exists(home.resolve("app/allure-bundle.jar"), new LinkOption[0]) ? "1" : "2";
        }
    }
}

