/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.jenkins.dsl;

import javaposse.jobdsl.dsl.Context;
import ru.yandex.qatools.allure.jenkins.AllureReportPublisher;
import ru.yandex.qatools.allure.jenkins.config.PropertyConfig;
import ru.yandex.qatools.allure.jenkins.config.ReportBuildPolicy;
import ru.yandex.qatools.allure.jenkins.config.ResultPolicy;

class AllureReportPublisherContext
implements Context {
    private static final String FAILURE_POLICY = "FAILURE";
    private final AllureReportPublisher publisher;

    AllureReportPublisherContext(AllureReportPublisher publisher) {
        this.publisher = publisher;
    }

    public AllureReportPublisher getPublisher() {
        return this.publisher;
    }

    public void buildFor(String buildPolicy) {
        String policy = FAILURE_POLICY.equals(buildPolicy) ? ReportBuildPolicy.UNSUCCESSFUL.getValue() : buildPolicy;
        this.getPublisher().setReportBuildPolicy(ReportBuildPolicy.valueOf(policy));
    }

    public void jdk(String jdk) {
        this.getPublisher().setJdk(jdk);
    }

    public void disabled(boolean disabled) {
        this.getPublisher().setDisabled(disabled);
    }

    public void commandline(String commandline) {
        this.getPublisher().setCommandline(commandline);
    }

    public void property(String key, String value) {
        this.getPublisher().getProperties().add(new PropertyConfig(key, value));
    }

    public void includeProperties(boolean includeProperties) {
        this.getPublisher().setIncludeProperties(includeProperties);
    }

    public void configPath(String configPath) {
        this.getPublisher().setConfigPath(configPath);
    }

    public void resultPolicy(String policy) {
        this.getPublisher().setResultPolicy(ResultPolicy.valueOf(policy));
    }

    public void unstableThresholdPercent(int value) {
        this.getPublisher().setUnstableThresholdPercent(value);
    }

    public void failureThresholdPercent(int value) {
        this.getPublisher().setFailureThresholdPercent(value);
    }

    public void unstableThresholdCount(int value) {
        this.getPublisher().setUnstableThresholdCount(value);
    }

    public void failureThresholdCount(int value) {
        this.getPublisher().setFailureThresholdCount(value);
    }
}

