/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.jenkins;

import hudson.FilePath;
import hudson.Util;
import hudson.model.Action;
import hudson.model.BuildBadgeAction;
import hudson.model.Job;
import hudson.model.Run;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import hudson.util.Graph;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.servlet.ServletException;
import jenkins.model.RunAction2;
import jenkins.model.lazy.LazyBuildMixIn;
import jenkins.tasks.SimpleBuildStep;
import org.jfree.chart.JFreeChart;
import org.jfree.data.category.CategoryDataset;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import ru.yandex.qatools.allure.jenkins.AllureReportPlugin;
import ru.yandex.qatools.allure.jenkins.AllureReportProjectAction;
import ru.yandex.qatools.allure.jenkins.Messages;
import ru.yandex.qatools.allure.jenkins.utils.BuildSummary;
import ru.yandex.qatools.allure.jenkins.utils.ChartUtils;
import ru.yandex.qatools.allure.jenkins.utils.FilePathUtils;

public class AllureReportBuildAction
implements BuildBadgeAction,
RunAction2,
SimpleBuildStep.LastBuildAction {
    private static final String ALLURE_REPORT = "allure-report";
    private static final String CACHE_CONTROL = "Cache-Control";
    private static final String WAS_ATTACHED_TO_BOTH = "%s was attached to both %s and %s";
    private static final String SLASH = "/";
    private Run<?, ?> run;
    private transient WeakReference<BuildSummary> buildSummary;
    private String reportPath;

    AllureReportBuildAction(BuildSummary buildSummary) {
        this.buildSummary = new WeakReference<BuildSummary>(buildSummary);
        this.reportPath = ALLURE_REPORT;
    }

    private String getReportPath() {
        return this.reportPath == null ? ALLURE_REPORT : this.reportPath;
    }

    public void setReportPath(FilePath reportPath) {
        this.reportPath = reportPath.getName();
    }

    public void doGraph(final StaplerRequest req, StaplerResponse rsp) throws IOException {
        final CategoryDataset data = this.buildDataSet();
        new Graph(-1L, 600, 300){

            protected JFreeChart createGraph() {
                return ChartUtils.createChart(req, data);
            }
        }.doPng(req, rsp);
    }

    public void doGraphMap(final StaplerRequest req, StaplerResponse rsp) throws IOException {
        final CategoryDataset data = this.buildDataSet();
        new Graph(-1L, 600, 300){

            protected JFreeChart createGraph() {
                return ChartUtils.createChart(req, data);
            }
        }.doMap(req, rsp);
    }

    public boolean hasSummaryLink() {
        return this.buildSummary != null;
    }

    public BuildSummary getBuildSummary() {
        BuildSummary data;
        if (this.buildSummary == null || this.buildSummary.get() == null) {
            this.buildSummary = new WeakReference<BuildSummary>(FilePathUtils.extractSummary(this.run, this.getReportPath()));
        }
        return (data = (BuildSummary)this.buildSummary.get()) != null ? data : new BuildSummary();
    }

    public long getFailedCount() {
        return this.getBuildSummary().getFailedCount();
    }

    public long getPassedCount() {
        return this.getBuildSummary().getPassedCount();
    }

    public long getSkipCount() {
        return this.getBuildSummary().getSkipCount();
    }

    public long getBrokenCount() {
        return this.getBuildSummary().getBrokenCount();
    }

    public long getUnknownCount() {
        return this.getBuildSummary().getUnknownCount();
    }

    public long getTotalCount() {
        return this.getFailedCount() + this.getBrokenCount() + this.getPassedCount() + this.getSkipCount() + this.getUnknownCount();
    }

    public String getBuildNumber() {
        return this.run.getId();
    }

    public String getDisplayName() {
        return Messages.AllureReportPlugin_Title();
    }

    public String getIconFileName() {
        return AllureReportPlugin.getIconFilename();
    }

    public String getUrlName() {
        return "allure";
    }

    public AllureReportBuildAction getPreviousResult() {
        return this.getPreviousResult(true);
    }

    private AllureReportBuildAction getPreviousResult(boolean eager) {
        AllureReportBuildAction r;
        Run b = this.run;
        Set loadedBuilds = !eager && this.run.getParent() instanceof LazyBuildMixIn.LazyLoadingJob ? ((LazyBuildMixIn.LazyLoadingJob)this.run.getParent()).getLazyBuildMixIn()._getRuns().getLoadedBuilds().keySet() : null;
        do {
            Object object = b = loadedBuilds == null || loadedBuilds.contains(b.number - 1) ? b.getPreviousBuild() : null;
            if (b != null) continue;
            return null;
        } while ((r = (AllureReportBuildAction)b.getAction(AllureReportBuildAction.class)) == null);
        if (r.equals(this)) {
            throw new IllegalStateException(String.format(WAS_ATTACHED_TO_BOTH, this, b, this.run));
        }
        if (r.run.number != b.number) {
            throw new IllegalStateException(String.format(WAS_ATTACHED_TO_BOTH, r, b, r.run));
        }
        return r;
    }

    public Collection<? extends Action> getProjectActions() {
        Job job = this.run.getParent();
        if (!Util.filter((List)job.getActions(), AllureReportProjectAction.class).isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.singleton(new AllureReportProjectAction(job));
    }

    private CategoryDataset buildDataSet() {
        DataSetBuilder dsb = new DataSetBuilder();
        for (AllureReportBuildAction a = this; a != null; a = a.getPreviousResult()) {
            ChartUtil.NumberOnlyBuildLabel columnKey = new ChartUtil.NumberOnlyBuildLabel(a.run);
            dsb.add((Number)a.getFailedCount(), (Comparable)((Object)"a_failed"), (Comparable)columnKey);
            dsb.add((Number)a.getBrokenCount(), (Comparable)((Object)"b_broken"), (Comparable)columnKey);
            dsb.add((Number)a.getPassedCount(), (Comparable)((Object)"c_passed"), (Comparable)columnKey);
            dsb.add((Number)a.getSkipCount(), (Comparable)((Object)"d_skipped"), (Comparable)columnKey);
            dsb.add((Number)a.getUnknownCount(), (Comparable)((Object)"e_unknown"), (Comparable)columnKey);
        }
        return dsb.build();
    }

    public String getBuildUrl() {
        return this.run.getUrl();
    }

    public void onAttached(Run<?, ?> attachedRun) {
        this.run = attachedRun;
    }

    public void onLoad(Run<?, ?> loadedRun) {
        this.run = loadedRun;
    }

    public Object doDynamic(StaplerRequest request, StaplerResponse response) throws IOException, InterruptedException {
        String reportDirName;
        FilePath runRootDir = new FilePath(this.run.getRootDir());
        FilePath reportDirectoryUnderBuild = runRootDir.child(reportDirName = this.getReportPath());
        if (reportDirectoryUnderBuild.exists()) {
            return new DirectoryReportBrowser(reportDirectoryUnderBuild);
        }
        FilePath archivedZip = runRootDir.child("archive/allure-report.zip");
        if (archivedZip.exists()) {
            ArchiveReportBrowser browser = new ArchiveReportBrowser(archivedZip);
            browser.setReportPath(reportDirName);
            return browser;
        }
        response.sendError(404, "Allure report not found. Neither directory '" + reportDirectoryUnderBuild.getRemote() + "' nor archive '" + archivedZip.getRemote() + "' exists.");
        return null;
    }

    private static class ArchiveReportBrowser
    implements HttpResponse {
        private final FilePath archive;
        private String reportPath;

        ArchiveReportBrowser(FilePath archive) {
            this.archive = archive;
            this.reportPath = AllureReportBuildAction.ALLURE_REPORT;
        }

        public void setReportPath(String reportPath) {
            this.reportPath = reportPath;
        }

        public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
            rsp.setHeader(AllureReportBuildAction.CACHE_CONTROL, "no-cache, no-store, must-revalidate");
            rsp.addHeader(AllureReportBuildAction.CACHE_CONTROL, "post-check=0, pre-check=0");
            rsp.setHeader("Pragma", "no-cache");
            rsp.setDateHeader("Expires", 0L);
            String path = req.getRestOfPath().isEmpty() ? "/index.html" : req.getRestOfPath();
            try (ZipFile allureReport = new ZipFile(this.archive.getRemote());){
                ZipEntry entry = allureReport.getEntry(this.reportPath + path);
                if (entry != null) {
                    rsp.serveFile(req, allureReport.getInputStream(entry), -1L, -1L, -1L, entry.getName());
                } else {
                    rsp.sendRedirect("/index.html#404");
                }
            }
        }
    }

    private static final class DirectoryReportBrowser
    implements HttpResponse {
        private final FilePath baseDirectory;

        DirectoryReportBrowser(FilePath baseDirectory) {
            this.baseDirectory = baseDirectory;
        }

        public void generateResponse(StaplerRequest request, StaplerResponse response, Object node) throws IOException, ServletException {
            response.setHeader("Content-Security-Policy", "");
            response.setHeader("X-Content-Type-Options", "nosniff");
            String relativePath = request.getRestOfPath();
            if (relativePath == null || relativePath.isEmpty() || AllureReportBuildAction.SLASH.equals(relativePath)) {
                relativePath = "index.html";
            } else if (relativePath.startsWith(AllureReportBuildAction.SLASH)) {
                relativePath = relativePath.substring(1);
            }
            if (relativePath.contains("..")) {
                response.sendError(400, "Illegal path");
                return;
            }
            FilePath fileToServe = this.baseDirectory.child(relativePath);
            try {
                if (!fileToServe.exists()) {
                    response.sendRedirect2(request.getRequestURI().replaceAll("/+$", AllureReportBuildAction.SLASH));
                    return;
                }
            }
            catch (InterruptedException interrupted) {
                Thread.currentThread().interrupt();
                throw new IOException("Interrupted while checking report file existence", interrupted);
            }
            try (InputStream inputStream = fileToServe.read();){
                response.serveFile(request, inputStream, -1L, -1L, -1L, fileToServe.getName());
            }
            catch (InterruptedException interrupted) {
                Thread.currentThread().interrupt();
                throw new IOException("Interrupted while reading report file", interrupted);
            }
        }
    }
}

